(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    626024,      10877]
NotebookOptionsPosition[    622840,      10780]
NotebookOutlinePosition[    623206,      10796]
CellTagsIndexPosition[    623163,      10793]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["The Pontencial, ",
 FontFamily->"Times New Roman",
 FontSize->16]], "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4210252089700003`*^9, 3.42102522176*^9}, 
   3.4216009372932*^9}],

Cell[BoxData[{
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"], "y"}], "-", 
      RowBox[{
       FractionBox["2", "3"], 
       SuperscriptBox["y", "3"]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
   RowBox[{"Contours", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "2.4", ",", "2.2", ",", "2", ",", "1.8", ",", "1.6", ",", "1.4", ",", 
      "1.2", ",", "1", ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "4"}], ",", 
      RowBox[{"1", "/", "6"}], ",", 
      RowBox[{"1", "/", "8"}], ",", 
      RowBox[{"1", "/", "12"}], ",", 
      RowBox[{"1", "/", "24"}], ",", 
      RowBox[{"1", "/", "100"}], ",", 
      RowBox[{"1", "/", "1000"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"], "y"}], "-", 
      RowBox[{
       FractionBox["2", "3"], 
       SuperscriptBox["y", "3"]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
   RowBox[{"MeshFunctions", "->", 
    RowBox[{"{", 
     RowBox[{"#3", "&"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<DarkRainbow\>\"", "]"}], "[", "#3", 
       "]"}], "&"}], ")"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"], "y"}], "-", 
      RowBox[{
       FractionBox["2", "3"], 
       SuperscriptBox["y", "3"]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", ".4"}], ",", ".4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     RowBox[{"-", ".4"}], ",", ".4"}], "}"}], ",", 
   RowBox[{"MeshFunctions", "->", 
    RowBox[{"{", 
     RowBox[{"#3", "&"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<DarkRainbow\>\"", "]"}], "[", "#3", 
       "]"}], "&"}], ")"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"], "y"}], "-", 
      RowBox[{
       FractionBox["2", "3"], 
       SuperscriptBox["y", "3"]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
   RowBox[{"MeshFunctions", "->", 
    RowBox[{"{", 
     RowBox[{"#3", "&"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<DarkRainbow\>\"", "]"}], "[", "#3", 
       "]"}], "&"}], ")"}]}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4210904570934*^9, 3.4210905130214*^9}, {
   3.4210905782138*^9, 3.421090612877*^9}, {3.4210907294714003`*^9, 
   3.4210907729954*^9}, {3.4210908519002*^9, 3.4210908667514*^9}, {
   3.4210911499382*^9, 3.4210911565214*^9}, {3.4210912102946*^9, 
   3.4210912137734003`*^9}, {3.421091293271*^9, 3.4210913220062*^9}, 
   3.4210913595086*^9, 3.421091464559*^9, {3.4210915548361998`*^9, 
   3.4210918570550003`*^9}, {3.4210918958834*^9, 3.4210919141977997`*^9}, 
   3.421091945585*^9, {3.4210920498241997`*^9, 3.421092050183*^9}, {
   3.4212889721532*^9, 3.4212889935182*^9}, {3.4212897897022*^9, 
   3.4212898092102003`*^9}, 3.4216009372932*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnQV0VUfXhrHiLsVdi0uh+EChuBcpUty9WLHiULy4u2txl8FdEiQBkkA8
hOi9wUvhT3POM3ex82d9gbXOeu/4zJ5tYwV7DmvTJ0miRIn+ypEo0X/fSnF/
MZpvqxSjY/9HG/zs+BCv40PCDM7azZGtmyPI4BZx8X0NzhQX/tjgtHH4qsGJ
4v6O1gQXsMIVOLeV3uCfrfwNzmGVb/Bzq34Gt7Hqb7D9ldi0U35pL5j2gmkv
mPaCaS+Y9oJpL5j2gmkvmPaCaS+Y9opxkzheu8DyS3vBtBdMe8G0F0x7wbQX
THvBtBdMe8G0F0x7BV1KHG/cZLvA8kt7wbQXTHvBtBdMe8G0F0x7wbQXTHvB
tFfMO4nj0aUcN9kusPzSXjDtBdNeMO0F014w7QXTXjDtBdNewVckjjfvJF3K
cZPtAssv7QXTXjDtBdNeMO0F014w7QXTXsE3JY7HV+S8k3Qpx022Cyy/tBdM
e8G0F0x7wbQXTHvBtFfIBYnj8U3JV+S8k3Qpx022Cyy/tBdMe8G0F0x7wbQX
THuF3JM4nlyQfFPyFTnvJF3KcZPtAssv7QXTXjDtBdNeMO0Vcl3ieHJPygXJ
NyVfkfNO0qUcN9kusPzSXjDtBdNeMO0VeovE8eS6lHtSLki+KfmKnHeSLuW4
yXaB5Zf2gmkvmPYKvUzieHqLlOtS7km5IPmm5Cty3km6lOMm2wWWX9oLpr1C
75Q4nl4m9RYp16Xck3JB8k3JV+S8k3Qpx022Cyy/tFfo1RLH0zulXib1FinX
pdyTckHyTclX5LyTdCnHTbYLLL+0NyE7QurZUg+VeprUY6Scl3JQygnJRyWf
kfNQ0qkcR9lO+f0x76O6eR85+OqL/qXO+5eKVOesryZcYP1u7oH3cw+81PwO
/sf6KjD5gclPYF0hrj4BJj8w8cDkDyZ/MPkLrD3i+sXL5A8mfzDpwFUsrMCU
D6Z8MOULrJvFjYObKR9M+WDKB1M+mPLBlA+mfBk/SRydHDPxwcQX2HyZD2Dy
k5h2kb+kJ+YR5cl5JsqV8U2/0R8SS/pjnlK+nLeSvqW9TH7UEyy/vtY4K4kZ
R+on6Re+Qf0kH5HzRdq35Ef9wLQD3N6iAyUx9El9Jb3Dx6iv5ONy/km+J+ej
tFcpj/qCS1p0qCSGnqk/mPrL+SLlqpy/Ug7J+Uw49QdTPvOF8sHwY1kfwqmP
nJ9SDsr5TTj1kXqgrA/9Rn0Ipz6EUx/CqQ/htBeMPAJTPlimk1/ql1A/kl7G
A8tvQv0s2wkmPzD5JMRnE+oXMPmByS8hPi35MPmByQ9MfpKvSj4q+X4CfN2E
M08pX8YnnPoQTnzCqR/hxBd8Pd5X8n3aQb8JvSse/5d+TMl/4ZfEB1M/+BHx
wbRPzncw8WU485FwMOXLcPQ+wsG0X9rtlMP8AxOPfIkPJn5C9ZL1ID2Y9LId
sp5g0oNJL/kc9Ex6MOnBpJf0D/1Ivkh+YPIDk18CdBiPT0s+yfyBTxMfTHww
4wSuvmt67H+nFt8Ef4/s+l9+23WTJUUaLyniULXj8t+uwISLfMyXeSH9wVL/
lfKQ3ykn+X8/twox/YJ8D9+U/lXsf1Wo8X8RA438Izy1lU7VietfP+1257+/
cIMZT+nvpX7kBya/13H1e2LogHDafSqOXp6b/GS/8nuDuHIvmN/pX3AnK9xg
xleOG/WA/kQ5CcXXIlzW1+Qnx1vmC6bf+TLeYMaR/gfTn9SD/oO+Zf9QHnRC
OeQHPSRkxxGfeHyhB+lnkHaJ9CshH6BPMOml/Ur5/C79NNK+lfOH+sJPaBf6
kLQ/mV/8Lv220C/5gckPTL8zPvQTfIl+AVNfMOWBKU/q19IPI/UCMPGl3JF+
OakXSrkk5RrtJhxMPcmX+FLvZhwJB5OfxLST+U47CZd8Rtr1YGlHC/1KC31K
C/3JyGXw4ff/EWKUamzNfzMPwZJOpR+F/MHFLbpVdyw+bPIHkz+YcpjX0m9B
e8G0F0x7wcgL8qN8MOWDqQf8SvpppN+E+oCpj/Tr8CU9mPRg6AH+eNmadwbT
HsE/DZblyC/lgRmfB3Hpbpv8wZLO5DjIfpDtkuXKL+1DzlAfcEJ2ubT/+FaN
q89DM6/IHyztIEk3lCftfmk/gimPr7T7pN0m7RY5L6WfRPodKId2SbtS2oXS
rqP8hPiAtHukXwm6YJyoD5h4fClf8BmJ4/n1wIwbdEl5YPIhvvxSvvAjShzP
Dy39yNLvCqY/4CvQLVjWQ36pT0J+cOmXk35fyocPyHbKcqzkTvNFz0MPQ1/+
26q/0cfBlCOwfmmNh+HfYMLhr6QDUx7xKU+kl9joQ/BrMPo6mPzB5Aemvug3
5A8/pb6EUw8w7ZDhpK9vyRGjPzFPwIQTn/oTDp2DoSsw/QWmPWWteWLqByZ/
MP0DJn8w+cv02DFgaTdKO0dgLfQLI2fIj36n/WD0IqmfkJ78JH1CJ6SX+oec
d5KemYfkByYe/fzZGkdDX/BpMOMNhh4kfcr1AEnv8OVga/6b8Yc/ggmHvqgf
4dQPTDjx4a+Ew1/A9Jekf6nPQD/UD0z94GOUL/URyXdJT/2hL/oXTP+CqS+Y
9Mh1ysfuJBxMfsSHXsGUT3zCZX7oH7SfL/0Dpj4ynvydfPldhlMvMO0gHuH0
u5znjAPpCae+YNLDV+ALYPpBYvgO+RMOJpz8JZ9hXhOfcDDzCkx86Fnwl3j8
Q9o3zEfmBxi9jvlAfIklv8f+pT/Jh/qSDky5xKcd9A/zhP4H099g8pP6DPOE
9GDSg0kvw7FvCQfbeoc+H1eeU6OHCGx+vxZX/nJ9rcPEqx0mOlTfuPyXq3tx
9BFtMOE148o5SP6Gj0p5ye/QmfSfSH+ewGb8rsdV9Iypb5SFjX5F/ShX+oXI
HzlDuLSvpd9S7jMgH7GOqIW/Wgt/tRb+ai381Vr4I4x/SNoNhNNOsNA3jXzD
j8SX9pIOOYd/SfaL3Gct91kktO+C+sv5TH7wGeQY4y31X+LzO/Hpf8qj/8H0
P5j+B9P/YOYN+VM/qS/QD/Ar/BfQi/QDgqkfmPqBqR8Yvxfl0z9gxlPOH+YL
9WFcqA+Y+kg/htxnSzj8j/zBcl+f1KfRH+hfwuW4yX4iX+nHkfucpd9F7gvm
d+or7WriU1/kHPWl/tCx8JcaTLj0d4AZj4T8WLRP1htMPOnXkX4Z4qOnyHU4
MPOKdNC1rL/cnyz9bnIdVbZH+qXl/mW5ji/3Qcp1eclHpX9H7teVfkq5Lizr
L/1Tcj+y9FfJ/cnSzy39U3Lfn/RXES75Ju2T+3OlH1iuU8h9S3L/cUL7hOS6
Nu0lPfMJvZZ6g+EHch+G3Ncp/WdyH6T0p8n919K/JffzSn+bXMeU+4ak/w19
nd/lPlTpf5P7NqU/Tu6nlv4xuT9X7ruU/ju5rpXQvigw4eib8D2w3G9Men6X
fj+5D1f64eS+Vek3k/ut5X4AuX9X7vuT/jy5zi33gYEZXzDtl/uLpV9T7jOW
fka5L1f6BeV+a36Xfhahp0k/Rbx1Q9oj+xks1ltNvQinXPRK9BqpT8AHCKdc
5j9yCf4g/bRy/UH6ncFyXxryjHwpR+5Tk+cg4B+kl34IuY4JJh71YnzoL/Rm
9EX6Ff8U/IV+Q29D/6H/wIw3fAh9F/2D8sCUS/+TH+GUR7hcZ5V+CEGP8fyG
0AW/gxOiY760g/JoB/Qn/dGEg5nn5E84+TIvkDvkR/70A/mJ/QhSv4+3vxa9
CPua+NCh9H8znpQv/N1mXoGlHgi9YN+TnnkBJpz5CWb86W8w/ED6m0kPlvtj
pb4v/dHSjwV90R/STyX3YUp/IvwBzDxF75P+PPqF8ZeY+ORHOJhw+k+u+1GO
9GNKP6P0C9Ju5D/9Lv2kYOn3ZBzkuMGP/te8FP5+6beP50cQ/iKD8ff0tvw9
+I+MnBDlxdsPmlA84b8w8eU+COpJPzL/+cJv4RNyf4G0w6BnMP3KfCcczDgy
vmDkitQT0ZuhA+gZLPd1SnqX+zYJh26l3i0x9SadtAPlOr2cN1LOUs+E5in0
Sv5Srst5J+kfvkG4xNC/9GPadGkw9C38YIZe4SPMH+abxNLuJFz61fCX4h+l
HDF/4u3bJBw5Bf1Bp3J9UO7XRB4xL9P9l8umYMNfkR+UB6bcPXH5vpD+Xy3a
Z76yP/md9lOvhNoNRu5JeUv9KJ/6Md5g5CTp0ZfQP+S5GfgK+VKO9FdKf6Q8
L8Q40e+MB3xGfolHfvJ+B/qB36W/DL7P/JPnQSQ/Ivyo1U8qKq5+N0x+8r4B
6a+SflLplwTzlf6nhPyY0s/KfCKc+Y185Xcw9ZX7/qW/gn4hP7lPEf4m/arw
H+nvkPxK+qUIh07kOSqp18j98fA38gNDr8wnypfn3SX/lufDJf+lvdJPQTow
+UK30g/PeHy9jzDa8Afp5xDrFyZ/wz9t/vX5y39/Iabf5T5P+Dr8Db0ALP0G
hNNu6JB+Zp6CoSvGiXDql/u/4usG6RtxOMLwT8aL+Uz9pT+c+Up7pD2GHIXu
kUOMuxxnuc4v+w18LK4/7ulacf3tH29fCeNBP8Jvpf4nx0/ye/qJesl9wPCx
WnHfyyoqji89M/hBXPnehm9RX+YL9Ex42biCAwyG7r6z8jPhYPKjPImJD99g
3OAbcv1elpckjv+59BMhd0z/CD3FyFH6MY6sDjj1f7GvdjBYgeW6F/wd+oO+
wJ7/kW3ecNUwbrxcuKrVfjNvBT0bOUw7qJ9s16i4iRdj6gmmvmBpb5AeTP52
fC3Sa5G/lnoU9ZJyGb2I+YveIM8xmHtJ7Hh8S1p0YbBcN5X7Fpif8H3kMXTC
vJZ2KZj1bOZHQnYwmPVw6Jn8pV0LJn/ik7/cVwMmf+hb7rMhfzD5E1/us6E8
yfeYb8wz+BT8RMpD5g/lSb0T+mEc5P4V0tM+0jez5onhK7SXdki/A/sfSAfO
ZNGdkcdyvzLzlHGRck3u28VvS3zaI/0KyG3mP/IQjPyCH8h9X3IdFLp9ne2/
gFAzny19zzW/Jf9ivjLO9Cf9L+cJ448+QX4J7Yulf+KmZV5XfPKlX5BX0BX8
HQyfo76S78FvaCcYOqO/4Edg6kv/wf+hN+gFDL0Qn/ag15Af7SU/+pv6UX+w
0NeMfKAf4/E9W17DF+lPMHQkzzdhv5AeTHq5nwd5Q/2gX8KhC+aN1HvlvJLr
A2DoG/oivvTv0y9g5hv0SL0Il3KQeITjdyL8oSV3DT+T6yb4m/jyu/wWsMbJ
zKeg/4o7/8pg+Clf5A92OuWb9ZW4cX1k9CDigwnnC53Tj/Ar6RcDUy75Mu+k
nSHtAjD5S/2PfiB/MPkRn/zA5Ad/Y5zA8kt+wt8abz1InrOS6cDyS34J/c48
j7b4r+Hf6CXwCbDRa+Poy93IbTDpZTh8iPLgC/wO/wdD/9CJPOdHf8PP5P0K
1Bv5TXvRPwinPOE/05KvifUh46/5eh671pPQ40gv7+FjHtIeuf4h/Q6ESz8G
ep08Pyn9HvJ8pNyXKvcZy/OVch8z9YKvwu8IB9P/jGdC5zLAlA8W89bopdKu
wU8LvmLRocHwR/QtuY7Jl9+RD9RXYvgfdiV6GXYe+H+to8l1N6mXEo/v//rd
2Ll2v8t92QmdI0jo3EFC+/rB8hxAQ2vem6/cpw4/S2ic5bkGeY5AnhPALiCc
+Sex5PeSjuAn6C1g4skv4eQv9WYhH4y9Q/lgwqW8SOjcDOMKv6Rc4jPeEpOe
+onyDSZcrv8l5BcjXMonee5M7sMFE09+Cac+ojyDCZfyjd/Ru/nin0DP/Xrd
IdKsB/hZeo9ZdwHDT8Dow+i36Nlg8gejlyeJ629Pk38BS/8x+Qm/p6Z+YPiZ
zVdN+UnnxekvSn7TWuXF+xJOvcDoO2DpD6OdhIOR7/K8E/o49AAdQS/8zpff
xT4GLe7tMOsrhCOvwMJ/ZPKX+9DlOUDKpzzCkXuEe1h0ZPSn09Y4xaMXymMc
CYcOZXpBPxp/GnpykOW/0fBZ6Am+AD0RzrgRjt5EfyDPaBfyAj8WmH6Q+0TQ
qxgv4mPXyfis5xBP2hVSvhGf9Oh5lCflF/oQ8kKuq8h7isQ9LUaeyXOA5I/e
JNf1kTPyHivyo7/lOUIp/+S+Keia8sx+NJse8Ocx3sxv+CDpwaRnHtIPtB/9
TZ7jpL/B1JP40m9E+6W8FPkrKR/R56VfgfpI+UR86FOeswWjl2HXIkdIT/3A
hMv9pdJek+lFfePZc/jNqL+8pwY5Bp+T8pb0zFcw9EV+pCOc+ony44XLfZzU
B37F7/IcL/Hkvhww9CPPS8hzBuYcha3PGj5nx5PnLuX+KHmvIvRHfDB2A/VH
fsn9lXL/JPNQ+AvjyW3y43fkPfYJ4chz5AXjCh+BT6BPGHkg+CCY+mKvIw8o
D3mB3GYdD/0ILP3O5Cf9PdJvDYYPyXUH7HrjDxfrBmbdzO5n5hdyHP8w7ZH7
Y6A3uS7GODCv6HfWh+U6IfWlvdRT8lkjZ+348GX6zeybsNNLu9H43exw9C36
AT+Kve5g9JoZcRPYIfUc4z9nPx38jv5j3hNfYvoRvQT6IR76nFg/M1+5TiLW
6bRc3yYd48C6GuMEvaMHoCdAZ9Ah/XXTol/Db6VfhP7Hrofu6H+pFxDOvJT7
L9Cr0IelHxL+Ku0O6JF+JVz6KaFn/Gukgy7oL/xuzKtmcfiiehqXr4uuzbk0
m36hN+hLjgv0AH+Q+6zQV8V6iX4Q9z2vLL3W34wL80P6kcHMh7Rx/XnS0FFg
XH1OmvVbue+gqtVePTaO3lz2MeMJPcgv/j6xr83ofdAhepPct0a7pV0DlvdH
y/jyPgi5nkH/Eh89Ecx6CeMi94dK/xb9DJbzCowclvq89KPJdQfp55T3YMnz
eXJfMhg9UdwbmOA5UelXRX+W5zIJZ57RT/Sn9G/KezSkvi73zcnza9Ah+hGY
8RX+MBMuzzXIfUf0h1y/YP5j54Gl3DXnJm0s14Gpr9w/JvxnZpyor9Tn5Xkz
6e8inPqil1Bfud4Npn+lnwtMe6iP9DtRf7luKf1d8ty2tAtkedKPJc9ryfLl
eiD6DHwCTDzp9yJf+BHx5b3u+CvQe8gPfZdwIX9NOPkTzvjJc8cJnQsnHAxf
kO9vEY9yjVywx59w0hMO30MvYD4ST57zAMt9ZPI9HeQH/M3YE7YcQ17BzxgX
9Eb6NaFzRpIOpd1IuLS7sF/Q07ArwNgl8G3kMut5+Onk/UDyvkDmgbBrDJb7
4hPaN48+LvdVQPdf94vrnBjtpf740b62u1zr4fQDGLuN8vG/UZ7w55r9otgz
0DF6/g1LfzRygXD0f/xzzB/0V+SYvE/JpLf1T5k/9jL5Y58xXlKPTWgfCHow
9SA/7ATsTcLR12Q49ZZ2jdmPY+P/de8N+VMP6UcjPv1AO9BXiY88Ij/6gX5j
HhEf/kt89GroSew/NXQDXYMJl/Ym34R+F/xaC3o1fgaz3822142dYst5MHKT
fuSeGuQndAu/AsP3wPAr/NDkA4avUB+wuffD5nPMH/qZ/WDIf2GHarmvk/6h
v+EH9DeYcOE/MRi5D38A07/ER7+Gz8jzH/L8pbzvUN6jK+5TM/yVdPBX5B1Y
3pMr/VbQK/OacQMzT+Q5wYTOKYv3HIxfi3ER91HGu5dE3gMo7pM3cpj44n50
Lf3uwm+uxX1fRo8HS7vp631+4ab/6VfkmLyvW+o/Ut8x4TafludqqAfjDJb3
aCd0bhpMf8r7itFDKI8v5SX0O+WTnvKJR/n/a5+DDJd2EPXEr4L8Qz6A8ZuY
/Wi23wR+Qv7Uk/LB8h4s6IB0jC+YcQPLfgZTjtRTZT34Xd4PxO/EI3++Zr+I
3d/MA7kPUb4rIu91lPsQ4ef0uzwnQr7QOfwd/ZT5gn9K2knMowT2Nf3Pe17l
Os//2ocg1/WlnYS+iP4In6Bc5CdyCTmBfkd8Mb+NvxGM/MIvJO+7ZT5TD+Ij
t0R94umX1A97gHEmHvof5UIXlIP/lP4z7xTbdjHh+AfB0IFcFyM9fmLKZ36S
HrogPnoB4fQ3/mKhP5n2M08ZV7F/y/Qr8xt5/rXf1LVegj0AlnQq11sYH8ql
X4mHfYQ/l/7AXwo/YxzBzE/4hrEP7f6gP4mP/ib3qYOxK9HvwOjB6HvwE+Q8
GP6LHgdGn0ePlnq1XDeT9gT5gckP+iMcvkQ4WK7bEY4+Q7/Tn+gB9D96EF/a
RXxzTt6OTz9TL+Q8GLpmvkBP8APht49nj4r9hlru/yTc2Bs2PaHvgOH7cn8H
6cCk43f6FUw+tE/eb0Q9Wb+x14u0OB8lz2dJPd3s98W+BeN3gn8TTvnSfyD5
Af0N/2W+E0+ek5L2k/QHMF74xZi3YPhBQn5xef+i3E/Pl3kvsbxXUIbLewgJ
pz5g6iP1zITylXpgQnqfvKeRcPiQxORHOYSDZTxxb5QJpz9lv8N/ZD9QP6kX
wu8oD2zWoe32Sb0L+0PqawnFo7/lPTpy/UO+AyfXP+T9hdKPCWa8pZ2EXYc+
DJbn+uU9I/JecHnvJu2V+3vlOz/EB8t7SAiX60jogXL/L/ya9oj1kXj7heFv
zGu5XiPvEyG93NcAv5H3/8n1F3kvrtw/TDjx5btS5vyi7beR+7uoD3JInqOX
erIsT957Ld+xku8yyPOB6IFg8pP7iOW+qITexZD7f+U9XBIjn6iHbLdc75Dl
yPUTue/m6/cyjFyPdy+wXOcif7DcN4W+KddbzLqjLfcYdzkvzL7a41/vC+Er
7X78VJKOwNQHOYk8Rt7Rj9gZ9JPUj5Gf8EHqIfdhoreh/6NvoM/At0iPP5Jw
2k16yoOPkT/+AdNv9jyX55SN/9cuR95zQH7SbkbflHo08dEviY9eKdepiY+e
jt4EfUCPjAN6EOHoVWJ/kxlX+COYcOgR/Yf8wPIeb8YZfc/eR2Rwyrj2ufZV
8SWdvJ9B7hukPqIe8fZpgZlfwq9uMPlJOwa7yPg77P0fF+LSu/R9xgO6ID7p
5fsI2AHsr2JfFJj24E+R+yWpP3Yl+3LYPwO9w1/A8h5H9AnmI+Fg6In5jb4s
/R/mHRvb/pT3hku/lbxvR65TYbcxb7BDwXK9xpwjj2vXFXu9xbUfgf6nX+V9
c/wel+37aGOHYNfJe0jku8n0L/zQ3DMal3+EehA3Lr5GDjOuYLO+jD1p1xss
18PA1At6g68w7sSHLsDUEz7AfCRfuZ4jzzEzHsyHSXF85WW8eUY/kr/YV2jq
RX+1jfuGq1tx9ffVe6z9XZr9XYwX+YOlX+br+wAjBb+KjOfXIT9hd6u40v2j
DL/EbpT3hpI+7ufG0YbfgWn/6rg/p46bJg6nmSfoedLvzDwB0/9gsc9Ii/tw
tTiPqwX/jMfHmQe0C3pi/Yl5yXwHf33+xHUeBf6A/1O+w8rv8ks88gPjp2O+
0X/wM+w64ks/PP0r7SziSzuM/gZTP1m+tHPByAfi4xeS6dE3jDyx/Xlmn6Kd
L/0GXZA+ITsevQZ+w+/S7uR3+AOYfkEPMef47X6R75ZTP3m+BTqlXPkuuXx3
R75bK+91gP9TvrRPwZQn3xc399fY/I12g+HL8p1xeY+SvGeJ+Sb2cca77x1+
jfwlH/MehLDX5H3ryDPzzoTtF8W+wf4ivbyfHPnAPAUj96W9JO/7/lrfdL2T
RnwwX+IjN+HTYPKV9/qBCWe+yncqCIeuCAcTDt+i32k/GP7CfgLmFfKJ3835
BpvepJ9Ozkuw2W9vp4dfy3eAwfIdS+hT8mXolPbIe2ahW9KRr1k/tddlmG/U
i/kFlu/iyn2c5A8mf/ieeJ/I5C/vHWfeMN/hj6Q3+7Ft+xf9V777BYbOWE8i
vnw3AD+DWY+19XTOUQj9xsh96Itwae8yLugPjBtyV97/DT3Kex/N+Q97/Qj5
S3yw8RPY9iTxJd8BEx/9lvj0D+OEfo8cpL/E+qahS/i6PEdJeWa/vl0edE58
MPGNXmrHp3zkqdUel76NvYw/QMox6dclPvQh/ZRg4lN/9HD4slnnt+kHeW7e
f7GxvJebeQ+mvdg5Cck140e3x5v4yA2zDsC+Z7t9YPP+kC134Ltm/5ztR0EO
0m/YJ/Qb2Ly/bOdn9sva9SNf6in9UuYcl11P6I52Iq+oJ5h5in2DfkM49QAb
+mCdyaY3+AbjAabe8BHWtbAPSI99QHow6eELYr+RiQ8mvrH37fFP6Nwt/Uf+
pGdeUk/sE/Meky2PzDqorVeY8bf9f9QvoXsuGTf0R+QQ9CLXScHEl/dw479E
fyU/MPLU6JM2/YGRl0b/s8PJh3KgB/KFHsDIP+N/tMPBhEOfyHHoG/kKvYKh
P+xg6JX0zDviM15gxgf5CkbfQp4avdj2F8F/zPtYNiYfficf+Dt0Bsautfwm
wcZ+t+Sfn8FnLX+Zkev4eaBL1qPF/ZhanusjPnIWv5m8pxOMHJFf5Ik552rL
E3nOVpw3NuHoifBPIe+NH92852Vj/A1gxp1xQW9lPqG/Ia/QI8CEw7/N+UNh
p8lzCvLdL8KN/8nmu2DkG5j0yCfmgXlXzOb70J18h1e+o2H28dr50S/El/vu
wPAVsLwHCD7NuIj30Q2W9oF8d1yeh4D+qT/jktC7NmDmP/Fpj9wfAGa+Ez+h
ezLA9D/x6Q/CkTfyHgOJzbkNW+5Cn/AdsPRDm/NuNmZ+TosLCDHzxqxbwd/s
+W/O0djyyNxHZNtVnPf8Jy5/130kcl8C/SzX3aVdSD+B6YeE+k2+awwfk/d3
IG+Yn3LdU96jCmYeyHtVkYuUK88bgJk/jJPcR44dK9/1ke/+yHfdpR0Fhi8g
N9B/yR++KP2v0t5Droj3ahN8tx46k/diUL68V0LeWyH362CXyXpin8n7dJj/
8BnkCvjrdZRo4y+Ef8j7ikgPJj3lff3eRaTB0CfxqSfhrNOA6W8ZLu+F+Xr9
ws/YV+hrYOhSnlsjPf5L4qPPgaFTuf8TLN9xk3TCeIn+jedvlfdFotehVzAu
8h4VMPKB+jIu8B8w67HMe9ZbrfThWsohYy/Z+ofxQ9rY2E82pn8ZR7C5/9Hu
b/QL+lve/01/Mj/hx9QbDL+hv1l/o3/RN8Fynzn6N+HwJzD5oyeQP/yf/MHw
WfKn/8gP+wOMP4T49C/h2EtgyoevwcegH+LLc89ynRjMOjHrZKQ3+/zt+qM/
0T7w2zj6eqrGxtV/k9k/KtPLe9jkeR34Ivqeuf/cHh/0WLD0e6GPYa/I823S
Ppb2Lvza1tsNX0NOQt/4K4zflHvf7PkKxm6jHYQjD5kXlM88ACNvjX/HDic9
+Zp7gez+ADPvzf1Cdjh0g30IRg+lXYSjz4GpH3THONOfjId8vx55R/6Eoz+S
nvGT76GRnvpI/wHh4v50nT+u/UeM/4P6YKdRfzD3a5APGD2R+hCf+oO5r4P0
YNIzT7BL0c/g3wndawEmHPsA/Z1w7DIw/Q2GLsHos2DsMTD0T/3kvdTy3gi5
L1PeoybvBQUz7+Q9bMihhN6dQ66ACZfvOst9dugV6N1ynweYegh/gBbnmw3G
TwGW9+QxP4ln9i3YmHZCl9SbetIfYMZb7j/mdzDjTr8wzvQb7aZ8MOHQOfUh
PXwADN9NyK8p9wVIPzpyUPrZ5f5d0iPH4APy3FdC95CQH/Qp+SrxpVxCnycc
epJ+VOlnJT18Sp7jpJ6MD/WEvpkXrDfJdREp19EzpN+c+Sn9jcQHy3d55Pvh
lMe8oB/hT/J9TbC8Z8E3rtxbmv1Q0It8V0raf9il8HMw7UT+EV/egwJmPxXy
Acw57ITuUQDLe4rQS5GryG/4sHw3Up47l/vewMwL9GT0QfQSsDynwXqw0X/t
+kn7DH5BOPwIewr+gr7IuMl3M+Q9tsiNr++1jTb6FRi7EbqiXvIdOOqDn4b5
xDgxz+Q9y8wT9Bz6DXoGEy7fMya90Vu+9scaTLh4/9iMC/YX/QyW8oZw9Gby
N+9FiPJF/oYO0Wvl/Rtyv7K5L9HiH/HCsW/MuoiwV6V8k/tKiU9/Q09SDwVL
vyvh2LvmfIw9z1nHgD/LdxXkOQj0ONpDv8pzg/IeAuqBPm7kro3lvijyA9NP
8Cv6BbsdPQq/AfxovvVVwh9g9kuzXgaGLtBPyE/Ec907adfDnKez20V/0d/I
CfgucgGc0Lta9DP9JO9Zk/u66C/u75N26izLX2vGWd4PD4av88Xvyzighy+K
2wfpWh9ifZ75BB8FSz8g84V+JX0JS9835WAHID/Il/mMfsnvYMpj/Yn87fy0
qK8W9dWivob/YyeRHvoBkw45DJ+AvyL/wXLfpNyXA38lHCzfcyXc3DOKnmv7
J8DUS77PgZyFf0LXYPnOPHScOa6e141fg3KQO7ni4l8x+goY+gRL/Uy+GyjP
nct3BuFj5LfQWr80fIl+qxiXv2v/bxwb8Y8ydAj/gO7kPXvivnizPg99wjeY
N+Z9CRtD16yfgMdb+61Nu+Fr+GmQ+2D0hK/3+UUbvdKsE9v+FegDDP0gbwiH
/5Me+QJ9J7RPUd7zL+81RF9D30Buot/KfTbmPVpbPpj7/GyMHGU+w6fBX5/f
coUzXowT5wtexhHCM+OHkOdIxPtmSpSnRHkmXPItsOBPSvAng+Gzq+L2mbve
RZPvSDKexOO7IW6aBBoMfcOX5TtF2K/Qn9jPF++dbOjw63t1ok29GHf4J/xQ
nnMGm3sObPlq3tOyx13uC8b+Ipz5IPdtgNEb0Lfgn9AhWN5PZejQ/h09Rep5
0Le5b9jWk2gHmPhGH7btfewsMPWhPPobfs04yfcs4dfoIWB57o3yxTkEw++x
32gXdok8vyv1HnmeBz1Hvvss381B/lEe7Sc/5Bf5IEfhF8gBwpEThKMvMa5j
4uo/Uy+zznWYcPgD4Rnj5lu0kTfyHCh6L/0n7sVScv8w/Q2mvdCvvL8CvmX2
dyDX7XDknLx37Ov7zCMFX4zU8p42+D3yCky/m3hW+cZOhd+D6Q/Wx7A34SNg
uU9d7mOnfNZB6Xf5pX7QNXzE7Key+QzlMN8pB0w5pE/IDwNGz4EPUH/C4T9g
+I+sH195Twf6HONNOBg6o17wTXmuTd5Xjh4BXUIX5IfeQnr5ThX9DqYf+RKO
3wG6YZ6jX0i/HfVEfjBPmMdGb7D1FPR15hn6OHIUOQUmHH2PcDB2GfOf+QnG
DgbDl+U5VVEfJcqL93428xZMf9BvyHv4D/0HJj5+C/m+NHq18YvYX/i7fLdG
+uPgi9CllF+EQyfyvg34OvkxL8gPeoSOkXMJvbNGvdE34FfwG2k/EW7kiY1Z
b2L/kby3xPATe95SrtEfBZ+XcgB/gvjd9Av8Bv5h9pXZ2NgZdr3A8p1fcY9i
gu9WMm70N/QLTugdUtrNvEN+wJ/kPX3wW/g9+gxYnnuU+5TRZ8Dy/nTkO+MN
Hdr2lLHvvl7Hc+2/lvYI7YP+aT8YvoZ+xryCDphvZv3CxvQ/85T0tIP0X99X
4OIPtFu+Y2juybHlgNzfQP2hf+H/jbeuCf0w7xgv5p18d5x+lPsi8BeYd2Ts
cTbvLtj2FvHJn3bLd4vA1Nvs47bHnXDoBDrGHhX7PI39j30m31XCTmP8sFfg
J2D4LXYN8eW7B/QjmPTQAxh7kPz40h5zn5tth0C/0BvlIr8YBzB6IvIWuobf
yvdcmffMD7B5T87mh8RnHKQeS3zawTgx36TeKNddoUvCoSfCWTclXL6bJs8F
wl+Rh/BfIzft+qNPo1fix5DrLNJuYT2NeUc5km/Id7WQ89SbdPBZKa/BpIPf
yntnzT5fW9+kPRIb/7UdH35Ce+E3lIeeSXow8tnc92X7r+X942DmNfMPfU5+
5b3y4n54LeSAwcgl+CF+I+wPMP3KOEM30AH0Ad2jjzEvjD9GrNOb+xbs9NAF
fAbM/K8dFy/S+H/ku4SGv9r9Lf1i0m8m7sGNtw6P/DbvitrrCMgL+a65eQfN
xnyZ32DmP/o6/cZ8BaOPo7dQD/gr6zj4wZCn0C/pxHkT48fD3wamnxkfxoHx
kXoy80++XyHPLTBvoHt5LzH9zbjhfyCeuU/S1tvkfbpy3ZZ+EPeSG31crnvh
B/36Hg0XZt4IO8Zg8iMe7aJf8AeA5b5z+BHtJj6Y+LSPcQEzXoynPD9pztvb
co55Ab1RD+lXw55jHjLfCGe+UU9zTgC/oB2ffiQ+/UZ8M7+En434tIv4YOYJ
dEi7zbt8Nr3I/X/4pRrGfY8Y+pfvWrOeAUZ+SDuE+ZXQuRbqAb3SDvqRcUDe
gdFr4EPIR/gMGLlBfHmulC/0AJbvfoORC/B37Bq5D4N9F3ypB+1Gr5X3o8FP
wHI/hdTXwehx8j5W2gumHaSDT4Plu1jUW64rg4nPPDRy3ebf8h4j806Yrc+z
/sc8hf+jV9Df6OXIXXMfuo3F+2lmHJkPRs7Y8p1xgv+lt/y0xp7APwDG34Wc
Mvcm2/MSjBxHfkMf5lyu3S74Ohi+wDjQD/A/6i/XOcz7jTZmvLADhf/K8A/G
iXmCfoY9wnyU96SY++jZz2aPi/E32+1J6F5LsHkv0m6POc9qY/wr4RZ9aOwR
+gm5It+NEO9MGP8GdCD3sdFO+KU5B2HrO9QbPiP3h4PhW9CrOa9g0yfxwdCT
8Y/Ydj39A4ZO4a/YI/JeVOoHHZj62vKWdkKv+DugC+6bg96ZJ2DkEPoNGPpB
Doj9W0Y/Qv6D4cf0L+vv3O8Fhk8i76Ar9g/gD4B/MK7Y++gLYPgU90Mcjivv
ueEz0BPjBH3Le1WRp9QLLPd1ki+/m3OUdjj1JZx5jtymv8D0L/oS/IL5K7G5
59kuF/qmXmDah3yS62TICeQV9TD2ik0X8hw18eCP8D36i/ks3zmS7yLRz8QD
Ew96hp8zX+gPsOFntt7NeJp3ee3xl+sY0Dv5Gf2B9OgPNoa/MY/Rp+Bn8AfG
BWz2Pdv7r5gPzBcw8Ww+F++dcugKLM+lgGkv4w9/QQ+Wfg5p74Apn3mOvsL8
Q18BM/8uxI2nj6Fn+o/xkvOP9sh32ymP+Y09TP5GL/vpTdWH65y6ls+jLWfm
hpnfh0xetPnw5UBzzgD+vO1ZQO4GeWIM3QwZ3LPzxFOu+/gyHb3bOeMa1318
hKMHbLfT54zZnT1mt6cZL+aBh12f5Us/jhqXwbWP0JwLP1T7l/MDos145gxP
3qj5QNf9QkcuT+4b1DJa9x0yuOCFla778qh/dLux9Rqvdu077vL94ybFXoe6
7n9blWrohIuhpv6EU/+wQs9/PbP5lR5d9tT5FiGu+/cahv0Y/e+7MON/5Hef
VmuqVj4YZPjHgE112+zYH2T6Ocx9btt2qX31lqf1d9dN5jp3Q/rWHsXdY4Jd
95P+srOxt5/DdT/erHTj99R888K0x/ts54nL3r4w7ZmUrszN17GY9hBOe2ba
6fHXkD/1/dkun/GhvvT3n2XuFque2Ne05+ySVM9OXXPt75juNbrVhgGPTHlT
bFxu5RP/y1td97oNaVrsxdUPrwymvAt2ftWf15n2Zn2waRffvi3d9t/54aJu
dOjXIR+jLpr1s+79Fqfp8Nm1r7PQzP7Vf/gQZTD1n+Du27e5/xXXvp+Ihmt2
Z9qovtEt/VJ2umX6bWyaCdnX73lk7M5G40MWLFr93GD6yxFupd9Q5f3DEbXD
TPjvqXyb3ErqMP0AXdc68vetG7sfqhURP66K+NH1fm7qgaVG5Cnmei+3YOOa
35XY8dD4hZ0r1uW8O9X17gbtuZ/xbeV1866r1MuKDxtxynVfIONzZIdqXjv9
U7W8Z/1fP1903WN5cGvN5mt33jC44fpNBYd1d92LxnjstNOTX5tVR999GOan
PLxydJu9JDre+7jbWswvvK9+kPrQoeOU0SPCTHiZ6+23B+S9bnCOYctaXp/+
yPQj5TWz86d95x98GfR0pJ+akn9Ik4dfnPHu/3MfuDft7D7Bqkn7z756kotP
wD9ChmzNW+tTkPK+Vj8gJpXr/Vvo7sSoUpOyTXG9d/u3jb/t9Fu3Qxl9jX5i
vnZ+1PeGXf7gQd9lKb7NGe9+wWr+nRM1Wx+mqtxs3K783GhD51k2VW7ZV7vu
F5x6LWvNX1eFGPxhY+JcmxLPNbhZtbZth7d03T/It5ydP+XN3Nb67P0T0aq1
55VS20+4+OS0zo7V76a43sWOSPZ+86l9rndnya9P0f4lV52MVn+ovKFZlrve
uy2W5WP9ey+dqkvxv2sP1tF6X8720eVS+umqN1tMeJEoXP++4Nh7v6K+6nj5
MpW8z4bph313/Js92KnWtPyzQUSKcF3ZI2bnk8XX9fY1zudrL3roTOU2tyl1
cIVOMSL37R5dPHXdjMVvPAy4rKbM8jhb5L2Hzqhv5O3wV2z6cmsH3Z/yRDf/
p16a1+eCVLXIHXXS6Gu62KsCx0aUD1Nhi4scGBZ8TW9eFfdnvpm3Zr7/4sZF
lTF6fO5/N2/S7R6U8P+liK/yrZ1u6dpSM3S7sIonfq0ay2/+Tbf5TtuFul69
ttf7n9+g93sk/3dxzktq2c+V11Yv/FhlbDSuwLftrqiQ6vlrHmoTphoMO7Gq
0cyr6srw0Z3qT1ymU6ds4rZm9yM1Ne+A/kti+c/bIcN9/L95rDKc37QrOtKp
5s7dGdbW95F6m7b5rbwf/9LVdqw8XOvVC6XHBPu3iQhUMbUeVX/r91yNujml
0oC1TrWvX4EtwXOfq8uBUzbtPR47ftuejv52aJCan7V7106/h+m+ib8sORMS
pPJoN1+fffN0rjxDN+ydFstXA//Z0/PtI7V48xhf35FB6smkLtlrZ45Rvd7W
ez7qQJBKvbzYlDOzovWAtakntmgSphYentUgcHi4Lnmm7fA5A1+pVC0in74o
7quW/Rvc+68CYarhcu+Frd1j9cgJF5bE7H6llk/Yn+vZ8midbmnNWd+3jVY9
EvkXb9Fopm5Vr+jRMU2i1bvhKQNC5rxSXXv/+Ch/0mh1aPeErXV3OdXGf8ZP
LfUoSq279LfnnZlhus3+zJVLFI9RVUvuH5HBLVhvbv44mddlp/o4ZlierA+j
VNeQN9HHdjpVkeoTh9bI7VRT80zMnv90pH65fXfN0asdev+4ZEm9ioSCFXjU
2skn/w116BXl5hZ43TVA77jSr36MW4Ru1PrdvkILA/QuC6smNrbjK+LvedF9
1L4yUbpY4hdn14x9oFcMShH8LHGkXvPmXKLsN910I4+e2SdnCtB5L2abPeyk
waqEjXfX6TFpXvoAVbGQe/CJUm66cpqW381IFql6HS87/splN104/5gb7fbF
2hvnzq5Mmea4fl1yzYz0q16qu10bjJ5Q+ZjueqPvp8H7Harh/muDe3U5qbsN
2nTkbeqXqmOSGkl/d4vUp3YeCQzd5LpfEX/14g1DB2c5Fa3t/tL0V5LB7lez
vXToWj9VOO5IGmn0z5yvnzQ87XDtv6vfJbGaHxah1z6oUCe6i+s+xoGLlh85
5xmqZ8y8WeuXP0P03FlnPv9Y/5nq0nR+wYjrAdqv0X2PE8Xd1KDMyaOfdQzQ
vx5JXW3PXTdVOdWknTO6BejQitf3Da3opurNyz255UEv/XZknSZPD7mpMYWr
PZ69x0tnvpVqW+r1z1RK62vs4Kl7y6xrGvnC6Lf/+KxsujtWX6H+tx/23N85
ues8xPAfqt06HauPlNqRbuY/PV3nBCIfPahduMkR1adjZfeZ2b31vbQ1Nted
dVKpQnUmRWX21qHrs71b/fqoWveu1KqqR91095qlQ9+dPq5Wn683c8hON71y
4bRyG4d4qaQv5myLGuWmSy4v1vvJbH/jt7DLM/4p6nt2YcMK3ea79oWF9X12
b91QT327vPOnKTW81d4GSS/MKHFKZ3n5qlml7m4qr/+NFBk2HFMho1/+maq6
mwrZVrhqe5/j6lLSH+oODvA1fvd9NaYnCR7npeZO6/bdk/5uqlCTsaeuNnZT
+z4Mrz/6Ry819c7ghZkb3FdvO+wLPKq81XL/zRGZrt7TlUv0SP56t79KVbJl
21aBp/WK8M+dFrsHqHVWuKpohy9KdSB4QNP7enLB9X9VuxKhVlhYTbDxkR/W
+n534p6avEpFrj0ZqfZuGNeoREanfrq2bI3Mqxzqlf+cm+VjHNr+qszDGpzN
6bir2+xW2z+PcqiT2b4cL7j/sHpa93L2HimdavP32Svvmn1PTR/bIkOTAk6V
asAvjjSB9428KbK3y+7Wq1zv95r1T++p3w44Em7sg+opBq3IsfGl7rr9eert
U8O0vAc2dae3OR96BJp9vwsGlqqeMVYfxk8c0qXpJWfMC+N/S7XvUlNHU08T
P0f/6wuqpfPQSbeMPtCsgOs+v6SN/pm//b2H8WsNHdj209pcj43/GT1s3bkZ
bzN3ClTpWrllOf/Jw7Sj3JV8Wzc+vmDsWNYBAt8Wrre9bpja0LzCwPdeR40+
Qf287fCVxxb92tLjruu9se+efT8v1g6zv7F6e/cnz/526jmTdqwb/YtT9VgQ
dOzBpy36fKUiwRFpHarrgjZNXvXerj1mT416U8KhxsyPC1dHvw5XT+1wOz9F
fvTzvI0t/zjr9kKHz8+/JvDeS2MHEH7Ang9rLP5i0nW+Pf9Zi+Ph6nbuZS03
nvPTvweXKDvyRrhanXSs75gnfsZfxvyGDk4drLipZ6Onxk5derjXrYx7nXrQ
0z89a+dw3ZdHf00c9mDST12dKk+c/nnC+H/t+K79MpucjtFDXffpMR5j7PTF
rPRa+o+9WlTYNMwv2PgDUtn0Vjhj6Xu7MwbqgtPej3+ZxXUOAH6dt/Tj59sS
ObU8R9B/RIqST8a4/E87M15yNr0Zoeu+75Q60/lgs27JuA9cuOx648gIPXhB
vyKb50eb8IxuPUrULBwV7/1dZc+XLtZ8ifee8pJuna+dy+Y6vwX/gp5TBpz9
crGqlw7Z9ke6NIEPDf/DblhUcnDMj84nulmXR9MrV3Ot66Jf72tbaJXT+56p
f50hFX4Lab5eN8h07dqdya51uTrdc7d25Hxm9HLmVcYhWV+6N7io1obVWD76
ouu95ktNppf+ffNTY78UTlNteovDbq7z2nY9FtZM1i0oxnWv9HgbV1/8Y0Ce
386Z8Y8+MmvI1Y3eenaXTsGbCjh1/myjjt478UwfnLmk6crETn30xOm9bye7
6xKHkgzqsdihcwa4X3xb8bxOlO3b60lbOfTref9sr/ZytzoQsC1v4/oOneKf
hl0HV7qn7j6b/KHRHw5d3MpPkd8nqzw1h/KuXm09ralT9RntX+FkF4cu9bn0
nZYZXuo5w/5+lfdOpE5UNeWr9w0DdaRP+xR5s0foZBZWUTau9eepCjuaBCn/
1K+ffjczQif62X9X9K9OpX7PEF0jR4Q+VaxDv48DHTpo/bF6P/mEaPc/lla8
2tGh360f8X2G4GA99sTY4d+e0PqbMYkC674M1an6tuoadXO3HnNwdlB291Dd
0sLqdxtvsuKr5Hb871ul9rj6KFSdv9o2d6u5IfrznUE38sbaRwvPFyjcfXGI
rril8r1UN2P5eMNBdXw9/fTNQss9G0R565KhDSr8ExOgE/0VnfKvVs90nuu/
5bl+MUCXWB015OAdN51/YvTFFLH6xe0x69oUKummf5uQ//D2XwJ07z+Hd9nT
9Lgu2qLXrdDiATplo95RuZcfU80X9bi3JxY7mhXd8+6+tz5T4HjaMWme6fMZ
kqQMPBirx+mPS5bu9tK/XPY9nqOKm771MfHo7fu89Iacv3uVHn1S/1H0frM9
6b11eN/rmc/1OqK9vq/aJX8mb332pnvBUzleqIjf2nXpse6pzpOk3fT+Z0LV
shuFrv3T7qkuFNU+yci+TrVsx6fsx6s/0X3y1pyzYbCXPrdpx5b8Y9z02aM5
fmlx+Lg+7f25QL3tbrrqyJuB01Ic07WT6C6TDrihD+oGtj447VrpH0rte6n/
npai0K9pj+sPnjmapfXx073z9CzetPUF/SKfl2eFYwH6r8SHowf4HdKDMg75
waeat257NXLm+4KndO+Uuc595+Glb+eo89fSlkf1xqTzH15J9lCX2FVscckc
F/Sf7W5Uf549Fjdr9DT5nR3646YMsf9Pm++yqUmfbvB8olXWxTk+V9ipNrzb
uKzjRG/dtOfpj6GlTqugoqlqTejqphc8rXuj7MpjKt2OxcN7X4tQs8bl3z34
6mEV9SBm++vkofqnlf/ueVbYXa07sSPTvXFeelHymrmiY/WZtseK1Lo63Es/
+qb04WxjY+V0oTbXU0U90MWflDuS6u1tlXLUwcx5PrnpzNZX5Xl0aFtl9zN6
XZGirz+Fu6sSKw6U2ZfCX41e4zXXWeOOynCuXeHgcw6dtcqoHs+yeqmYmvdj
//voK+XTXi6f9qkqHbJt1pzc3rqK9VUTsi7IENjQTWe4MnPN0jpeKk+6ut7+
7x8q35T5slXq60N+KoudX+pdq0O6dXGoi/M61N/XzEfN89iRauIMh765/cml
6KX+6lyV346n/tmpS/cdkid9hUDlXjbj1dkNI3STydmrP23hr2JeNH51s36U
Hly+dbdczQLV5kKLl9UrGGu3WF+Vdu3g0gMu3NKVkzw4+aZvoNpi/863eIfR
qYslD1A/ZXB0rtM9QD208leN7Pzt+qgbdn1elm7z6x+x87vRnr3lmp4OUSXK
tL95PdZeuLHnSArf2qFq1YZC6UeOitAeDXY0yv0+RP2ZK/eWS42j9NVLG7wH
3g1VFyYcupioxzm1cGHxspPXh6osy3fdPhPb789aN67SZ1CoWm2lVw/t9HZ5
qqFd3vwW3x3rWSm2P6ZM9ewwJEL91eTEs9/rOnTnWs6olckj1KByk7w7fHTo
LCmmxHQYG6nO9jx3rue5CH3B+qrHV/0/ph8dpZ9aX7XhXtljdQe81P2L7R2/
OihCfT/6UZKbue7pYm0Pr8uXO1pttMJVHzv8nG6d7VXll+rL/jmbp2+PVOft
fPnWfVwqfd22sd/oUkNnJI2ifor62fVX1P/4kqDHaVWkbvDTu8qzbznUN90q
9c35Q6Tu6+W5/ORTh+qt3vZSb0P1f9R2ubxD/dkn31n3drF21Nx5W+sUd6gO
lW7najEjVI9w+D2YVDuWz+ee0zv3HB+dv/6C/PWbO9TR42fuVGvgo6utL/65
VhOnej/zxOkTU+7p9kPX5GtU0KmG+FZzb7Dpvh5apla1j6li1GwrfzXHzr+X
Vb5Kb5c/YWbXTlVVpAq6fXrkiNj6dpuyy61Sfoeanmf6pmPLo/SYI89eBjuj
1Tc13kVuLh6lC/2+bervd5zqRafGBTt9iNRTGrjHbOnvVIXPRtVMejFKf3ra
rlf/o049ONmRGgWHv9KZ2nVaO3+3U9do2KPEk0uhOvP9ivunhUTrdsWdBS/M
fqWvPd/0W/5TTh2Z4tvVs4KC9aXHk3P32urU2d0a3Xz1V4j2PHQ278p7Udrn
TL7VHmlDdBYrvepgp7fLU6I8RXm2v0jjL7L5r4b/tujW9frW3/1U8gxXkq56
66nnBmVZWHxVlJrUseCYxzke6vIZlo2KmhCiFp09Ufdkta36beLw+Wuvxup9
j08EbJ5xSdcZ6D2w6BinyvXu77t5/S4YPfPCY4+Dq/c59LoNK8puip0nnz8m
GfThdpQuXvHa6RGFYuK9v018uz81/Wn3t6a/ix08tLN/khizPk/67ikHPCh1
OUK/b19rUMHzrve1k32ZU61irTBd6OHt9sknv9S1bgTPmpXzherj8X2d33MH
6ubVclTveMNPlerjkWfmrEBdzNJPVWFbP0Wfzp0mYvgv+YJ06dJl9w9ZEGH0
WsqpW+x9mrAFz/SqQRPfTU9yUxVI0k2HPrlr1r9a2uG1V2X/sb2bt2qzbn2j
AqUv650pR2/sHO6nHh59fy2RxwXd+NWij8tqBKk784btqpLrsu5Sos3iqecC
1cusYdWbLtLGfm6aMXiFI/dp7b7yy6vkfZxmn0nxmpV3ty32VEU/vrw4U40t
qpZbuX5FM7xQT4K3rl3693rVJH++dI1+e65G1Zu+YE6eXar36Ss7/kgfaPTL
5DVabZ5/xk+1r3EkXbv+29S1WmPXzp7op0p0ODBh98C96my18Dqni/oY/TJ7
w3ZLOxZ+qLY9P7Q2aYvb6lnef049XfdEbfRO1rVto9sqoMC1TTsHPVF55tWZ
98eb26rIqK71tO8NtS50Z+kMAzxVopRptgUXu6NazRu/Zfzs52rtXd/nSQZ7
mu+kH+q9a/b2hkocum594fJBKovF/1VFm/8fLZgyY9rBseX1n3L318N+6tcF
9Y6si/ZU2fLM7b2skr+66bkwW6V1D9WlLYW+fZM7RGWILlJwYfeHavTPjScV
6heiqlr8URWx+ePbjuU3rPG5q4Nr3XFb7hGtHNOL5RsXclftHns3UafH0cYu
bZova8EPRaN03Rq1a73s6NrntX/Elo4LI13vczMfoM9Jt4YNTfrZz7U/osFv
njvn3DX27y9dP2S/OeiBKWfd+Y1zvot27eti30qKWl3yhG113Q+Y2MYb02/q
c7+E2QethhQL+kd7OXWKkoXGLSrl1P6vaufL6+PUr7r9VXRJGae2w5UIV4R3
6Oqbf1e1NepBxu279p6JVgcSzd9Y8MxhXXxk9ZxTUzjVl4XVq9U46TTr2eOq
Fvc+ePm0Xvv4/rfpg52qb0xg3tOvT+opfknCfI44lR2u1tvhza1wNdEOt+z7
bWb9Pv3zCwtmbY7Uqzem6tR0tcPMx1PB3V8truOAn8S7r29CYIdX2y46tGeh
BZ8WdPA0dhvrG01/LNoyf3fXuZUv8wLyNq7rOkdEOPbd1PDGo9LF5vfEys+s
ZzNuo6ov+GWxn+v8ep+v7U9jR9r8y+y76dsqsFDaTZHG3iVeNtsfiZ2642t7
N979et1WO7L+UywM+jP0WKDFd2u6X3K9L/62bsoN+e869YlWPinT9vPXWQ7G
rRcafkZ/bLX1ruJWuNlvSP/Xbbtidsqfnmp7/M2+JNZnl9n2LuORyraPX1r2
sfFHHnxfr0Txz27x3h/PafuXDlnh8d6V/m1+xvUp+jzWuR998/61l7cZV75H
bXv66abC4W2Oupvfyf9jx5xVHp26oce2eDCucXCoyt66b6Y+317U9Sv0/THR
fte91mksfV2vsPX16AtNiqdt4noffPharwpz8gfqQpu/T5Oh7TnlKDbMWWzY
A9OPGTfH2Qmx/W/ZCw3Wl041oeNJPdT6qrPregfcX7nD+M+Y54WWLxqxednf
2PPx3vtOOaNZdHaPM7H2QKVUP/j5mvBilr6vp9j6/rthk88MWOUZ773vSra/
4On9VO7tEwcYfwL0/Knm2G8HHrli/GxFxjYpmfrfKyo8z5Ee7z/Fzpvkjvsj
c7ibeTD0Qa9eRQPdzXon669p55w8njfWbsevsGte9lGn2rvuEzTjuuJTz5vl
Hqich8vVDon2MOETxn9zZsqIizK98VOMK9U/Ztxk1/2AdnkmfK1bhsG/tI3S
65dU/mHLeR+V5eS3jzdXct33R/3HNhvTt9s613vfR8e9dk/8s5fyOlWxWeay
MWaefdt32tXDnSPj3Rd4+1TJEuq6r2pkrReb8LUnOnQcmeWxSb//vkfhvQsu
GtwiX1DrfEHuJn7TwqsCPw5+oDJNyLqnTainaVfWLKcrj//0VH0Z+M2+bAc9
XPuSx+T5Y5d/kPEDMX7nrhzrX/hff9VscYe/dqaKjnd/4BW7vnb74r0/Tn/c
OTg1/2Vf1z5NneebRr/8P/eKDnF0W1zdGaTq56v8p89m13vkmed4lhw2JDLe
e+RvEn36VGR8sBn/nbY/uPvh6pG+rz1M+h4bF8YERviZ9e3bVn3ivU8eYedn
l2/CjRy065fV+ehSm3yuczylqqWu3/K26/1y2qP+nFW5xG+v1PMMa/5tdydU
+1tfVbHVpNnP1kXGe9/87qSxXU6tCFcNl+6tM/n7UBNeNN3NCmNe+hp5PurL
zl5rq7xSonyD7frFe8/8sp0/fji3ylV/ql8mVOXbXKbaoNUOM09pL/Wf3r7x
ipUpHEZ/KPS8TLrwENd76Hm9/Ct2HOV69xP69xry14cP9SJU0Ks3lbZ9cb0b
WqCZ+6z6OcIMTrT4Zur3/7j8rquP/rXmfqCPwbY/3mA7vWnX0IfFq3fY5LoP
srBVPxNu199guz4GZ1t7P9nwma53n38O6TAitIBrHbDdjFFFVJVQ4ycvtuBR
4vo/+hhsr68Y3HHXqy7JCrjeUT5cZN2cwtnMeRaV/upLj25rI1zrMd5JKvo3
dqrvr22tc+dVtMpwrkrz+60fGn16luU/UpNs/1H9NbUH+WZ5qFqsbOZx4+02
/eupzVkfFQ5UAxb1Kdh3zDkjZ6fY632nF7Uu33NllP426Y4K3XM91G+c3Ub6
lg7TG4eWOH7y9TV9v9N3nVMXcp1Ltu1XPc22Xyda9qvOZtuvR6z9Caq6vT/h
RopKt9bX8VeN/IfUb9Y9XAcfKl3Qu2yE0Rdm1v4r5nA/h2o/6t3v8xqEm/2P
HzsUKXiqR5gu7P8pONUC13vt5YamuLCkladqdaBn8rznX+lJzU/eK62fqRJJ
sjz+7VsX3Yy5tOzTpeqB+p8Y3+yXO7ruexyTtaf7qu6xdnnzdJXbpw4y+vPl
0g/nXt3hj/6i0F9S1Kj7d/1YPVTc36iIj9y7EDhouM/bF7pqjuiz381cqf7q
fuHQoQGe+kWPWwfdmh1UvfLVODCtk6f2+aj3TUzmuk9xq7UfzfAp2t9kVOp7
oRU99KN6h3bkfPpApQ8eO6D6dxf1+49N0g3TwSrXxumX7x26a/YnOoccPrvo
hpsOH/ndkx8Xhqvuuf7Z/7zfHe1dsdMX/8BY+2d6j1GVwi+q326UcyubdL/q
lmhCySHZHqlzmfyaTh/mo55lffL23eubqtiYldurrN6vNm0vcNCnwAs1okhw
ly4Zn6v9dwasTLbsiaoa56+/a/hnwW8f7Crl2KeWt70Q8VOSIOhVQ6/Pyzf7
0L+rQx+P+bTqzCtD9zrq1ajW9TrH6vdNO82te8MR7/6BKq373V//KFqNXLht
6LVsMaZf9lU9f7ncFac+uj/97W1ZnWr8/aiyIVFOPffUolruixzq3cCMBR9+
E6NndmrY2dnaQfmK8t/vWvRm991oNX9x9oWLnjnVlXsDSmxwRKujgTdyHm3l
Oo8m6mfWrzbkuZTkYAaXnXCr9Q8eeUa73rnk+1v06t5XD4Ua+pjs+XpWub1u
Oqva1O/6I281alj7slP0Ddd66AP3XWdGuWn3iJxDHy/1NvtjCc+Z+E2jk433
6c0jJjfLW9LL2Gl1vv/GPWt9132LDwakOfiqyFmVaO4/VV4lfqCm1C175cCg
p+pM6KHPHaIeqojRceOrt9rjm7/H4hfetc6qriceN/dI5KMis8WNp17JeD4b
eeXsyUvq7Hetevf0CzHnoD7/nObgXP+XqnfxsjMCtjl021oLRn9IGqPGHJ9a
we2A6z1ze7wU45XJsve0u23v2fPBnM97FlKxbqnYcauUOn3yxU2CzXmUqLy3
8j7P4Gvo5HHBZkeGJ/bVhf9sszk0jVPNqzR28dBvfPXPqzO2C27kVIke5k2T
4ssL3T3fmALD/3S92+Vt2X+Gnuxwc16nkeWv0SVtfw38gfLKTk/R9Pf3Tj2v
RY1E+WPz3+J36NaGc079x7Ic5XPFhh9+H5P6c7pYu7dV5fM/JTb10dRnsmWf
m/MvyHd9rU3iDX1c5xheLCipnz136pHLxhQusN3H2G/o111te8y278y+O86v
Vd1SM2uKLuHYZ/Hub7zfq3mWmJrBun8Nr0/dikSZ/bXQdcd11w5mLO6vd1W7
+upKgOs+RvxNJ4eXuJXx0UVjj14b/NV6orFfClr7QeOdk+9t2x/mXdHQl9nz
Vdpm4kW/u1Gwbucdpj/y1LLsBeyIgGyZ9q9OdUe1cBva3m3oNXMOxtZHzbyJ
tvRXg6HfcmOW7xmZxNvkl2/D9mp1Sz9Vr4NqJk9x8ZrRf7Mlej/Y97w2/A4/
2JSSP2U7lC5ATVmXNKr0Rtd9kJmt+EY/pLwJdvyBE298Dl56xZwnGW3pa0Y/
tPU5gynvSM7MTR75vlS/j5yY5lOyK4bvj7OwOS9o80vj3yi7pEcF//vPjT5T
s0LrrWM6PlejW78/W3ZUlErcKPGYyo+idMD98+sb7HKq14tSOHfdjdYLd29a
vDiWP+6u3nZ0i1i81Ktnt6jY+XHM8o+rH2z/uDP5nLdlYnHZboMHZzvnVCMv
DH0weZBD/eIemLPV8xD9oPu2GW1GOFRwxIGpqbO+1Pd9GkyalS1C3ZzTb3jl
RC69sfBcj47RAx368h+Hzyb6LcLoG7TL3abXbzNdOLCno0NN7HG6Udk/g/Sw
Tn5Hqh6LUB//bTv/9KcXuvovaWvtrRGhAidU9i2R3NeMS+48Z6p1au1p7IR+
ieqPylXuhp6a6HGeNUNd9z+i55Yt+TpNtVfX9Ytd/QscaBke737ITFvCc+d6
s16v6Dqv34k9vvHuRXuTt3TpP8ddVG87DbsWVcXD0EGeMlkmb8zha/DEqA3F
indxM/XMmKiwLlLdTfsX+GPuQoefum/5F/Vp27+Y1vIv6nG2f3HonFcTT1R8
oYoWKF36h1YRat6lhtU6PI1/n2TOBzrI965Drc7at2DxrT7qQr6YHr2SONT4
FW+Sr8vrVNPSNEifaajD1Gth6zwZh31yU6nn7er3tt1jcw7/+U9rPra5dVnV
KXnpbvlOz5C/Sshfhfy16xPvvknqc3BnjCpzIFZf8F97uV8HJ1iBcx8oUje8
RbhKWjSvd4jT8F8l+K+C//5dJXXOrINCDZ8bXa9T4bULg8w3cfaI3H3yBOnK
i1fkq9cvSPdZUuznscsDdPtdM+svfB2o63RvUTtJ2mjd5srHnwvVcupZN+Yn
VsvvqpRnf2zwrsEjQ5cfUpfxm7w5Vm8rnKLCiIwBRp/zaHbgYao5Tp3r5oG8
aT1i5cl3HZIsSRetK93qE14xj1MNLRk5L8fP0Ub+nGmdaV3JStF6f7/hC+os
caiCrU8mzf5TtB7XyG/5tLYONf1w5q5tfok2cgj6KvyTZ9f38wMMPeZJs925
p04g++WMv4tzUgVt+off/ZAydNKCcC/9k+WPcr1nbY/zh5RDZvfLeduc2w12
H1/h0G/XDR3kHBoQUvyIhwkvP6tX1Vm9nqhVln1m7CXCpz0ObtUwabQ537q0
yMJ+X3yc2EvG3nn4zD/l8dQxKrTao3zZPkXrB9/9fjgo3KlSn257u0KdcD3f
2m+g2G+Qr8EPlSu2c9OqQLkK32fy0G599rzcECsfGxw/9Ot/+wfnnnp56I66
Y76tIq8+Wzvhpm47OZu3e7e7urPtJ+N7a0CRHiVHvVADs/VdseKby6pfhZ9n
pq72Qnle3PJnBs/LqsHe5ivyz3lkvgc6XEh0cvAjta1670bPTjzCf6XwX6W1
1qv1SXu9+k77hml+LevQbq+PX0v383M1vtPFXsWK3tdRGZN8LNnKW33bwitz
5/x3dJ+//Z8enfFcJc/3g+ftumv0rrYbJ3y5/0Jl+3Xi8MPuQSrkdIdiGfd7
qXWW/0mttP1P1Ycccy+3N1Id/eAxblTYC/UiRYO6iwvEqLK9C22tfdJLdVjn
yFg/qUPX+7X00X0tA9USa/1Dv3tprX98nyeb39NLN/RvVTt77mwQpB6vf+sR
Vm+tzvG58fT+g4PUa2v9XA2w189/qn+8X75jkWrZv30HF+4fxPq7Yv39Xcdm
l3bHzvsDQYmyNYgOUlfd3HzmBkfroLz9sixZEqqSbchY7bu9Dt3zZPDNe7nD
1Hi/TT7rt4brNcf8P/4WFKpe2H4RvjUzjd1ScXqoWl9+e4UMa16xXq4u2uvl
Re+ly+MfFanG3Z73x4ndr1hvV6y392qQ4eGo59E6uHv3y+c+R6r8OVIVHLPa
ocsl2VOue/VoVc9aj9Y17PXoyd8+enosY4Tu8+OSs373otSnunO6THvzSm3t
kLFW9m2RysNeF+fbbXgRz3w9otQ3Ux1/Pjgaxfq6Yn19Y+iRXqe8nSp0dMlf
PZ5EqgIvSi8OqxKpRqxtu3fzU4dqcXlkoXGx8+SnHo+H7f3JqcomvvWu4yGH
0v0/tst1M1TXj+l8q1m2ANXkyIwefd890FUL78/04/kQ9cBjXL7VHR7oMj+3
H1a3tetd+6PW/gG92N4/0NDab2X8EZyHdHtessmtt07VZtFfK+puvWj8dZyf
T9Tr5dzUe5+p3HH7bR6b8/fX0/m4pfO5YPSVN69L9nXzO2LuFUzyJg6b85Hz
k3/4YcZZ1zqGufejYNFEdWP55Ml1uY4UdnPtz7uVY2ztV+ccRn/1Wt2gY+JX
rntGQhz9828Idpp1DPjb+xINz9Z47GH4WcotvaYXneilOxXa9G2Om75mPSmZ
df7I6IHmvbke4eVatbti9MCNPXf12p/ithp4c37nnjtdemQK6/yQ8aOa+zP6
vOhR7+pj1/2XeYsM3uXjrsY2j2q9NPl9w0cJ969eOWXdpF5q5+Xzn9K9dDfl
LrPOK5n8+X1og/klp9Rw7XtN//nTrXt/uKmf1k/3GvXoqcnfPm9k9udRv7Hh
R5/9nPWFym6dB3K9026dFzL+UHP/pk0fBzcsmLkj6wtdq9reRr/H2vnjf9zy
LlttD93x47Xx3xSI0VMtrMCnrPiK+O/qFLmYaKuf6r7Ca3yVdbHydXSNxyWq
+6vObX9I9vdxJ/vnFfvnP4x1tFtZwKkaD92VdG/ycB3jPqLBheJONaDXX5dn
FQ3XdTLfOdohoIcq2G+SV8uCAbpwm/zPv/N5ZL6BNaak8Qz3055Ti/4e6XlB
rynY8Fjnnd56+pzaPbNNuqxX9v1ws3d+X52szMsNm/vP1Fkqzlr/6rmXqjzi
r3SLSh/VRwLPxv4PUJkfbs30cOsh/abHwWWDugQo7yZXygTN2KXzPE+f+3n6
F7ptyiO/pjyyXpU/u2PbkyHPtbPkjcbpE+9S333ryF2j8FO99Jugf3x+3qKy
jGni1qnvC52u7OFR70Ivqe9rnXOmyfFY98095/7J2lfUrpFBiW9WX2m+J1Ot
uxD7X11t99/fdrU+KLDByFkXVJMnB6PS/7BDFaofd35GbbfPz4xOtu1o7sS7
1a6DBce+rXpRfTm8tEa6ud5qS8s5K072PK10kycFhzm9VFWt/izjeV69LPY6
8dF+Prqe+tyzY9BNNWNtxw4f1z7R3zy5uGp5g9vq5SrPNP4DnujPa/IeS/nh
tppknbfR/9rnbbYk355+cqGH+u6vrZe0aHZbpRzdflXtwTd0Huurzn2JHvxm
/CN93fqqxoWCT55P4m6+I47U6rr9uL+q0PX6gBUB11XY1of9g69F69nug373
qurJ+RzN+Rxbnmnk2dj9r359081TT7O+6sbgrRUXXbihP/Rpsu3dL56qePGd
pQb2eajPemw8nrPrczX82vaA9DEP9dSWp9KlGOyjpv9wtWl0ULByZFg9deoz
TxVula9m2OXfteS1umfL62QnPNynb43WZ/pW/TnRA1/O+2jO+9jyTiPvGlvy
Uc+35WOLDWWrOxrFtvdWeJ68KYLUN1Z+6pSd30Xr/JGqbp8/suW1+tGW12U8
Oi6recGpC+fc9nMzz2BVe+CZiz/Glpfpg8625793rpJtH9FzmVPXLbP099Df
QlTbn85fKjQ7Wuf3mv5xefZgzhdpzhetCCmQ+J/hYfrRX9tqbH0dpEpY8lOP
sOXn+QpBOZpP81Mz5vR4vu1zsHrX9Mb78JJ+qkODLq22fwhRq6z06oGdfr51
vkmVt883TbTkuVply3O7PiqvXR+7PYr22PVX1N9un6J9qazzVOo3+zzVNUuf
UAFf6xOqh61PJErfYOzSnk7deVXrRlvnhquuO44FX0ofo3PcLF80SUCE6rO5
aMPrE6J1qrB7N6pMCFPFsj7b2W+oQ2e72SNDoWrhnKfSnKey5bdGfr9d87rr
0udh+qP1VT0s+a+/TLHkv30+S3e3z2d9tvQHvc7WH97Z6fhOsfQN1dPWN/pa
9VPJv66fym7Xz26Poj12exXtXWqdH1OZ7PNjtv6jAr/WfxT6z8SBSfO9rRCt
Bk/pmSHtYocaOKnmkhm3IlWxdn9U/+WKOe9gvra9o7B3hnfyaVF/fJj6s/K5
FReGRutX6R5UefC3U+X7+8bxKtMidb4F9fbteePQBT0XJl9XMgyswFVbqb2t
ksbo/KtTJV+zOEgX7h056krBYJWq0+vjHy4EEa4I/yb51SJR26JV/d6HrugK
j7V9XlJzXtK2JzT2hF0fTX3s85Ka85K2vaGxN5Zm6ecZUCjG3E9T5d2jfklX
3VB8j7X6VKtsqhuq9dWeR0La3VRpeydaU6zuLTU75a4qO//0UIWyjR7Z8ZSn
evuo1NpFIR4q8drk53v+dV01bT+++mxvX1XL0rfVUFvfTnoxWLc/c02vODE0
kU/hYJXawmqpjVc17Drq1UyHOT/AvRQtz/Y6N6n7S+O/47x4WPOfkqwfH6av
10hVa1nseEQfU0NOX4zSczPkyJBmRbh+bcljjTyebMlj3cmWx9ms+wNMvvgf
0z09//y3tE7jV0tv46BU1T1/KRyjZrtPXDFtqWufUiXbHxlirf8YfW6EdX5V
c361uLW+o1va6zsjrPUdzfoOekzHQd7Luz0M00uzp9qi+0arMQP/bJfrzku9
Ltc/3a/0j1RfJm2o+rh8mC7zuvTwTIld70asscL1v3b4Eiu9Hmmn317+y+xp
tyNV+Uz5murWQfpWaMleZ5ZEqlKtFt8s+CFQH8zq1aHza6eu32nG+zut/XXd
ZCXWDbryWH3qvK3H5TpeusmMHtOuLnBT33j7NMyb2kOvbjCqc8+LL5VHSL9W
B+8+1seKPOvTspy7ur36TJ2oPtd1W+s8rK5jn4dNdSFozM9tgvXpWjli/81W
Qdb5V93CPv96fPykilUSexv/autteXY0Oe2nG7mN61S57Ta18GP9jOn/8NOd
5waUbdNzr7L8r657CiKsc7qquX1et4elZ+jEoyx9g/1exXuOPrJ3/nBzv9cf
jxO/bj5ziCrftk37ifl9zLoG917MH5+tw5iq+9Q4S57rRLY8t8/vG72c+Gke
WP4E+7x/vHsj86Wy/A/7nxUJ3uTt8qPa53s153unWfJbv7Xl9/Il4R/2jPAy
+zlKjfn3h5od3Q1eYYUbvRs7iPsB6lr2s95g28/nrPPC+oN9Xji3ZX/rB7b9
3bftjAdPYvWjf/+vrCsBq6n7+kkqIkOZRUgiQ0STYUnIkAwRFUmGDA1EKGOG
pCQlZSrJ9JqiVKJhNUea0zzc5tvcvbdEKN99nbP3/V7/9+157rPtc/be55w9
rN9av7WWc+ysZSFVcF1u4Y261kLsKvLobJ9XDTnRPx1WTs+m64Q8X0yk9DaH
2AoYdcdnV5lVPpTzh0ybV1sCziHBwj8+levZ+AFUfid6o5m5hdtmelWAy9ru
9N3GIp4Y0U/1LJhx82BlDfHfF8XFeOIg/BPpVWOY8x0vs+d7N3O+4wb2fCd6
yRFHXPkx8+tJf1S/Te21bH/kfZJ4BGy8Avirf6qvJuPd+bvd+JpvA/Hn/584
Moc9puS59TTDlKopv8ubRHnRk5KkLOV1/zcuy7UVU97ffiuUHxh9Afqx+oJ3
P/EhT7jf6L+InBU4vhl6Ruk8k7AMR4XMAo/PZs2gO2DXPHPlVsqPIPYnD5cF
p3pcRPHUzNnxljPxDSg/QuPluq6S7wL4a3zw1/iAjI+Nn0DvZ58P/s4DH7N/
3JOuu630+V4l5vdRWCuypy6xcNnjtbQd6mqShX98agfyF98UsG2AiF9xIP/m
l8hbrX+XqX2APN8Htj/2flo/n4mnQPV7ND/hf/uncRRJHMKfauFOZVV8OMXE
N6D6h3U7pNRytNtoO6R/n7Ud6gpBwnZNVoc4DK2hvDqCa8v6qHvfNP9Ayw6p
2h91f7+m+9JRsStD70zKg1PGcaZ9DoZTPJx+pGFWzaFSWJrU/lD9RDblUWCC
anSCqnA9SdwVM+WF07jldJ9j688w9VSv+W3IPLf5p8voeiXtnS30bbxiUQu8
cAuZCIu3NL4hae8kW9/A1FN9Cut/S9/P1dz6Mx3b+fB33mPzE5se6vbNQZX0
y2Izldop/5Sct3caL9n19PDxTPLWmrx4HvZzWBe4VyjnrJZuy7v2jg8rx5nF
3vTioV+8dMzN8zyYaytRlzykDdfLRmTHq/KhPvh60/BTzSh9Vr324BoB1bcQ
PY58E2/6La0Wuq/OTv292cishpyPQM5H8rw1RX6xCVNraHnI1ZPac4aUYVL1
EOtjn6phVuzLy3UK+Rj6xHxcr1gNaBiUWfj75WET1p7aLJRDj3wJnnbmVwE+
Gg6bupbw4YS12dJ2ywJ0bb/VPV+BCyt/9Zt/RTYbd4x0zzwmXQWPK5ZMqdkc
gjGbbrZtEMpZnvO7vknvfYkPUr5P9o2qBj+lu5l6XA+UgD0XTpz9QL8LOWfk
F4ctGFz4BASFsQr5m7NpffWhadYTZAth+ZMcW4vdH6A7ZUbVRJcCWGj360hf
v1ho8d74Vsm3BDRHRiXrLE2C9Fyrpy/eV0Lrh8sZziMiQfVGwSwn+RrorDgj
cfJYMhQ1Jgcq7M6l+xc5H3bcCzgw4ikXki0DtIyLBKiuMjRuXiEfnq26vnCs
DR9CYiv1rsfwIH5co+/7XyL+UHjch+9+j/jwuGB00yuhnGwXFfAtI5EPgwa8
v/jthii+ZPOLXQP78wVYsMAvuPxYM/7s5zJl95MGnD/K67pmfhmodCofDg/4
iEcPDpp5wqkEGq37p+dbXUMPiVBZdclS2JIu92ZJeBDmhu/IvJ0RAdf8R15S
+pULs5T0Bp3yKYD96Sn6SqNy4IHKG3fFjnDYoxZtYS9cL+MYf3jwYf3hjwi0
z6ocjIf563tfits3ACgrHR54RIBaIXn7/SZ1wEJusYdrEB+jH+YfEB/UQd4H
kPcxaPSf/RvGsPu3v+uj75ceiOIzs2W679ZyJ5bkRAuofpLEqbx8KM4BjAXg
x8hrmMPKa6w8i0SeZccHZHxknRJ/aIPe36nnBzYgNgeusPKpR+15vl+Aw0X9
8Zo1087V4+hj0/zsp1nReLSHnf6URfm32HmWbvtp7epzUaBkc2KY8dhgOi+f
ldkMtglOhPlX994Z9zSTyAtUvlDJyx+tNC+Gxl89dNJp8uj1Cf+TT2eZSep4
QUINqaf5DpYw59//xCG/yZ5//8x8NSroTCyN6/fhcY9vl1ka3b+WN4RVr7rV
jlYLAm67zeiAlLDbe4fVUj0vLF/3iW9aT/0WYOO46z1G28rp/F3LvD9IYN+f
HvP+wJB9f/1HFedL787B0MFT5VxbKmGWloeB+qB4WJ3lWJz+vpSMh+63lz7K
W515UgDN3KTSBI8aYP3N6f7Kzgf8az4gmQ+fKsz1nya1wN/5mu88uCezeKFQ
DryxdOWTh7UUH1oPVPm9SjUOnDo5FYmKIl5OTeity2dcOSA4cWzx6oePaZx2
Uv/hzM9/TkEdiCUNuzrp7GMa91B5VWRPeWwE3NGWMsg+JoBxTBlvsWWnS+1z
x32IQ9fphnOy4xrgWHhK7tHRNVQ+K275tGt/oCjuLJEnzLebT74S1E759Oox
QTsfWgvQ/Jb38q3iVVQvT+TOeWz9dqaeyiHPWq5OlJLsgMRLhbnr69pR06hP
fsc/AjDa9i08ah0PvetOak6/wENt5fG8e4PbCN8PN7N8vwLrXNWEqXyq7yfj
a9jtFJpv0YwmRb72NqM7qBzB8veQ8Pcm/5584sGdVtynXyJ/NZVDvyvxp2Lx
O81vYlvgG4VX+WjpVD8rX7aQ9reK5dtx9G4pjNhVTfn88q7nrxf4F8EyNcnP
ZybmYb2gw7dZKLKtEP9RtTAoBBc2qRyZH16NEQu9xQ+d9UTnNuvk/ceqKd4i
82bAnjHi3989gCCGj0/ryfffa8XgLVLuw2Hw1ukNIzI6u4V4MUg+rdDwFvxc
0npt97w63GubXe7W/41wP+xoioyoxHKd2sbm3ndgc86k2lCuBgf7uOVmHE6G
EoZ/T/HVCJu801a9BbjAzzH83JQPcGRxwIav7iVoYrtRvGxmErD+//R6YidJ
Ye0fZNzQzN/Yr/wJvJyhezWnx57ixIez/pQpjuxhxgsb2PFGmo4MuP5ClDfZ
PcQsJ9WjALNNODKHhuaArli5b8zuYnT5xyJnT0Me7d+ZtXcYTD2+QOCUgQ7N
mjXZ2l8oL6OMtbdMcHoVp6XWAddzjYdm7CyFZK9RjzSNBDBtTt/7H1sLqTyt
zuKnn6bN2wKE529aqNWkrspCiJofP+exZT66eSz69quiBMZt3v1xhWYJNr+s
9Ah4yyHxDui6IOMLHOXWcPRQFR3PFda+8somO3X7BB60/m6cWHm5GtYufxey
aVUbcPaLLXP0rqTnB/EHKNLxfNUhPN+clzZPDTtTDWW7EyY9HygAF98NwybW
V8Ia5n6sYu9n28d2tv3vd/7ol9CQ1S+R73gx8B8Zif1VoL58puSFDyk074fK
gX2phsY8ivO8BC7pG4fxwGlnHm9iExfObFsno7SlDfKL5HcFjquH91tVtt0c
1kGvZ/n6FN+dZq7HIvZ6tj08zbbH8skpviN6JcI3Z/ETxXeZNx24b98lQcT5
kAUDxLng1fHGpfp+Mo2XH8lf+mDBjGa4q9DnolVTK3RL5b11HNoIZepevo+z
moG7+MXqHi0exZu7X0qeHjqCB3Uz1o38ZtMKI59w5tadbIN5ThPXv4+heBMI
3hzO1KMGW7+LuR8b2PtZfjjln39n+kcO2/87ZnwYwI6PPHec9Ia3F2e0wtXP
OZHjPJopzpwgqbx8uwaPlln+O/zFnwfCn2f59bSejJ/gQ+tomTODLvHQlvkF
a3unfeWmPNzbM23nvgF8yHhuMil6I4/irrecY9aOCh3wefG+80Wyojjw6rme
Q/mPWnD66cRL67AdNq306XK41YJFjP8wVLL+w6y/MRB/47mh7jfmpQpA4kif
j8dPiPJRjBnDdW2eUUn1WEfmnvdXEeIDUtb76WW6VVKk53qbG7JCsYFD9Y/1
5R8dqgxKaP30wN07SpQLablx5xz9LU+yab6di6Nc7J5NKEQPbj4kPWug1zn/
4c/V0vKugnT1h7cb0PxDaZvi0nA8v1kncbgTF+dvMRL+/xC/1p/1STSKoTgv
pqjS8oJ7PDg+Ctyxbs1z3C8pdzZiYzaV47Yum8ofH/OelvMw9K7c/GwcdPpH
w0x+BNgfbZ4anZ6OP5IE9wZ+iaftvim1+uUb/4GWFSfcmnBaKg/WMf48VB9E
cO0LVp8U1ty49fioGqoPUmXiFeBCNl7BWsb+hPNY+1NG+K3bg2/mQ6Z/bPWh
uFqwvvFv/MMDVH9gfetPmeJ5vZh/7cNWaL9O7caIoHYwm3lDMnSAKN9HefaL
a1VPG2n53c3+27Vam/HNwCDxCjkBqafy3ppSDbWvkjRfFvHPh0Osf/7hrRM3
HdjQCCcMnC7pVQugYmqDxJItIv9Dlh+BhB+hcUzGSaenBc98y1qoXkHHgSsm
LC3z9K1B80KH7YUOorzAHepfdl3Nqqb79vLAeSqGEwVULhjWftBX1keABwqa
6yIS+egwbtTNryodKPUMuFmz+Dj16iKpdwGiPCOEb9dluvv0cFUBuR7I9Wx7
QNpj74e/7gdy//EtO/v/PMiHyUu1rgfM5OFQ3mCb/uJCuQ8bFJ508TCWP6F7
TDWf4jr2/VA9wJ7M3IDMqQLc5+vx9WZNG84W17y45aoob7JzUMMLz8EdoNa2
s1ROvhVv6pxb/K/9TSp2boTtgDY8UzOjU+auKG/L3RmK6bwkPmicP5bfPaMJ
23qMNOKU+eDNke1jtp/GU4JUbycTpfNNGN4ZMOxuBZ/Gc54fOumUsfB5+xw/
7DDLqYHm3ag9OPLNhOxSjOSVFuycnAfG3UmarqdLaXzrjTf4RtEVJejGEZt9
1KgYVluOe5zxqUTkV8PylYlcYSM34vb7UWV0/Z+TSXJ+1KcMNSwyvEucYuFY
dWfFhf5luGn29CAPIW4i+iXS35Lrayu4Q/Pw1hjpc+HlVfB16OMtTwzjUHOk
63X7I1Vg67khMKwrErcvmHVeqqQItKrrd+otf0r1ymLnN76dWRkGX0ZKzDM7
nUPlnVj/r62NIRkiXvBar4ubtCuhA9J1TwxEuq4X/j6lkd4RBSHn/+FFnKmk
uM1zzugbc0bnUR6Hd6falTli5bRspydrXn87neqnJEIPTb0vVkF5Iy/7mb3p
Z5ZNz+++DN8UWlm+6ew+Hwq1jufQ89fn6JNS977Z9Dwaqd5RpFuaBeEX0nrP
DmmF3t1fRzrPF8VNb8xeLfzj0zIO/qLirCDA1ItKal02fHh+cfeJSF0+vmB+
if6Czhu2nv5uTmySqRolymfOzk8k85Odv0jmLztfqZ5s97yN698Ni4IdPleU
wrULMUmtdXTXv36tvm80p2gU4ryq+Yv7+VWD/NP6xhGWH9HYJ3O0+YtqMFpQ
6mBp+An9VHmGlgurAac4V61en4QB3uYf7F4Xw6vOyvm3fnlC49tn04f/jIOA
7Z6LZCOzIYzPMR3hmQ85yRNPNGXnUt7O78TR/rfUc4FfsM5037QCmtfB2ajP
vdBlN9GiVcZIuqANWsSxTnyvBz761fHQYng7GDH1YMLWr/we+289fGHrLSfN
f/P9dwNyPX5d1PEuwFzLWQlF0IiLSkP2tF8rRLGlCQecdXhgJLZ65lmdBsy7
FzJ+lTIP+q0uPMBv5SJ+Hbmh3ryF5vciuM4z70Ssb4MA9K1/NGQ4CWieKlZ/
iER/yO5HSPajjYz+EJtZ/SHL38G/+DtI+DtELitw0MiYaNdGv5sd67/1sOv9
7SUmbfh3nuhjrH9NF+MPhUNYfyjCA1vF8rsrE5+bh1nX0/j6RI9qeyTnpEd2
NtUTHF3rHukzNxLuTpH2MdyTDVYv/WuWpFfBIEbfAK9ZfcMEBg9ALYsHyLry
ZeV/ooc5youXmnCqHGK904byB5XC33kwU8eu07XmCPBtOT/L83w+lm58u/Ps
yA5U3OM3SdYrB2PvPj8zp0WA3bP9XgTv/YTDHc8suZIkwJXFNyvzxDPxykuV
0jUFAiq3jN624GyYvwBlTZafeZ4Tj0dCFwUufC1Aw9Ksz+EesWi7Jj/V5pkA
BbefV6m1B6FlxZSX74XrpNd73YaqUc+w9La5Qe09Ufw+0t7SO3+uB3K94Y0/
1wO5fhLTH5D+jjH9AemP7Icf2ecdpPbneYA8z3bmeYA8TxzzPqCMfR/TmPcB
5H1oMPHVkMPGV1uVs174x6fffU9Gdpd8ezvVl5M8DwU70779zuTirQEz3198
JsrTQOTJs5vGvExJr0HL6CfXu5Q4aFi2aQEOr8WRA10/BkcXYNiVMwNLb4ns
EDGjdx/eYlKDB3t+fAswzEeJ3bOW3rhYg5FD0/3fDEvBMs60m5cX1ND21/14
F1fF4aD0Id4/hXZleGCzVV4rl4PT3PK3RbYV4MWafqbhLRw8Ypff4eFcglqp
G97X9XDwFeBQj1Ec5HKXGsy/V0z7H7dHARSfltKyruaSg7V1HAzU8Jf075uP
qvU3vQx+cXBH+a/NXbY5eEXL8u4EHgdLs9fdH1CZimH5OmWRAg52ik0c8Kgp
BdMuX9ps0lSKjS8Mz72RycLl2+9d5/zgoITuEOFfEt462+13tpuD5tdCdC1T
3mOy+I/8jE4O9o6PWqLCS8LyAukVG9tK8eOqp9lNry/hNL5gjsbYMqzxKg06
OS0UN91VShr+nYP8lTH97vRLwvEHZAJ0uQUY/XnCwkjuB1zy49SOr7MKqd1l
190TpWGfi5Fv1H6z9mEZpIxuUbwixOHrB7dMVG0qg101M+G3agk+G92TarWk
Elbuvd8/bVQxbmP2Q8hl98M8Zj+EZex+GCu34o3s6XPYrvktuf17NpXbPvsE
wzSNDyT+EP4VfwhJ/CHD47LOz3XrsBP3JFydm4ih+TKKnR9qUfa5QnLEI0RZ
xj+XrsvvrlfGHh+WhwsGPdp6pvkR/fdHTjcPZQZGIZ/BE/Tfk1/mjHmV8wiz
/w2cFh2H2gUZO8WTn+DoKdaTec/icAgTXxtT2pn42u8Y/IGhLP6wOPijqeN8
Ht1v9F/GjvDZ9wXaZ3fHjhS+RyUmPiPFoUcrtkRhLhdk53wKeSDJgw2p52Yo
OrSgh2fv96jvPNh1M81JsLgFe19Nsf/Xr6d0iAH/fl0r1d+mZoxf4d3biO//
mfHNbRyfyOt4jJXX6398mjl1OJfK9x+Z6yGSvZ6NRw0P2XjUvwTLxhU114M6
tyfJZIMQ1zLjAXd2PJbMeEAsmBnPbSa+NWxm41uzeAOCWbyh81Bb4WZoKxyS
+2B5tUsAjhfvyK9+KaD8E+6C61qHhfvYhtCPneOqGnBy9ah7M4T7FtkfWPyK
BL+y8isS+XXr/KcbJdra6fVE7naUt9P4fa0e+zLnL25nz99c5vxFcfb8ZcdD
/aF/cywmXxa+h3X6b/t3t9LxARlfdWjRfOlZzTRf4SX3y+iQ2ITnBunIaSeU
IWTImuo2NuHFwbZR3yaV03E9KB5fd0u4/hxPby7pt6gBs7vHzD0vXomaIU1m
o7K4qOUb/i1VuP+Q83ifmi/nqnC/yt+Xdi3Qph4m/dR87c7n4ByNCL+vZfXg
8LGk8nKfSjzNtAekvQVMe0DaK2XGS3kfRK683K6x+8kjDl5hxg9k/IuZ8YMj
O/45tTdCP81thDnbJs70quGguJdaj2VAI+z65rvrk0QlxamRFrcNG/pW4vYq
yeXH/NsgVPrOpyPC8raXb/r1Dm2HNof5a0cLn1+C4YuhLssXY+N9Ion3uY+z
SS7VQpSHisVPQPDTkLgnHzcJ+BQPuY3yexVpL6D5jAKanBZ9sufj2hLxIQpy
DWjQ8WBfS3sKtIilXOxpKcWf6S5N0XfSIF21Kk+9sBT5KqoD180oALFW9bqU
uaUY02lbvkO7CG4qzoxz/1aCDN++Ea+x8S0Dxp+7Nf5cEbUTBhua57dWfYFH
zC8GRo1Y0U/sCzwrGNTXQykfuydJ6BtVV1E/QocZlXuaCmtpOcLCKqYb6iBb
zD/0nk4idl7bFbm7vYjiFZ2KIxZFNytoeV/5u+/3X1XRsrbA70a3BQfef4sz
ttlwAwZ/F0yzX1gL8dzmphGBkTRP3Csl490mt0V2cOXcX7POjo7BnbOHbPh5
pJb6IQhGSldOWlAFXvO8pK5OC4G8FW0rTxrXg1m7Ng7UvwIXjih+cjtdDtOD
EnV/a76ldq7L25LmrHKNpPveCVnJ4MN2L+FhY/qCfyrLaZ7J5RFeKyO8iihe
8rT63Hz5diFkpk68LB2bCU+D1h18t7KI4qP+G56+/3K5EBaMeC239X41TFzx
6oJ5+TlIfWlzw8CIB3oJf/QhQPQhraebXB0ruPCgORm479uIPQSJPYS1lyCx
lxB9QWfkCd49rXYSLxZJvFh2vuFf843mGb074/Kcwjnp8Oawk2Rqloj3hFcn
H9n/qpTaBQ/Oc7lt61CC++TlNQd25MLlzhd5Em2fYY/9eqXxI3JB0kPpQu3r
TAhWGSS73TKH4liCU46b5ye7u2eBZsL7etndQnktWq6quqEMPj/T2u86M5vK
vdoP/uTPoPpIkq9R0YSb1tebBxH/bHj1tVSUJ9nT+MChh78FuBM7z9nvECBb
D3/VA6k3fVnw23p9KzwxmiZ243U1rkodxAfPVqqnJPnW3vEGvOYNqBHlY9eq
5x+oqMKlPz1Lfaa10nyX1C4cPmp7zhAePm3YHXDKTUDtTSWMvwnVlxB9NYnf
j5unNatO6KDfg+hvyPecNmHqaY+nPNA5/Py6z7NGms8rLFw9xkqtCSv1/8TL
RRIvd8mgP/4MSPwZWH8VGv9KbXddz4a7JfR3WUbB7zUe2dh/ilHyw/4F1I+P
+LsQO1Y36w9D6l1ddqx6uj0fV6Yvur7E+w3G6Zm/U15VSO1Sp1he/ZKYK/YX
gupoO2OXLhXz9i/CzU3JOjoT84j+RJTvjR3nalZ/8uCU8W2z3DIMakrw+ufD
RyoP//hvvAOKz7iP0yLf7EnCI5sT9SzMs4TfR3O+bEDU/+QpPtXpsqRkXjba
Rb46VjgtBzfGW1r+Nk1F5b4bbqhE5aKxlfb1cXvisflUxADN+xm0ffL9SD4i
Yv/c+yHruM3tAPQ8mXHp0bNKaocj9ju+zFz99HZEN2X7a/H7SvCUxPusTeuu
0+epNE6s2db5Ei8Oe12zWaWU3q8bEjVZgZODz+4fmLf9gS/Ff2asfiiP0Q9R
vRXBX16sfKj06o88COmsPHiKkQdhBCsPxjL+IWjO+of4MP4heJz4h7C4+Q2L
b+csM1zkP6KS6sWIn6jMsO2lVw/Hg124U0/NvAJaT77n8cDMMYdknxP/J1q/
iPE3wWDW34TMn7vBjXeCGxOI/Q2J/Y21zyGxzxH5O0nw6lxhYAnYNU//hrMF
VA/3cNY7+LheFJdNXm1ZmN3gCjQpSm0beaOIxhtT+K//E71ekcnnRP1myfxX
Yf1XyfeoYv2zHBn/rP/Jc8n/r38WHd+As8ucs06/xIV+/kviJb7Q52f9j6jc
+9fzUb0Ba99DYt9j7X9I7H/PJicI//jUP9yP0U/gAVY/wdbD33lPBy+a1RmZ
TfmYSPI5sfY72h7R9yhMsZSL9K2B3f1lZJWTRHkZiXwlxbbH1sNfefGA3E/6
j1fe2HB/SSNsOFSl0m9kG92HCa/EwD/Q0Vq6FUZc/bD5eLyIZ0n6i/jv/bSe
tO9m2tB5SKud5Gei9jciR5+xajz+7BcPPBzUtlZt5YK0d5jiNkURL/EMez+b
D4qeV6SfuV+v+N4158GyYes13o3i4yL/37OWfuSD8f3Xh9cMF+krN5wZLGMV
Wk/tcs5MvidaJrxJs7hjzx7w+VDC4Cf63kxenl4yyloA6n1Prva7ygO1pSHf
3mZU0/1qLqOfxH6sftKE0U/iYVY/yWPiAdJ559BSNXvSxDIgvwZM/iacyeZv
IjwXtZV6fSLm8FGTsZeAM2svSYObMq2dPKqv17aP2jTnHz5UTOp98kiplfob
SHzS2TL+egvdtzxf75H52CPimc9m43zPLV24xkM3FAJaF84a08vBsvKzl85s
fgUfF38PdRNe7z7w0aywXS6gUVh96otiGV71zkrg7AkEG15OsvIEkf7eQjvz
JnZx0KC99JygJgnibL9PseksxXudjQXc+/FwfOY/46f2LcPoKbb2+o/ew7ey
tCubhO0/enR9aItODIwKk+tZLuyfjHdnqbNO8pZC9DNpDu5z9w149m8L6DAR
nX8ybNxzsk7svrk3e5UjPiqrUJO5XUXlVdLeP8oNocOsv5DvieR7snw9JHy9
07+Op5Sk8dHh8lTc4yQA54KFYe1VovyhrP0Vif31V/MIeU6XgL73qF1Pzf2E
8uM6Vx4vah2f2Hfpb8PDScVz1oh4tINHn5VbqCGAv/Kagkq5WFeAHh8U1BOH
Wta10/movPtC4/4akR3ZZGzc6bUZPNCNzrRqE8o1y4efGLRpMB/075w7bdbI
J/nO6Hwn8s1V1r9/v+yf/FugyebfcmX82eEJ688+qTZQCqMT8KT8/dkye6sh
Ke5Pfi0YxebXgoA//ucwkvU/J/7IBstDn37XE+UnlT1ZLBX6hgvNf9ZDAs0z
Kkh/7Pk+kY9u30NaZHwEYLFRxcX3HR+/BM3+WR/7//IPB+y79OybEPexebaJ
vMp+H/reNBh/a8xg/a270FI2YmMLNHQOV6r6KsofOZaNx7B4qZiUk141Zj4N
lDq0vUWUX5L1X1Fh5EPUZOVDwtMyFRzU/djbgHXrVdPuePJoXl1i53vFyo9s
/hd6jk8LMDBM06uh8oc+k6+RzuuXjD8FXVfk/HT5r76a6uFIvtvGDTJeUVcK
6bxfxfIH66OmzVFWT4Zj84KkPR9V0e/Tj/0eal26hbYZPCoXK43wX2ZdUQ2j
VFNu5salo9mUruhhw2roOXtki5dqrUQr8AfJ20z9ycG5wTsllW9Vwi+e8rsj
+BCvO38ziVIogOUGzkWYEQeER+dTY2Jg8T4BRh/+KYEHOHQfX2L0pl6ukgNe
Pm5aYYJmaB9of08imgNfP19PS50vrF87e0uOOAfOz3x++GBcK6jOPBB6XzyG
4h6ST/1MeOb6FKcv0Ldm9tfl65Nonndl10uzPU/EY+KBZrFntg0QMSRzhFh0
PJov9Z0Tu6GBrFcg6/VHW0FXaHczjbNK8i4HK9xe/uKGqOxqJrtAUrsSdzF8
QjzN8gmHBO1ZHjGbT/cDnuL+rVq/RPnkHwt4nvtutlH7W5nRiFOTMtqwCg7M
fprMg52FRhLN8W343W+I8rViHqyJCnXXONuGXr3c2QsN+VA4YF/6gf6i9j67
n7i6UZtH+7MZZD9p2yQhjt1wtkM8iw99Ty42567goePn5Xmawvs/23EH+bkI
UH8+uG2rEACnW+/S20E8CJ/eb9DhBQJk45lQuYPlp4Mky0/PfnExoX+MgOZb
I/PmwSaO755/eLjNTVz9dXUpjFv78LWOejNavKtVnhJXTv27yLx9/iNGp8Cx
GWVfNRkVZov8v6h9fST3WMH7ZqwNvLfRdxwXNdQfpy2aUk/zAZtd0LtX3FlH
r88+YvekfXI9lpsrX/bTb8HYuf7DH3FE+WEnsfFYrtotj4a8ZBw6O6B/lE4N
xU3t8tanBi+owUCmHkg94WeR+hxG34YTWX3bTEbfhkTfRtoj8VteN5i3z3Tz
ALORdnNihOeduGrFp0BFf9id/CmtRVje5Guyo482Dx6tPlXW1c3BGzhGctDX
drBdUtct+DcfLqNPoriQ8E4v/5sARj+R6g/PV6iY/hC/j8ceVF1yGVlC9xOy
/vrvUTF2f3IV3jH8PnouEjnGlo2ncFVtkd8NHheXPx9odOjIFxJfl8rnpL8T
A4I/b/UooHqqMSNCNzh1Z9M4ZD/Z+F9pUYHLiqxSKI+AnFvnC5Yv8O5TCGFK
l0YlcOtw4tKbladMS2lcjOD5n9++1imFOgeruyue11N5nnxPZTYebpjj8wjH
5wW0nownKII7uLiPKC7aGWNVR2PVYnjVkhJyOjyFXn/dLGGBnlUejJWJShHs
qIBwZjwwlh0P4c35/3c8FB+w8YApL4CNL0zL5HkPWBUEVY3mED4flVssmPi2
1P+L4FlF1p+LjN+N5QfOZfiBSPiBckx8XTrOBoZPR/EBy8ejebvZ+LTUvqDO
xLOlZZbfRvEAWZfp/+XD0Xqid9Fi5XGiPz7OyvcddzvM9Wx5VK8yiImfSnkh
xkx8ViqfkF8SX5KcO8ofrw+2vSSKW3dH3eZ38DI+tYeSMtGLket9Ax2LPJJa
qJ5gm8bziHevWzDbJURV+l0VRvyw7KNxoAV3F1eMDSgU6RXsfqv3tgnl2TVM
fgwcwObHIPVEPt1+63dj9cME8H4aUZ0uXYg69fIn6nQbqX6Oz+T3AV02v4+x
n56Ez8cWyv9atup1rPGmFgxMPjoib7Qoz/AOxdfrLk5ogpsOY62LHCvpe433
bjCRMmqg/mGxTP4W/MHmbznC2ItwCGsvOh2ZnzZ1fQXFVavPb5t0aU0FHFv5
sOrTnXYoPj1lofdALsVLPxn7Ds5n7TtGkgG2GYNr6P7DxrdBIza+DWlXY9/W
zIeSeZitbCqdIcRtBzxzakuv5WLLfXvzvLQ2KI58LNjwNQcDZcyQc48rio8p
rSuVNqwBfN2KZ9jGvBbls2Pj+5NzrbqAM3qPHo/o86g+P14uC9Km8kXny7Pz
6kvuCWiePbJOC15fGtA3uAZd7Z98UM0ohm9PZvn0TagR2TN9dI+Nl6xFK41T
n4FXBl/tdV4c76zBua+1SutCy+BH+stHIe01dN0azIs4Z+pai4lHE97NKKuC
h/yHwdputajyeuJZta4GKF5fcS6rP5f6afiuDY5rr6tHrtKQpk+TG4CcY+x4
qb842SddHx3ZsmKVcHyai4dVZXyGfUbcuEVraqjeo6jzQm7w4Rrs3vOiRzs6
F3JGf8t4bVuDwxqHr+5oaQWJY6WfD0pU4iCr4itR+19A9rum/Qnjyui+f3xL
16E5Ddm4NflbauyJZzD4S/iKjrps2v+Lc2ViyQ/S8VXG0tT7K9LhNvOL11dN
a9db3AD9ImBF/PAviPaJIYb7G0CRkcNw8xnfk53fc+k+fN6vW3KfZB4UZ/X5
fmhsHKYP+xV29U4ZrXeuaZ4gdrAMZLbxrzV2RqOBfFxQ8hIufPp4c/Ren2w8
95W35Zo2l+4DP3uL58QbVFHeJdkHc69sP/519lu88ulE0D9VmWB7UerR0uJo
MDh/NynrayFYLnyw3H7AWzAeMM18V2Ah1eMN/LNPFsL4lU8zdhyKpLzrJItr
ql9sQkFl6Um5jXZlcCzDdU3roQyQZuKxoiUbj1WZ8Z9CJ9Z/qsxvVVhSVjnU
5XuJP5MpBoec321rR5aD92PdgZNMSmAYkx8KK9j8UL+u+O7fJZmLNzmnywXL
G2FBrFeKHPcF3V839TPx/H72OWro79odMbwVjjJlUGfLDQ4PZl41yqTrW60x
8/J7n0zYNHvZ/odf2+CfNfsnjG3g49Yw38rakQLgX5xxfv7gTJCx/qWQcIIP
k7PnGerLZcJYnZPqB8/yQWyvz6wLvEx6bgUVXVpfdT8THCcev26pI4CTZWNC
rnqXU7xafD95nfmVcpCYHLtbfS0fKjPi3py1Lof+Wx3PLHvEh9a8pOkFr7Og
1N1WqUWmA14s/aYcqZMFH/ok9L/xXgAr21bu6DNEAAsNdihp3+LDXs+6kSrS
Amj65HHX8g0fQnrcnNevCwNx5jthUeqDIjPvLOi1myInMSKN7vczcj8bLOr4
iF2NWjMLbmdD+5/19BEtAh+HftxTTc9R4kcV90z9S9neVCQ4YVPnTq+5vN2w
utuvl69TDX3Ev6nNDr8CnKO+YY6O1VR/Q+5/M1TvU/+SnZjC6x3gvqgGeJfm
365a85ju67UqMl2lkx/hGNMnFfOEeIrg1q9mO7TFXOLp+UDwWE9KtvVMzSw6
H5sbviaFJ2RRfKNcyhu8xLyM1u99OGe4YVk1POkjvSF0XxC2GJTzt3S0gk/v
g7RN3+7T84H0O3HmjTCD3DaoY66HZvb6AuZ6qgcj9qAR7PVXhiiWPjV9jwrH
w8TTTjbBgULT+o6JkVjH6J9gjBFku0e8BYvvk5cNDW+GnSEy4tO3hMDIkeun
u2i3gB9zP4xh79/F3A/k/p57w8rjR2WC54ElvMcTeLAuc/7WafUZAANkA4cn
8eAas9+gGLvfxDL7DZL9BqsDxs414tP9NERs9CvrLXzQumUFcU31OMlcc1f4
Vj6gc8pSNeF+rHDpwBJn9xb4WeySX76nCo3zpPVWDu+AfQNM3mtMLSY8OnS4
5T7r5QERr46Ul8kkW/m4CCAue1ytSYXIb/EvPh6Q+4jcsYY9L+KY8wKD2POC
5QdTvQHrL0z17mRd32P9hRPvupvcnyLAPAaH4i7YsUFrXj3Yi8ee79/YSuKv
4kk2/moQEy8DZ7PxMjKZeBmozsbLKGL8S6GH9S/dtpijZerWgl68yarOx9Op
39fY/8ZbpfrPOm3TMihspfYfmtdGsvik9sYM7GLsRWDL2os0GHsR3c+JnsOJ
tRdVpT9e9s/kXEjfU9AQ/P06XSdlxklhJ4QouVvtfvg6pRy6Tx/SuLn8+eNs
PJTZs1napRluMnxYun9WtO+eZ/s0Gya92LO2SVjvcP3hSLtb+Xj32ZKlVTF8
NIoyM53bLwE/79v53M+Yj/JmPRirEgQH5n5ZU7iUj3lzLd0+Lv4E6eIr5A4d
4ON77SaNxwHCdcU/2i/6Dp/KGX4jbb6tGtOOD2SmTb0jxL1vQzZ2fd/Cw0cz
FRr1shpRcPDUm81p7eg4Qba8Yh0fjzomLfquX0/fWx+ehPYRjSb83P7g7VXh
PNf8vfx5xtkmdPDfMq3aPReTD/6yXWXZhEvan1Z9mPtZeI6ea9ih0IQjueHB
FhGfsftlpflnxSYqH3d63HD/mtGILwyKw0aLxaOn59f1Zc2N2BuzfMmK7w+w
uP7ttsFZovjn5PqtsX/qoYStR+Z+IPeT70HGu5EZD2Sw45nFjAd+sOMpYJ4H
yPOcYZ4HyPMQuVbhjOKmiBdcrLmln2ai3Qy/rK9wZ55sQMcj9fFBz4T7TmSh
4hX5BqxtTJu9OkAAvb///Y+LOu811JIeCMvlt+U/JnJxcPASTZvbjdQuRvxg
XWx3/MjmF1I51j+RiUdAytP6MvEKtBn5nT7n8aPOvRcTm/D5vqArync+gtfn
/ZODVZrQbWdJXHP+Z7Bm6qGerb/B1IMzW8/yu6kc2sXEI6B2fxYPUH9QV3kL
c9PjzWDb57d3lBCHrmDwAfiz+ECN4X9TPGDVNmK2VmY2GCeOsx6v2wyKFw+7
zNHNgQ2cgf0ijjbBEgetrIPvKuh5oPVqxOLfHA5etyq8GitohmExm5LUZ3Dw
l3bVuq8GrfC89viP6NUV+Lz7TcYeIT54F93sfcSkAt/KqC5XO9oOYVuKum3n
Z9J96Rezf6MHu3932byUfLlZlLfEXcprabd2G8UX1xh7D0qy9p7pjeKnipaX
0/rBt9fWXL1fjpW/rXNP9eHD2+/t30uE9dFBuarTYwTQd2TAOL4xl8ofyodX
2sj9FMX9ILhXUtxNbKcGH9KL9iU4jeFTu9TqX7d/Hs7hQaysrsnk3DbC50LC
5yJ+JQ/WTXeRk67Ea29znI694GFOcNRPFWF5zZzskqwGHj52u8WV+MlBiROt
Hi63+PjIcV3OW2F5dnZkaZ4ZH8+7G6helKykfLN/tkZMHi9biRsZfQ8SfY8n
o+9Bou/ZdmL8VLXrbfj68Hnu+yGVaMzwo7CJ5UcR+5kLy89aHawhtaN/M8b2
Ljr1Wnh9z/LT3T4BTXgkaeB55TQO2jdP+zh6cDNecXxbO66xAmcyfC0kfK1f
1//wtdCS5WsNYdYP5QkQvfYxdv0Q/JM91K7IjMfBQvWV2X6tlXAzXO9Bq3B8
deuCXJfsqIJ2bT2/6WKVuPagWaFrbDXsAf/ObcKyeNHJm5prq2Hi7Tvdxd84
lG9k/6DDYkczB42yna9uPF0Hrif6pf4QXm+50tVz+KA6mDKkN82hk4OTW7Kv
9H1VA/H3gjtshPg8mr8+oFKhFmpeq6cFCK/fxLwPSGLfhx3z/ODHPr/Yij/v
BxzY90PmDfne15nvDeR7r2W+N/z1vYF8bzXmewP53iw/jeBWur+97NBXtuG3
o7783euf5jSDRITMiyHC80HZIOre0idN8DZk/HGNaTwSz4Oeo4RnQ+J5TClS
Pbt4qQB7qtJXDw9sQTbeGP4VbwxJvLEbKxtj5sYWQOvU2VL+t2tQaoe499vP
hTDj05X68Y+FePj9DG73iErY8nNV1IJ5tRjioq6cF1kJSZ/yDE8b1tLvY+r6
4cB4jTpUnhGpoudZBxOZX/zRbrZol0Id6EZO7Vm2tw4PMvG6YQsbr3srwwfC
xywfiDyXBsv30WP4Pkj4PgR/uvMNI0yF37dPmuSxT59TQdWEc6j4FwdjxM1m
Zft+gsthFqvv9nJwi+kLh9NyWXA4bLVMirDsdP1iw+uVGZDzwHyMt/B6gpen
7leZE/qVgy6HvertJPNBcqLb4X/jk8cq7j9sOvELjJgYZskVfs8qFeesPMsc
GNJaPnGp8H5B7v6dI1bmgnGwYhZf2D4ZX/cW50NLzxZg9Kt1vQX3UsHcRXHA
2NQCDNj9Iu7EmDSY77pxcu+dAgycZBa/emM2pOjJPB4rX4BbJy+C/ofTYfXw
Yn3pIyK95buC0knPhfM72vbzyzZOAfzoHTzgrHA8W64NM0tPKoSvQ9f2XS8c
78txDpNmXiiBfUf53IvCcnXH4I0+AcXw7vEV/X7C64k+I1pqyEiZDg72Zhf1
FxerhG7mFwds9tyiOo4Dm+65SKUI9x/rbbtfrd9eBkP2d2Qe/cHBEdMuTfLR
LYf2TXr94oTty22JHfPV6yMkB+tUGsiK8lAeSKzKb+/NRtXULA23iDZYxNhj
8GDDTxPPnDIwPeC1NnJhIt44p31slrLIDjjqxL1bZoOroTB1aJH2igTM1Jmo
kiVRRvH881sDXdGtmOKQ986vkitWFoPy5+y6uy73QS1RMkr8eQO93ttoj2DA
oTy670+1GZUya+oXGPJrF2fbwXrYwOAT3MTik80MPsExLD5xkahr1Bz1itqj
CA9xzxqbo/uOtMCnP8+bCc99k1a0ifPA52hdi017Bj1vCH/jbeLZvXXreCQe
AhJ+Gjnnz37bfDKtpAbrOnv0f9aWwnSGd4mZ1tssq7n1sENWfNEzJTd80Fdq
kX9gPcWbRG8rFs07rrtFhup1P1wPk+yODMD39vaD/RS4FOfl9b2cmhKXDodd
tGd9u1xDxx/8VSrsQ3s15VWuPWGd1DChFsLv2I552/kZCA90RdSbKRn3c0F8
XRu/cE8DdDH6CfBn9RNkPelavJxm/5gLdsXSz61ahNez9tyxjP8Zvmb9zyI1
71ZOe5eJjreg7W5kG8xh9BNowuonfgSl7yr4/YTyAoc8/FMGUpbdr2CuIplF
5YnTPa0eyqtfoaGWvOSWf+NiJo1/eD//DZUfFjLfD80m11sVp/CpntE+x2R/
4Cw+5Mufm3ey/jnVK/7DtAfr2PbmMe1RXhCZDzvY9oj+7ATbXizTHvV/m7Jg
9RhH/Ux6P3n/B+y+Gts95sP+Ws2He6xCcPgasal6NXxQ+VGyKN7gA7VjDXR/
2bwhMRK7Ppy9YhgsABmmnuZlUGLqgdRruTW+NptdgP9GoQlI4tNze0FauatE
HR87fuibW6tnYkbJ2e6Vp/kYx+AZ/MzimUfuPx9rNzzD1zWPFFYt42OS6R/8
gwT/LKzJie+aGwt9ho9I7buejwcZvAQEL8W8+/Ci62wOqISIH9zpxUdnBl8B
wVe6zPjAkR0f2e/I+HS/fN1h8bwGXlXn3Lv3TYAXxRU5Nhm1dF2R82e4R+xe
O+UOdHdsxGEa9bjio7r8bG4rtX/ls/5phCdk+V/7PBA5hugd787J7SutJrKz
kzKrD0CiD9Bi4kdiDxs/8jLcUnyRkgsWB437Fl7Mx9u199/J1Tai8/fZYxZO
iKfn8NKLc33aVSPQ+N7B89eSRf0udxHPGOHSgqdK/ILMw2Kp3loyb5SaR59k
uFWRPJe3voWOa8CyoTt9j7aK4g6x5+e7o7+KD86JBmn9jOHPoJnaKVcw7cM+
tn32fqrvJPvcNfb+AT5T7ezfi/JWELsvsc99GbS4xfF3Je6Ul3JtuZJD7eJ7
IuYv/HkxD6SmD10vc7WSnrNE36He6Npi+TIDBL73Rmc4c2j7xM9Al81HcZ+J
l4TAxkvKZ/oDM7Y/Yg/Z9N/+6D5E5NFRbH/XGPslLGHtl2S/PMjaK4k+PiJH
kH1WJxc+KEd/GrK9gbZnO1tjSr45Hz4+dXy4eNwX8PZVUw6T5FM/UbLv501X
fHHNOJ+u8+IWyVKj+hwYftxT+Men7ZH3Sex/iTbBc2qvtVI5evUkQyO33zVo
3eV5yFy3ivKk5aa56TX/qgaLtQNKvKJEdoeRmrvGuaYkYn3QE/M1W0uoHqX2
v/oRqhdfpXFvjNT+Aphhadozd2ox1R8WOnbPq/IvhCRmPPQ9ar5yt84PLMBV
pufM29xqSD4Bug5/DDmheMO+mdobyXw3ZfmCIxm+INW/DDc9vCNEKIcT++JV
VRXz233DaVny5PjehPRKCO7d+mSFVCO8jtEasPJUJVxvWq1mIdVE54sXm5/k
yNLOXdqD+TjSRmLqsUY+nHldCrL9hPve7+ow84ECUCvbcrmOz8NJgogTP9cL
4K2Vrn5TCw+NBg2Oc9slgKpWzYLLYa2YpKWNl74JoOlJ2j85ea04ecW85Dev
BVB0bu3EI3EinvjzJTvPuMvW4OJJOfXvVLOR5cegFMuPOTdx1PmJo/LoORNl
q8BPv50Lsp6RSz/OuED9Yg+z+MaQwTdI8I05g29QicU3Exh8gwTfRDL4Bgm+
Iesri8VfOQz+QoK/qhj8hQR/rWTwFxL81VP4B38hwV+2a5Q5yd1NlLdA8OUj
Nn9YIhP/DzXY+H/hTPw/nMrG/yPrIUjr25tDD9txRq/6fUfh+iHyD4u/KQ5e
xeBvjGbxN5l3U6ZXDRm9oAW/X42QDB9UA9eU1wcaPhXFrYh2zWxcLPwuu3xP
fQhBPrX/rXt522j52jbwOavkWX+oFt3fndy0rbOVylcrjxy+cMGXDzO/pj8d
PrKWtmeeo56+1qMGM3r7rOrzgk+v/3Bc0ezxMT7lZZNzPUF/6gT/U7Wo4dc6
QsVIgCpDpVrm5lbjgr5T9sZLCWgeNILX6idtGzuzXw1a5MGpqc8FFN+8THv/
U1UuBeQNH1s/WVCDAz20Br0Z+Rmeno6rD1tZg02vP5V7rcyHtAH6Wbcv1+Cm
xA+Tt2EewM9jL/Qda0j/QPpn26f+EnuqP56YPCYJFmdvzj0kxCtnWioFPMME
6D8uLGt0Dwdtctf7lW/2gdzTOhNmHijExN4BFYdPOMOiHXs4aWI5aKowbnw/
sSBwfW3nObcjm/L0tu63lE9TykPz44P9i4V4aCv3WeOLcUlomZEp6R3ApfL/
M9kFm74tbwV1qTkXdvfLQlWvFK5WUSvdp4hct1zpqE5XRBbdJxrstze26mXg
nTGOmqqDWiGckZvw9uJTDx30G+Hu4Yur30+PpvbUq69ufLOYHoG1uiqvH89v
pLw3FW//1sspjdS+SPR/ba0/VyVIxVD54+KGCTHR8By2NJ1Lk1pTROU8i8YU
/ZM23uDGO7rzctoXkHeY92OY2y245FRg+SXqC5X/Ktl4cbVMvDjKc0tj5G88
ysrfRE9uzMrbbxl5m/pdSdf+fG7Z9QV9HhyrrDxSB3lMvBdMYeO9kP4i2fhz
dYl/4s8B4QEdYPR/uI7V/ykw+j/czOr/ZPbd65Hbx6f8Czvnlv4taXywGnhP
/LiTAPKUUsQ632fQcRJ59XtrSe4+xc+o1evlraxdCrOUsrZV3XyKBiC2kxtQ
SuVssn5HnykvP1z0AApqW4Zekaum+I3gmO8sDiVlBVaPMIPhl4Ijyy9dkj0k
/GVUAq60Om4xvpoLtb8CNx+2j6J6FPKdFd+JxWUMbgIBU0/1oSQOxxi2vqn6
yie1Dj79Ze2hQOyhRI+8mp3fI/3Ptmhs4IP9l6bUQP16nB9j2XeUawvw3WdP
nDOgkvLuri2OCPfuU4mWo8doZe0RgOSdW9tmCcuvGP0JJrL6E+I/Nth9zxkj
YX0Pd/AwG6F8GT9s4B1pYVncrbXv60ABpp+dmy/3rz6C3T9I+8qRtkoKfD4u
2P1V+7twPbP9IenPiOHb4ViWbzevf3WpnWE7eBveaeTOrMcPf/pvA3/nuUm5
NnVUb3tzS3SUYlA9qvvvOTNbWCb2s8bv751HxedQeynhWSruc9rZ/jaZyrcJ
/5WfqPxXsnSm7XWNFAi880y9IfQzzNit2dNndwpc8NhoXdZQBGUMHxVPsHzU
PKUHkPMjEYNvtydJSFbDmD/7bhLq6yRcWFFUBYe23tB8lFaJCmUZnKn9Gqn8
efi//BhRPJRjcoKw2CRs/bH1TFpfLpxU5E0K0UzGCO2d7puz6uHAUcllxREV
cFN1dB/zw20QWRhvkSXOwxKDy3M2rxDAjhmV+qbf2tH3lLGbnKUAxFTRZAmH
h7aSx1LH+grg2Gi7DW91y6nd74ZzwCuTZeXALRncvr5bALZfFA9Z2fHpvMoO
rRi2YBcfBLHu1sHnuTj3wfuDm1a3wAT/3nN6ETz8uuJZSqZ7M+VTEn7paoMz
gW5PRDwsQxeZa1F1PIw4urv3mUsLjSfEZfiRoMnyI/faWE+M86unPDqiP9jO
8iV9DJaZLLVppDw+sj92zDhqU6TPpfvzZYuF5dLilej78u3Y0EX1UHJud9KB
hWm0vV2/crlBuelYrj1hp55xJdU/HNU4t7fzeD61a3sx+hmqt5jC6GdQjtXP
DGn2W11aLMB7d67nu+XyQelHx0+xBiEOZHjfkHjCruZYeTnkTlTSD3Llgdre
oRW9XaJ4M+z98Nf9hDdOcfNf6w/+Wn9A1l9LO2/lfsV6XJjJr96UUCfKK/Hs
zo/RR+rQK72zz8j7dXh/7+I543zq8M9y+M7DqoZ+YS+0BGDkZCBzaGQrukTV
Plvym4eLGHyLBN/acf/wQZHwQS2n/+GDIuGDjhjhGHthUTEO/Ge/jc7jXDzZ
LfE8e1oJ5jmk9VnbnoPZv58Hvy0ogJq8ls+XR33BqVvmdCtfaQJFl73FK6SS
8FPX52hZDR5scih0Hj77CyZsfXpgpXw72MTZeoYP9AcbBt/gJxbfbDaQn2Lw
QAAxhYLZBabpMN/VQUl/Pg8dPtipRtiWwBoGn8A+Fp9oMPVwiK3XeqE5S+tm
E5qcdVwzsJAL2kwZjNmyh/2//qaraZwPD5c/ZSDlw/Hr9Saoncbb3hYdh3V4
kNivymvMMW+MWHnJsvO8yM/hyVANB7Auovw749FHptRFxVO5+wXr3zH1kVbb
pCkkX3AblTtns/w01l8Gib8MsbP/JV9Sf9G+XtGh/PBWeCI4/dXrYhOVj8ey
9kpyXgZl+Pd7FV+KThZl3Q8WNOFbzdyoMLlSjGu69HyITjVI/9jEXR5TgCeZ
enjH1jtrrNv4+Uom9ZOWMObfKVXIojwVxSfNIUtzM6icXa/E0Slc1ILlc/3d
zi1uRCn5Ws7an9WwYV/V8Vlptdh+/9nmnZFxoBjyy3FnXAN4O2yqWO8jQBJH
OQ0u7RvyWoD/Pl3yFgFc+MM3ukvlAwemTP1E2OuBXD+F4bdhEctv68v0j+vZ
/lNKN6652MaD87NVsse/fYmmzrMzVo7Lhtz+091tAltoHGLX47gP5rciGz+d
6nGyP/18IP2pjY4ndGOBk2txJvUDJr/blvLEVyrHo+Zi/jK7oQKA3yPt2uRj
UCcy4oBxewMc+nxh0cw17VQftomNT8bOdyTz3XZ6emqgNJ/lS4v8/vryvPlD
OU0Yd6finKkZn8anTfrYaGk7mg8ql8qC2xQK0L66vOBjBR/ans43uqYhgAmj
JG6LbykDQ8c7xoZLMlChaebG7SPawS45TWtjdTMmM+8Hbdn3E8esT3zJrk+i
Jx96dv7KdL1qeDl6OX/euUSM+zPPqqGUOS/hBXte1ouZuc0pawXNvoNqDhjw
cZy1XF1QWTOUVRWESYZ+onEoolh7ALEDkN8+jD0AiT2A4MvJLB4zZPAVev0X
XyHBSwXDrUJ/d1VTeZ3ghYVpjp8+prVR+eO751CrEolKPJd1J1VpTxtMy92X
cEq436kz8gpeZ+UV9vxEcn4aM3xCqj+btHyC5w9BK9qY9EyaZyWKe6fi/GLM
KD4fuI2/ZKQHt1E5beC1qtorozNF+02R/Ih/6jLo/K5n4jtgHza+QxgT3wH9
2PgOHCZ+GD5k44cd3LvlMvSPR/v6iq7cd6UQ9cnbWXZsMiwy5tw/8bAYPJh4
92jGxrt//OhOTWdePZL3Q3BGWH2I3HLTQrz0vlvt2/F4zPjyaO7upGrwYc5b
zGHP2/8D/AGTHg==
   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{4884, 1734, 4883}, {4872, 1727, 4871}, {4658, 1544, 
         4110}, {4871, 1727, 4873}, {4808, 1673, 4313}, {4883, 1734, 4885}, {
         4110, 1544, 4657}, {4313, 1673, 4807}},
         VertexColors->None], 
        PolygonBox[{{4885, 1734, 113, 4521}, {4655, 113, 1673, 4808}, {3700, 
         113, 1727, 4872}, {4656, 113, 1734, 4884}, {4873, 1727, 113, 4656}, {
         4521, 113, 1544, 4658}, {4807, 1673, 113, 3700}, {4657, 1544, 113, 
         4655}},
         VertexColors->None]}]}, 
     {RGBColor[0.2950413547931252, 0.06023045303379913, 0.5316966327857986], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1802, 833, 831}, {3701, 1802, 4964}, {6209, 2135, 
         3704}, {2127, 2271, 1128}, {3700, 1345, 4807}, {1128, 1543, 832}, {
         844, 2135, 832}, {1542, 1127, 831}, {2359, 2125, 1127}, {1434, 2136, 
         844}, {4525, 1434, 4810}, {4809, 551, 4416}, {1971, 2359, 1127}, {
         5164, 1972, 5163}, {2136, 2135, 844}, {4966, 832, 4109}, {4655, 1542,
          4657}, {1345, 1128, 546}, {4416, 551, 4768}, {5161, 1971, 5162}, {
         4872, 1345, 3700}, {2271, 1972, 1128}, {1432, 833, 551}, {4656, 1543,
          4873}, {1434, 844, 551}, {5159, 546, 3913}, {1128, 1972, 546}, {
         4658, 1432, 4521}, {4108, 831, 5321}, {4524, 1434, 4525}, {1802, 
         2360, 833}, {5323, 2125, 5322}, {4884, 1543, 4656}, {4963, 831, 
         4108}, {4769, 1433, 4523}, {833, 1542, 831}, {1971, 1127, 546}, {
         4109, 832, 4969}, {5324, 2127, 5325}, {1127, 2125, 831}, {1543, 844, 
         832}, {844, 1432, 551}, {2127, 1128, 832}, {3913, 546, 5160}, {4523, 
         1433, 4522}, {1127, 1345, 546}, {833, 1433, 551}, {2360, 1433, 
         833}, {5332, 2135, 6209}, {4521, 1432, 4885}, {4808, 1542, 4655}},
         VertexColors->None], 
        PolygonBox[{{5160, 546, 1972, 5164}, {5325, 2127, 832, 4966}, {3634, 
         2359, 1971, 5161}, {4522, 1433, 2360, 3635}, {4807, 1345, 1127, 
         4313}, {5321, 831, 2125, 5323}, {3704, 2135, 2136, 5333}, {3635, 
         2360, 1802, 3701}, {5322, 2125, 2359, 3634}, {4969, 832, 2135, 
         5332}, {5162, 1971, 546, 5159}, {4810, 1434, 551, 4809}, {5333, 2136,
          1434, 4524}, {4657, 1542, 833, 4110}, {4313, 1127, 1542, 4808}, {
         4873, 1543, 1128, 4871}, {5454, 2271, 2127, 5324}, {5163, 1972, 2271,
          5454}, {4871, 1128, 1345, 4872}, {4883, 844, 1543, 4884}, {4110, 
         833, 1432, 4658}, {4885, 1432, 844, 4883}, {4964, 1802, 831, 4963}, {
         4768, 551, 1433, 4769}},
         VertexColors->None]}]}, 
     {RGBColor[0.3016511309518345, 0.07172306870458227, 0.5409874727813796], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUto3FUUxm+aNJnOZCbzyn/SQdD4qo9aNCK4SgY1cWEpoivBWpoEX218
ogg1MV0o0ojuXPgARexLC2awrW1VXIh9RHc+ktZd3ddNMwE3fr9+J4vLPf97
z/+c853znXOHJ1987IUNKaUzWt1az9ZS6u9L6cPBlP6ppzSVS+mBoZQubkrp
ktbrXSnN9qd0VOuy5FulM6ofC+WUFnpTOtKT0l6tId0/ofNtG3yHzi/S/V7r
Hsk9OmvqbkTypPyOF2zzIe3PRAzEsllnS8WUivoek/+m7ncpptGNKeUl79a/
e+TvQX3vl/y37M7ou6ea0powfCEfHe3vyU5bNob1/Xvd9p6T/fel/69iOCR5
oWhf2D/e55hfks0l6W/X2XntOwZ9dmfgIA5iGB40luvr9sUd52CaDVyfSKcl
DB9rb/YbG/m52u1cPax8vjtknB9JZ7Ri+z/K5oh0l/sd9x/6npftN0qqWdW4
56WbF4br8oo/S+kdrXHJt0j3mDC+rNrsls39FeMF96lGSq8qrrWG8R2S361d
xoFMXQ6WfXay5JqB6wfZvCkzH27UPqe4xhTXpz3GQe2JjzzcXfQ/YB0KvIvS
ncg7P5sD11DUh3845z9k6gWfOj2u85QwbpLedM1nq3FOzeEfutsyy0tV41sM
3sId8k994VdB661kG9gi/yu6/0ZrSudf1ozroPYsby5xPjZg7p5WHlo54yFm
7MEb+DGcuWf+ahhDO85fUx5f0X6v9tvrzvGI5FbY3FmzfzDi6+ma7f5W9xl3
93V5Xwz5qup6WPLJhnMBnvnART2QPyibZ3NVY7wYOek0vG+pmgOD+cDY57pe
jn5Hpr7/NZxr+uyGsrl6jbPBVTiLjSzsrGWWS8K3MzOXvis5/pWIAa4dXude
yTm5ILzTOc8fMDw+YO48X/P3atTrycz+nop8Y5M6zUXfET+9h0zeL8V8AAd6
K1HrA2VzhZ4g34/mzA142o76bgz+M8O65e+0/v2p5B6j197OnOPpiBm/1Iwa
taU70Wu5EzOS+PHD3MEXM2xSOleih0aij7bUzbE76q4B92BZDh108bMjZyzc
0+PMBXJLXckpeUImz59X7esz7WeCx6e03zxoDPBlNXgFvxZiLhLnXMEY0bu/
5LPjqnul4vn/c83xwmf8npePA/J1oWrOtoO3cB0d+mk2+LXeG+xHZW9P2Xnb
p39b9ESv9cjfkcghuYYn8IP5zUzZFe8W5/tKnrdj0fvoLMSbsjfmB7maCbvI
YMD+XZnfAXqY/v226ll6LLjfjJmGLufEw1s2UTD3OvEGfTXgnJBnMJMP6o3v
P4OLvFfnVINHpHNW+9a6uXdb3XWglsxm3j3swMlf646Ld2k53pRi5Al+wgPy
NRW8IjZ4Sf55m8YjzoWGY54pm0voUAPyBEfXbWIPO/QwPOJ9IKfM1Ws86HP8
5Ax8V4KHzJNWvBEnGsbBm7kY85Y5AH+3B4d5x/iH2MDUjJq+WTUf4MXXFfcH
7+HZhnl5Tvv/rKsSYQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtsjGEUhk/NtNNOZ6adf/6ZkUZCEXWphiYSq3ZEdIhGhC0VnSIudQ2R
1GUsWEz3Fli4xLUs2qhGxWWlN3ZCokus2aAJC8/rLL7M+3/nnPe85/JNc++x
HUfnmVmRE+WU02aX+P0R4Rd8OWe2KW7WjNPmBrNKnu96s3VVZkcazd6HZvUx
s+PEvAOv5Azz3cv3CvAjOE6Cv8M3BI4GZv1RzxEBv8Kno9psLfZq+PoyZnUx
jzmd8pzK3YF9Gb495G8if2ed2SL8p+Go1JgdhvMJ/P3cddW7RmkdwN6FfQT/
v1mzOe5OYTuD/t/gN+QYx1bC53bgPvId5vwBr6b+h3APYm8Dv8a/gL5Ozl20
7sXnRI37pMnfg0+WfrXCvxs8hP476M9xN8f3Ys4s3J85zeAkerfXeg/3w9cS
uDb5LMGegP9Lldc0mHeN0ioN0lKeb7Ym6T0qNniP1etefG7hO0nMBWJ/crcU
rreh93IrOSfB9zM+a/UgQr5x7prgKmB/Ab6W9V63cbcT/kMZxyXsX7EPpBz3
cb6FrkFatDNX4OvmezTm9e0jtoC+jdU+s6nAYxQrjRNonQ59d7q5mwGvCn23
RohvBU+Erl2c4r4ZeK3iFLd2UrupmZ/DdhX9CXwvwrEerWPkeEA97dT8DLw8
dO4u9G6B72Xou6ieqrfaKe1WmfjH4NG0cxXguAH39axj7aR2cw81L4j7zDS7
mcB3Rzs/i7aD9CAZ85lr9uqJeiONB8ALQ9f2fwbo+ZT3XdEOfdQsA59lEf7z
4LGU75pq+kW+VIPvmnZwV8595KsdfQpOkHNbrb+xEvk2UGN7wjV9IPfz0Gcf
p55Io78BvQW9mUqj38mmN9tJL86mvDfiENdU6LNTDuW6l/G3op7EM95j9Vr/
ES34/gPONonv
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3135703994347528, 0.09244745761910922, 0.5577414465439027], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMVdUVxw/M3LkzzMx9nnvvOLSZAYE2tQwQFaGliIqAtF8K1H4opbTU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllslGUUhr+2M50uOO3M/DMF0bAomKgtGCMBBcpSBMqVgPEGMMqFBmRV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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3271150227107963, 0.11599789956743531`, 0.5767800530922244], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuU1VUVx38zc+fOMHe4d+7v/u69w6PMTLFIsSASFUTQkmoF2NIyKx8p
WQpqyx48hBFfkAQIqKAoIM8EApQZ0kwj1Fam+QhLjJRHpma5Vialktr343e7
+uN3z7nnd84+++yz93c/foeed8lpkxqTJLlXP01qX60mySL1P5clyfeakyRT
/9mGJBlbSJIB+r9dkw52JMlNuSS5sDNJ/lZLkhVtSfKK2t35JBnfK0luE50Z
evdqS5JcIDpbqh7frPZy0Zik8QmiO1zrTmjzftfr3UdEu0Pzb6skyac0p4/G
Eu11pMbH1JNkr/acKV5u1/DCkmhr3amaP0/9c9U/Sf2Pas6RMW+l6JwgOoeJ
zgPif39rkuzTM1Z8ztGce0T3KdE/R/2D4v9gq+cxZ2s5SZaL12Gp5NKeJI16
cqJVbDP/T4r+9/RUte8Z4uco0ZkgepeJzzFaO0ZrD69YBnP0vKA58zS+TfPv
F78btOcMPYfrWdtk+p16t0NrztL8d8VPl87TS7zcV/Ia1m6s+KxzgodH9H57
wbK/QM8U7ftP0XtX8wqad7TWFUQnVf/T6p+p8Yr6w9QfqbMMbfEdH6d1Ra1r
Uv8JneFt9RfpTBdp7X2i26h16/W/v/i9WzK5M/rPaO4ndK6tWnevaL4pOt/X
M0Dr79ba48XffMn/40XpgGRwm+Yu0v9h0ochGjtXc1/RnB+LVk7vlqq9PY1z
tPos0zX+A/1fIh6eEy8vaPzPeesW8v193B33NkMyeS7uf6yen2veIo2vE519
BdOcKT46Nb6u2Xd2QPNv0XgftVPQafWXirfL1H9M/Rd11lGS1fW6owpn7uX+
V1rMB3M+pvGqznWE6FXF113i+XT1D9Haqfqf05zpav+i/zvEx7uS285Gy+2K
Bp+ffR/UmuOrpsn+4wvmjXF0anW77esl7X2Rnks1tlDzh+v9DuRdsk72Uf9R
rbu5YJvYXbfdTNe5PqHxW7V2XGJ7RJ/QpcWS7zEa/1bm/RcXfK6n9H5li+kW
qpZnm9p+mcf7qj22ZB1D15rLlnU/8T9fNAdqzl7Nn9Db/CPz06q2x72Sx9ON
vrueaPdH/7iSdRWdvaiX+YZndKop7HFUs3VplGjO1V38Vu8GiOffau2jWntd
Zj09TP3JOuOW1PaO3f+hYhmOB8PE8wLR2lW3rM/WnB1q12l8uvZ8QnQyrTld
9J9Sf2pvyxfZ3l+xLjyAzWn9A9KVNnAgs01N11lPEW9X9zJ+/k779FZbbrCt
/FNrl4q/EWrf0jNcz76c8W6L5k3IjMGDxMu3M8+/UO3Fek4He3Snv0t9/rmS
+SSNrxO9n0oGTWFTXxUPbdx1zmeb2my8wL5WYZPoltqHdYZviP6vK7Yd7Obs
xPOZe2KD29eiD26BX9zLKdpvvuYtE51nc5bzBYn3Y9+6ntGaM09zfsWZ9Nyh
fo/mb1F/mOTZLbldobFB4v9l0X9Da17J2aZHFyxHeHpNc88P/n8pXs8Uz9vV
nhrYCwZ35ay/yHAW96jx2WXTXxl75Go+S7Paa+PddWXr6X+abGuFZvc36+kW
/xu17rvi93N54zf0od0TPH9GvPRrtV7X9e47avtrfJT2GInfkR7t0vyBmjNb
704UrbPBdNF+MnAY33Zjo/3kBxus68gaOf9F6xqlS3ty1vuNodtvaW01Z+wF
n8As9PJCMLZgbASHmlt9d+A6PuxoPa2t9jVgEfqXizlb2/wOzJyWee09JeNW
a8y/N/6vl/yvyMwPcvpJh+98rdovSC+XqP+O+mfgc+Ls12fuP6r5+XbbATx1
t7vFt74u/ueEXIg1iEuWaN4h0uk9GrtWNFdq/RyNfUd39+8O+/eC9rw2dTyw
RWP9tO75nPEBTEVnwPwfi4dDtdfGorHq5Rb7wbltxln4XKA5fbTmBrWDNVZv
NS7yVINndIo54Dp337fVPvuLne4/WLR9nxU2TmyyK2dbXRoYNaLBuvFSYDu6
vjZscHXY6RCd6VrR/Low6LpOxz1g+NzQTWijD8QX7L8ssS3gq7CHEbE/97u8
4vu/p+iH/jrJallvx2ADGxxrQJ8YBt3mbO9jNX30inNwHvjfr3uZq/HREUNe
0ssxxmeLtqejwo/DD7xN0//LNG+Kzndc1bj6pHDgkarXXqp1d1Qsp0kRU0zs
5Xji9dRY+i+d/faK45llFcdFxETcNfZLn7036U67tXY9d9ds/zch7BnZbUWG
mrOhzbqxXnxMkO3cqfb0iKmIrdA1bPRl0fxAi+c83eQ+LTSxIeQM3YaIYydm
jqPxZ9jyw0XHKdfoHJ+Mc2Hr9C+OM77nM3sbg3qKvpObU8v47LgX5MvZ8RPo
0frQJXCYu1mr/+MKjifwb1cUrAdgH/4PP/hHnWum+NytsS116zO6DE6i7/h6
9B0f+CDY12gMOyNsBN65G/gnvshFjDE41mHbz4jml/X/YvE2WjI+KTBqadgS
dvRQ3vTxu/hH3uHnWHdGrD3IvWvtl8T7Ts05JHD21HZjIPjAWTkzdv71Fp8F
vBrT7nnEOj26j+Hi+WdqD695Lv6EOJ44ZVXVWN43dH1mzXnLlWrP0b7nif5O
zZuTmd7iiM/nxr3cXHF+Q16FviwKnflG8AQ/XR3WmZ/UTXNnnOXtmnXxvzXr
0Vlh19d0GPfAvxtDFxdWHL9w79z/31uMZeDYqsxyu09zRmbmDRtFHvDA/RLv
T5aOjWtw3EGfGJp2SvSnRv+93KDZMSc6QAyGH2Jf3jOPuKil3ZiOn8Gmp8ba
oVXHosSk6N+IwCIweXzc16y6/f1std8sON9ELpybOIE4+/xO28l6nWlhah9x
qzDkBrWf0fjxmrM9c/+Xah/SMwbdJa/q8PuminmEV3QMXvPhe9C7fIyz37Gt
jkdPEP1Ptzre3SRaQ9V/R7jxm6rnXCIbHax2SMzBjvmPLWMjn4z+oE7bS7do
LK47x15SN//wiXwfbzY2YuezxMvANuPxtsz54vCy73xt2Ht34CO5V+f7+Yja
D1eNn+BoT7v9K/Et+dBrkWeRS7EH9K8qO+bbVHa+Qo4JphJ/bQ+fxJmGxlnQ
mU2tjoXIG7nnWalz5f6R77MGW8OXbQ3+R5Q8NiLGyckLES8tDN3Gt0N7c9Dv
XzXWgffERE2RO+8OuxnQ4PsZHPLfmPku3hadFVr3qVbXGsjNyNE6ReehujHx
4bpziEcij/g9tqN+tcPxJvqKrH6jeTOQido07zgWWueJt7fYt+yY62DkpOR2
4wJ7wTZoYjvI5gMhH2JI/Cu+dVfV+cItRdccwDrmVvS/W+vfSh1vEXfNyxyL
0SdOw+4/3uL8gvoIuLNAZ19TN16trlsnmwqW0U+Ljn+Ig9pTx07EUI156yJ2
sjbscF3defN5WveVpv/HasQNyODcGCfu6wkdI7fl3Dvi/tED7gs5P9BuWV/a
6f4lnabXEzT3Z95rX2b83Rbxxt7Me+3JHKeAC+g6ZxoSdw+NbUEHXJoc+IMO
cP/YMpiNr8BvgoXc3aDwI/gJ5II/OTX6zKfPGs4Dr8So+Zr1Y2XqWhW+Hp+P
3VD72h21GeJp7miV/s/Ts1+079L8M9W/ssMx8tfU34fc1C7Nu1Y0OnIHcoiZ
qXOPq1LXcJb3dkzA3vCwSu2S1HQWp47l/tHbMgKXxzU7JsaOiUXw0VlmmVCH
4362R053sOS8+069b0kdr82Vbt9bNK/E9T/qtJ5/s2p7J6aintAV9S3WkHse
iHyQPBZ596u6/ofN4xNXV61bv9D7UZnpTCv7fpcF/5fnnQ+Si3HuZXH25zss
r8dS54rMwccgP/IfZDgyan79I35iXbfOkZaMdWAe7+EJDLqSu9T6LrXX6N00
zbm6bNsih8e+XtS7NZrzV7WnlS3bq4qO5/GL+MTDo9aHHN7T35x1GL26o826
ROwLzifi5btl83xZ2XaP/SPPf9Q8/+9q+2qPD0uvZkpmqzPzM7vkWHFM1LXu
KDkOOD9zPAc+XiU5/VDvn2623nbFGdtqjsWIyYglr47zNqeug4Jx4BvruHfW
vlF2vnpTxbnm6Ijl0GX2AofRe+JvsJRcBv+xNnR7Q+jHq6Gf3GW/vHGQPPr1
qu+eevCAkv0TdeWZZdtSuWRZbgh5Ej8cCKz5VcXx+0dqzvnI/TZH3NKct29l
/I2oLWzO7Lvx4dDoE7oK7/2Cf3iEV2qAq/OuFcDn4NRY/nnxc0TJMdeC1PlN
V9z7/LxtHnsfVHOu3RU2RzyBnzqi5hiPGvAJZY9PKrp2ck7UT/4YNasnNPcN
vZ+Vd31gfuA0PhS7vzMwhDySPJY1zYHnnH1N2S21Q2ILdO+9eLVgHQYnqNNQ
A4ImekyMR/w5Kerg+KNtgdXwRiwCruPbqU9Qj6JG8aJ07wLRmlg2xqEfN0o+
hZLrutR3E825SzTvLjlHpo8snszsL0sVn4l6MeeaXvH+M9Q2pM6Zk9S+c1rc
C3HMwLCd60s+J7WWV+Le0Yd9Ha6nfElyeKpmGSyQzN8sOz9sFM1eNedeK6uO
HbgX7u3LVft1asboSCF0DFtY0dvYfCDqbejko5H/kL+QB4Az4B41dGqU1Nfb
S7bP/uLzrx3WmydSnxl/g90NCRvDvn6U+nvGyTXX+JZGHX1T0XnXrRXrAPIh
R+Mc8Eku/G7Z/Cwvmcd61Dwn1iy3I6OW/MPAihsjZyZWmVy0HxtWdPxJTk0M
CiavCBs5LLWOHigZq8jTqIeN1JrHxHP/in0ysSN5BzUa/NJLWvdyaj0EU6dE
PkEOAsaBdf8uex9kzV7oF/gOts8om2dkib3tizrgSdr3GI2fXHa+BW/YDnWU
iyMuJw7FltB51uKj4Q2c6opa3+Opx1+IHGJezKduxHcU7J8c5djIU7jbBeEL
ntO9nqPx56kjlc0PfBEvULcj18De8ZfgD1jOtwrw/Pay96KGylxyY+aDwa9H
fQwsxHeAhwsz563Un4ZFXYX6yt6QCecCA/dETYxvPOQ/Kyq2CcbHRg32+bAX
4vC94VvhmZojvID35K7E343Sn3skzwa13y/aD/btNIadG7hKXeek8DXjS/Yx
fHNDNsSRxJCPxTca+hOLlu1x8S3ozdh3ZnzvgR/ujZiVO0EWc+IuPhbn5e7I
Dxm/pWzb2h+6AZ0j47zM3R/yIT/C16DrYP/y0O0fxP7EhHtCPmNDns9F/6bQ
y/5R6xgV5328ZlucnflbFt9a8BXvVG1H9xddS0OG5HTU9MHS/dK37tQ1gz8V
bUs7Q+Z8i2W/GR2u/fKNCj6PjlrboIrz55vCRtBHamHY7q3xHe6ismumxP8H
RGdjyTb9dvhEdBKc4HsduEdcX88cT3dmzs+IS5FzT8SoxKrUn6inkX++k5rn
g2XbK9hFzMX7jTHn2NS1H769UAN9PPJfckF0nXwG2RM/If/JMW9NzfZEDAH+
g6/DI5bjfPALji6JFkzj7uZGnZDYck3El/sibwEPh5Zcz2rLjJ/ES5sj1zwk
4hzOgNzA8z5xXvSc2I4aKPHu8sgROdueDsfMxM7limteacXyRl7cOzkuPoQ4
FXq7wnbQo5GhS/ByefCDfT0btb6jy47tjwqcXP6+PyoZ9zbULZd6xMN865sf
9eFdQYe9FhZ9poLu5K7U/v9ZjbV3+u7wP/gD8BQsJZfmjB/scB51TPjiGVXb
L3aM3HbGvh+qWVef0fh1qW1uW2ofvjrucXnEXcSH+Cp81qzM+Tc6Byb9Dxi0
Qr0=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGuUjecVx985Z87MmGHOZd5zZlyaiiDWEkSJuldINPSDS0pkSRRB0yDo
0rQSl4RirIjrCEJcBxMJg7hUEZWgrURcIl1oKhIRFdG1kmqbGEZ///WfD886
+3n35dl7P/vZl3P38HH9n40EQXB3VhBk8zszFQR9gJuxmQW8uTgIRhUEwQ9y
g6CsMAhO8m1BThAs49sFcG+wPo6a5k3g0SVBsKd2EBTD/0YiCLaxmgD3hmc3
vBPCILiJrK6s8iIWPGfgHw7/RuAGfDsO7SC+1QfOygTB3lpB0Bn69ew3FJt2
aCwIlqLPWOQ1g3YAuo8BngO+B/gKvtVKB8FlzizPsc5fokvLeBAUYHCX/CCY
juzl0PeB/hD0Z6H/XzIITiB7POsO8g+z6uWhC6sM+f9Bxlzs6YO82ti6DZ5+
6HcIGbeR9Qz8c5F/FX0Ww7sIne9D9+ashcBrWfvhbYmP1wCnoL+J7CfBH2Hf
g32riL8NR/Zyvv025vvZirxX2Z+K+YwlwINZ2fCuYLXDtuPY+0qOfS7f9+fb
OuhTfOsK7nVW1yz7NIL9Mda32D4CfA5wDud/y9nfsAZz/l9Yo6G9FxktwUXg
Pw28hPMrkH2LNQb8k3WIF/zRAn1eD+yT7fCOR+dxwL+BZwr809DpVXR7Cn9t
wl+7k9ZvKOddwL+z2U9hvwF9GgGvhP8rcNdYg5DXmG+bwT3BWo4uN1m7gOtg
ww3gPeDXxyxjFvAvkXk/vjmPzaNCy5CsYeBXIHtGyrG5jW8L0e0taNoA/5h1
B9v+jD1D4J8C/y5oz8JzFnsG8e0dcK1YF+Bfjc254A9wZkXMMdwN2r3I7Ia9
I/l2BXs/SzsWksjbVOiYU+z9HpnngAfFzV8Cf0/kPYS8+2OOCcXGLd0/vM2J
37HcV7O44VLe3BD8v5d9DN2zWS9gy0MZx6p06AG8izObw/8AOtzQ3SbtC/lU
vo1x5mT2uznvALLaQt8B3brz7TnggpRjW2+gNnAlPC+A+4niM2ke8V7i/P5p
fxNOOk1Gn4Z8K8q2DxtmnAOUC6YQD0fkn4R5D7K/xb4K/jPIbwR9Pc5PQX8E
Xaeiw3ZwjZFRF3mPI6MJcEWxY0s5RbnlHXh2wVuJj6rBN4G/V8wx+lNwP1eO
yPMdtgS3mtUu1z7aDf4U+pSC+w6ee7D3nrRzUQU2NgJ+BZ9fr2ObZNsl6OdB
H+HMZ9i3SPrtKMcsQ5/bfNsUsU7VwGvx19Wa/LCAs6exGgDXQd8qzstivw95
85GxCll10767pthXAlw/7diWzg0US0X2RV/OexF4Ij7vHvUdloHfmHFu+wU6
vMzZK6BpA/1K9q8Bn8PmNLbchKYJ588u8dv+ET4aATyHNYr9KGS2wNZz2LQI
2gbwbGY/i3Uxap/IN5+GftvK5w31XsDXz3FMt1E8o8+WfN/hu+DHcX576Duw
tsO7iP1l7moC9JOLnJOl/2h0/hv759Hx4Rzn/FJ0OVjkt/kgMocAb0q4Fg1l
bU+5Zqh2fII+08FNRoeJMee075POkcqVa9j3wz+N2X8fcw4uYD8bnT7AVweR
X8B55SnnTuVM5c47fHsPXY6xrwa+g32D0WcH9AH7qdxBIWd3RN404FLknY1Z
5vtxv3m9fcXoI8h7AhuKIvbJttAxr9gfgIwdwHclDCuHngd/jfPWctZy1SDg
o8V+W8rx2ezHJp2LlIOr4J0jeTHfie5mV7F9rzucyX5Gwr56HPwOcAPRpzjq
GjqgyD6Wr5Xjj2HP15yxLt8xpFiaG3eszWN1Q7997HeCf54zp3P2BNbTwCuR
/wm2H+OMaehbqRyMvCDuu1dNVm3+d9y5/kPVCOSVpx2Lypkb0q6xektfs9ZB
2wCa34FLc34n9pvZt85zTVNta8mZMc4ug6Zc7ys07Xr46wPXCw0XwzMvtE/l
W9l4HfjtuO9WPY16m+lp5yr5SL46jw8mZTkGmkJ/gG+P5frO73Dez+BvgryB
yP9IZycMH0anBLR/4ltP1Sbo10DfNmVdxdMGeI56HuAQmpcVm3HDAzljH/zt
0ef9POekD6GP8q1T1DIPQR/hvK7AXVi79d5Eg7y5nLEYeCHf6ua5pqq2vpY0
7gbrLvAdUn4risn26g2hPxMxz6LQNVW1VXf6V+52Pd/GZFm/cuBK8BMV76yX
4N+P/rWgzxMP+FK+3UbfvvDMBj7Mt141/ugJ7Xvsu0T97Qjws/i7M7gH2G9l
f5E1LM/vQ72QcpBy0XC+XQrdY2ovms/Yf8Qd/SvXOed0xjbKVvVc32H7iNCx
JR81RV5VxrlFOX2L9OH8nrl+U6V6W6Fr8RbwU4D3F9n25ny7Dv3noXVR/Kr2
K8YUa8rJlYW+c9mqGFWsXsFfx/Ncs1S76pNjP8e309F3UqF9IvoI9M2hz4em
LM81RLVEPbF6Y30rSDvHK9erhw6Q/fdC9zq6g1bYloz7rY6Ef4PugvXDqGty
teSH7j31pqqgTYeuTcpZHeN+w3rLqxDfDvhLeDbm+M5195ohNEvIpk7g3yp2
rdVM8SL4BPIaA6eUA+OeQTSLqEZOxZ4lKeemtqph7B/NuHaqR1KvVI2M5dzP
x8p58C9ijYw4B/dCdrzIb20A54fQrtcMEHWNU63Lzzg29a0W8B9Cv5USZOwB
7s0qi1jmYmS/G7pW643VSrgnU2+mmLoX/JZC9/K9+NYbXIe4fSUbw9A1WLX4
G+h/xf4UZ87L9xs/AfxSxrOLzlxa5JlBs4N61KPAb6dci5VzdqTcA6gXUA/9
mPIp387VzDeTks65yr2aGT5NWCfppp55Luc/BU+V+m9kFEH/D+5nKfAHqtFp
+1S+VY6dBr4361q27/iK+vGU3+589ieAH4E/WuCZQbPD1ELHhnjEq5lDs4di
OqbeF32i6NNJ8Qh8OWFZmuk02y1IG9cPGfchqzU0ubU9Y41G/5Ohc5Pu+BTw
06F9+xz65sfdo6lX+0Jnqnfj27CIe4Lu0FYkPKtpptVsq5lEs4l65JnAJdCs
zfUdqlZLpmSrZ1DvcFs9dJ5tlu0nM+5ddKe6W+UA5QLdSVbKM5JmJdXwr8DP
wKa+Mftcvtcd6C5UM38tf9fUD+XAjUm/eb39BeAfBrc6aVg5Xrk+URPv6qGT
mtWS9l078JXYsjXu3lY92e2M37zevnr8lN5z3G9RNm0J3VOrt1YPuDbpmUmz
k3JwZ/bVccvWTKXZ6s3QvaRmVs2uytHK1fJhMfDp0G9RNsm2f6b8X4R8cBV4
leI12zOsZtn50O+MuOao9ixL1cyG0PwR33VMutdSj61eWzOFZgvF9MWEZ3bN
7urZvmB/qtixrZpzEnhn3LlbPbR6afV06u0OEg/jiYdxJYZVY1VrH007lvQf
ylHNToXOzdKxNbr0CN0LKcbmSzY+2BPxfwyLQ//HoP8aVENUS+qVePaSzdGk
a6Jqo3oo9VItCv3fh2Jesf/fpHsj/eeg/x66xp2r9Ib0lvbV1B/1IOpF5iU9
u0qH+arvhZ5F1VOrt/4/p55trA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.34065964598683984`, 0.1395483415157614, 0.595818659640546], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3fYVcW1xs/XC3yn7rPPZ0ODYsRQYjRYiDFRFGv0JhosxKu5GhONYgOV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXW8ldUShr8TsE/gzm+HqCgSgnIOJirWpUQUu1G56MUCEUVaxYCrSIqA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         "],
         VertexColors->None], 
        PolygonBox[{{5137, 1950, 3896, 5131, 5132}, {4954, 4953, 3897, 1951, 
         5139}, {5132, 5131, 3895, 1949, 5134}, {5142, 1952, 3898, 4953, 
         4954}},
         VertexColors->None]}]}, 
     {RGBColor[0.3609765809009051, 0.17487400443825052`, 0.6243765694630286], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHfYVdWVxu/X2+3lnA8jKoq9YY8iligRG4LBAkkmSjKxxKgRjdhiASc2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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXm8z3X2xz/3Xvfe792+97t/riwRLZJQzTSTSoWYsiSypSzTmGkqyhLC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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4151550740050792, 0.2690757722315549, 0.7005309956563153], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3m0VcWVxu99j/cedzz3vfvuOVcFBUxMHNqA4Dwki9EOigYnFAgqTkQE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHecVNUVx9/sbGF2l3kzOzPvDQKh2ShGENDYK5bPSlvRACtBigpBASso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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.537056683489471, 0.4810297497664897, 0.8718784545912104], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQVNUVxh8zwzI9Pf1e90x3D4tGNkE0pVHQIUpKTaFEg6JorECJDAwu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlQlWUUxx9xAS9033sv3PdFQFOWVLTJFBBUynQsKxc0rRkdSVHUQMAl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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6277938276889858, 0.63035218293846, 0.9109571277754757], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlm9olmUUxm9n7+um8D7vu+d995RaFllBSpg5/69apTNzkNJMZo2yrczK
BFHTMMuYM5CshBJCgv580ujPFwshUkkyKNCw1oc+aW5zWG6WU9Pqd3ndEOzh
Ps95z33Odc65znl2w7LnF62sCiF8xzOc54HaEPbkQjhQCmGBHuRmzlaeFuSl
nI8VQngL4x8rIXTnQ7hlVAizcXKeZ9OIEM4NQ05D2Io8xPl0FsJ4bJZzHkLX
MTKEJdhuQU5rQvgbeXfONo8Od8xnOT8Ezwd1tp9aDmEzcddi/wNxX+NuGflS
lX0olvzs4+40/Kzn/pbqEL7JGeuuOp/C3kQO89CPA1sj+VbIYXwxhBlXO+4U
5AH0n6A/wzmJ2O+gb0O/jfut3H0CH7Myx+9NHFsYLgwzrq6cf3suc31u5e5W
dJfR8Rrq8fkePtvRv8q9Wu5clC/eX7gqhJlg+Yo838dmAzin8v4I8o38fqns
3C5zNvBbPzjPI3+J/RL8fMG5Dd1HxFuJr+ncWYX96bJ72IWf/WDYh10r9suU
U8H6WcQ5RG6rkWdz72WwlbC5oH5xt1jjPvfEnJdT12PEaq5xv8rITTlj/S3x
vSfrXG9hEp6PI28mgv0kmDrA1sPZU3K/TnLuwqYRn/cVnF9LjTHLt/TiyecV
9/kh7OvBvRB5NJg7kBchj0HuS83JXs4KhU/ytrubvpyDV3dlxiQO7MT/EXw2
g3k12O8p2v/k1LzQXChH1bW12n56S8bVDk9+KVvfXfb8yH4pfg6W7Ht+wXmo
B7rzE7FaiPUSNp/lzQ9xo533RvSvU7d3eRYir0XXkJlX45CPEO9N7hzlXJd6
njoT80UzpvdBcKwDT2PRPboiV3kOVGflebBizs7E94yy707n/LriOZ6SuTYr
qp3DfvRD6Kdm5q04q3dxRZypFx9zximuz44z0ge2A9w9j+10dHPjDGoWu6jL
Xnwv5uwkzkDe2AbAsReb5dzdgV0n8jXIg7Wu11nOoSrr+bsyh5dizI2Ja7sm
9Z4RVxX716L7PQ2O3Jy6LpPU38S74ywx7y2Yv5q57dWuier6fcV7rg3bjRGn
cIv7CyI3vi35nF/reTmVM8auau8N9VKcWjTSvdAeE2b14I0667dzngVTJ78N
puZFf6yn6i29ctFsar7UJ+3PsXnzdH3kg3ghHquWG6jJTaM8P5od7UjFEpad
YP4Xm1OJe6L6qNfyvXmE+zsmcRzxYmxinbhQTz1vx9da/L+YuSZziNtQ8Hxo
LscWPY+ay8G851n8r88cQ3tibsExNSvqmXq3Cf2axDXTHGj/ag//Q4/uLzhX
7WxxszvO78nENXqqzhwXn5T/4sixE/hvozcTsJ8Xd+2E2Mejcfa1A65NXGNx
Vvtvc6z14sx75OHM/RQe4duO/1ew+7niXaD8jhFrGfJt+H+81jzVN0Vc1Xx8
mndPTyTeqZMzc1D22sXTMueinPTdu7KTeW9KXcd5qbGLi8J/XWIeaabFb/Vx
TsSlb41qqvmUn4ai9+7uyAftuPVxp55Kza3+1N+lzjjnwiecx9X/svNWf45H
/B3UfKL2MHEP43904hm4I/PePZw3D1ZELj6j/qeegYucMzLPqb4t4vKe+H+A
voXqU0vB89QZZ0oxFKtEbasLlhW/L+e4svk9de9Op+a3eH5n7J2+ferfn3FH
/JWay9oJms1VkVequTirGVbOf6TefWdS813fXNX/+sSz+nbJ31H1sLnob6a+
QarRg4X/94T2t/abcvsPQ6hdCw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsVVUUhreXTpfqvffcwROwgkaUaI3B2NIilFBjSxma2GoVimCs1FZU
NDFBi6ko2sGEiDO8ECPqi0PUB6OEJx4kMVGjKBUffCO0pQ601bYoDt/vfx9O
svZZa/9rrX8N+8quR9p3JkIIw3wlfNPZED4uC6ES+UAUQo7z2dIQBvkWpkNY
nAuhBfkg+uZUCMvzIXTPD+F4eQgrkPPYT6Af5rsC+xEwhuaFcAOYXehqMiE8
xHkj+o3oJsB7mrszF4UwipzBBlX4EPtJ5GPYvFfqO+vw9xyYmxL2+dalIbRm
jN+BTSe2W9C/j1zF/XVZ56Bc/uXOQeT1/Hs72GYDcgs+p7A9xr8x9PvBbAe7
jkt9Mbj4fAJiPsX+G/QvoG9M2OZF5D+5/zzxnyf+GeTriGcpd0+BWc15Nfe/
QE7zrcRfD+c3iPeZJL6QO9POr7sihDPwdx8+OjkPcd6acQ7KRTayPYL+HeQ2
MBq4X5839/uxLymEsAubNuI7gH4Zum2cVyUc08Pkc0/x/Bj642D1KAfOc8R/
ObrRvGPZin4R8d+P/jz6WfRV6DdHRT7gawj/VxHj3diuJaamyDkq1wL+7sTf
gozP7dhUZcyhuJT/Vu73YrOk0vmp1s34nMR+gBg2Y/8L8Txa4ZgV+71Z99JR
9QTnP7AfLHf8k8jdxDuXcD9dhn5hxlwpBsWyDJuTZe6B21KusWotvO/x35E2
v/uw+RJfveD9lXB9F6Fbn3Lvq74fwPcSMAvIO+HkJ+SmlGVhqFa9aef7Ejbf
gteQce76N0luNbFjFce1yKuIb6LMPbkWeT54UdIzcla9yjeAnOVfJbqL+XJJ
c/B7zhyIC9lMI5/I2rdqpto1Ffnth9MN4pfz3nL7kC9xIC40U50p+5CvZ7H5
Ddsxvj3IGf4l0X0GB5uSxlTtTkfuDf07gu7nnHtHPn5F/pucB/H9Mvg1ec+8
8hfmeM6Ywta+eRWsHwqelQ74GUF+EI6urnR/9iC/pv2CbR6bS1KeQdVqWD2B
fC057qhwjRrhYgH1GCj1TtNua0T/eIV74hrsv9YMJd1vXyGfyzl35aBclhb7
50ZiqOXuGfx/XuqcLpDPbvSH53lH9SHfHnlfyMcU+i2Rd1UHPj4Bf3Ha8Wtn
ancqB+Xy/07JuUaqVTU+t2U9E5oN+RyNzJG4GufLZr0ztDvUQ+qlk5F3m+qp
XXwHX988x6TY7oo9q5qREeLr0k5KegftS5ljca0ZfQD5ptj+NGOnif36nGdB
M1qP79mcuVdPqjeXx+ZOO6YOuT/lXZHnzhribY38FrRi/27BO0R61XhH7H/S
iXNx/0/eu207+/dNZvP1yG+N3qwp8FLgf1RmTtUbT6XdO+q3Q9i3ZMyl5mFM
XBbfE+EdRh+B0VbiN0hvkXaAdoHevGbwvisYq5U7J5BPEU9nheddu0MxCUuY
equm854ncX4L/nbF7h3xvx19XTEfcX4UvN2xsTVPT8buEfWK6tmQ887U/lCP
7kWey1unnT+LvDr2WzdDDGuQx/FxIWE+GjjfHHs+9G9l7JwVr2JQLOoB9YJy
+jHvGVW+4rAfrFvx2Zh0jVTL6mL9NWOatXNZv92asVfgqz72PtIOXRH7TVE/
CeMQue0p1kdvYi2+/gPDfya+
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6755943023634959, 0.7071542451168493, 0.9120468313705803], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlU+IVWUYxr+Kc71jef6fpo2KSC6ihWOaMY1iIqMzppkzGTcdxAnDQLRQ
ahIsjcSICBcquGjTQhcmQUGUunJwQhDTYKZaGRTOaFqpmX8o6PfwHHDx8X73
O8/7vP/fO2Nw6+otD4YQDnEe4lwqQ+jk4ZUkhKVFCAd57EJua4bwayOEI2CW
x5bnshCGeP+F9x50OgrfFyJXt4XwYhTCV+A+AT+KfA3ZnYawA51b2FmcWv8m
9385I7IPZz96l+DZJdvI7yL7MTwJrqa5xsHt460Fx2AewkkwY5m55ecS/Nkd
3/f3Rml/+sAMpOZ7lfsc3it4t+PzNM45dMd5Wx/bnw7u13n/AMwtZCuyXX2b
V9qn98hVd+H3b6oQvuUMg/sN/hzfoAz7uV/IHFNP6viE0e8T4E/DMx++5eCn
8q0X+WXk+1Ywi+D/CPk12NkNx6vfj6HXzrmIjWfgfYO3J8H25K7jWnx7oHIO
L2N/Y2Leq9g6NcmxK5ZpcB6LrD8SOe/KkeLtbDi2qLKdLnQvY+NddMeR81P7
+ETh3G9vOv/9dXy6Xy/9vgDsgtI+D4F/p3AMO5B/coCEh8n9AXydzD3mfhie
1/nwFDytuj9+IL6r4Hej+1dhP+TP78gx+FvgX253P77fdH/Knuw+y/fjmXk3
txu7ifNhcP23NJ27nYlzNBf8H7Ut2bxbmnNl6lypHqrF2tj9/iPc3dy/5306
+FWpv6uG4l4Rmf/zyvddYNfk1j2TuaeVb/XUx3w7z/tg7DoM1/2nGs7k9xD3
CfUrchZ6O8EdBL9Es5Y5Z2fh/iLyDGseFheuSy/4sYZjlk5/bs6+3D0qjLDy
UfWVzz/XuVWOu+r9oHlSf6vP27B7IXfNN5G/v8GwCsIjyk3l/niat82Ja7IB
7Im6FqrJFb6R5jAZ/N3CPTCF+/rEMVwr3cfq56HEcUtXcWq+lQ/l8Urpfl4H
Zm/snlHvXGw4d8LdrOda8z2SmV92NBOaa+0Z7QX9fgv5T+n8vwlmVWyu2XUO
5I/q9HbinrgHdqDNva2ZWZQ7x6rP3Hr2/kM+njoG1VA93qr7XHtK8fQjN2Se
w8HMO1c17IudI+XqGj48n3uGVyAnMvuwrHA9VJcJ+c/Zi8K9wlziPE5NPq3c
A9p/swrn5rnUfanar8y8m7SjPnuU+ck9KwvrHleeFYP+M9Qj2j2qmWqnOdZe
UP8crTzbmvEbhXtCvXGb+53aN/m4pt38sqN5ld3z9VyptpoV2XyhzftKs6V9
qH7Sf4Duo8iXEufyJ/VCZXxvbB3VWnnUbAgjbGdpO6FynLK7J/HOlY2BzPtE
/23y43//Ffoi
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtI1VEQxifNRy303vv/X2xjEZG5aGGGFqZBIVr2MpVCVEQzSBAtemhC
D6MwIqSVu7a1qAhsUxktlOyxqAx6rQwKNXtr9qKg3+dcuIf7zZnvzMyZ+c5/
aXNHVXuSme1izdd/htl4qllNilkvuJp1mf237N2Im2UHZo/BL1i54PKoWWOy
2WqClIE/hmYDnO1gb03EbAa7K91sM/62TLMGOOeS3a4H17N3Df5i4m2NmZ3B
vpdmlsXqJP5Ncl6APwznFrgVfylnT7I3GnWOuItYR8GFgdfaTc4y8q/E3g93
xwLycP4wdhzuEOsYsXZnmdXCPau7g7cTcxu52tkr5Hwz939qXtMg5z9w/jiY
n02BTxBjOM1jKvYfVi94If7fsrn/SIrfuZJ4/0LPPYL/L/gh+W6Au/A/Ag+Q
o4pa33CHfM4Xwxkzv2MJeFvMezV3J/jjUY+lHk2AV4Vuq5588CwxToMJad/B
s6H3Rj1UL5ew9yTVZ6hZfsXugQ/FvgRek2pbJk2QuzrmWDPey/nt3OlUute7
Cn5OxGNpplPkqshI9B57OKrCvJ/3sefFvcfqtTQlba3A3pfuM3nJ+VzsVvAl
+INR14y0o5y/FZ96shP1PMBXR01FSa6/IewW/HmpPoNJ7D2s/mSv4Ty1tWV5
bNW8nFyvQtey8r8GH0no5Tn8PvjFcA7iu86ZEWJtCjy2YpZLa+QrTuTrpJZ1
oc9O+YpCn5lmpzfVQ7wO+EXwa+E3Rf0OussYe5UZrgH1Vm9oo3qT0P8h7G/E
K4k4luYL4E6ygHMafQ9uinm/7hCzGTwReq/Vo3Hwp8C1rJl/Bj+POlc9U+9u
x702aaqRen4GriVp/Be4lL1+85gX416DalGP1CvNXLOXxsrgTgeuLWlyJvAZ
q9easWZdA39nir8BvYUDmf721SP16lnMv03qwSj4StxnrTd7Fbwh4npVjGnd
L/RZqedr5ct07WlGmtX6RH/1BusyXDOKJ01twf8u6vn1TdS3sTvwb00D9d0l
X0XEv0Xi/CBXXuCzUw054Bb8fen+jSjA/x8lPb59
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7233947770380063, 0.7839563072952388, 0.9131365349656849], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtsjGEUvSoz0/GY+Z/VjYVFi2U9KlpKFImmZqQzpspU0XRUojNtF1Sm
myojLJpYicTWil1ThEhEIh6x6arxWNhYkEpFkGDBOTm/xeS7c79z7z33nvv9
605Vesp1ZjaO33L8KqFZLGk2grNSb7YQN9sDwFrfrAxAq2PWBfsm7CHXbGaV
2fEVitnoC78Z53vcXQUmC/xgyuwpcn+G75urWOY4CbsbuSueWRF2IWbWj3MK
+AzsrKs7YsbSZgPw96HOw1A1aT9JmP0NUAtcB1ArC/wcYktpYcjvOuptiPiz
j73AVWG/Rf7viL2A2E74XuP/GPxtsA/hNw3/70A1tq42y9eJFzHtsPcDM8mZ
IOcD+KvA32OfiDkNuxn3txoUNwk+X+Li2YP/g+D5GDEj8D9H/mv1mgt9TXHx
Y83WqG4Hcr4ALoHen0U8tzuKZ0wv8g3D3wfsBOxqWnGsz1yzMem4xdf/ArD5
lPh+cMWP+IuN0oHaUbNhT+c7YJaF4mk4fwXCUbcWX/gM+OQ91XoF/2Jc3HhH
TuRWQ537iF/CXaeveb6Jq59axIe8HiH+BHVDzm2OdnERNeddzfoM8hx1pG05
VA+M7UdsPFQtzoM44n8E0oo2caOedJjA/UdXeZivVC/tqC/3izvEO+pAPRoS
egPcpQzihtKaa86TjtSQtQtJzYezawd+HDm/gsO+aGd6Xb2H/zPmu+EeMhd1
5Ty4j9xR6kXdamvMdq80u4KzCZhm2GdhTzeK31Sj3iH3lVoeS0mDjuhdZnB3
G/XOp9U7Z8D5cs4L4PaTMwKHLkd52DtzHcb/S/D/wX0xKQ6cw6bobbTgbAvU
fzvOmZTuz6Hu3VB174TizdjLOLs9zbgILrt8vY0Dvnaf+8OelwLp8SnQjsxF
b4/vknj2wD0j/qWrGZci7Tgb2jdMvbHH9Y5y5JLSgN8X7t9BcNkZva8dgb4d
xB3x9Ka5q9yZkejbOBrtL2fFb9NsqJy5lObEO/rJkXtAjf8Bb8mzTQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlM1LlGEUxW9TozNY8/lOuW2RUDuTDLRMtALNxvKrJIcpTSOImZQoY1xk
1oAtpFbRH9CqdpKFIUQQ1SZoJVHbQMMyooJqUb/TncUz3Od+nnve88z24WJP
IWRmnZxNnMm4WQ+OexvNVpNml9NmW6vN9mwxu4R9At8UsQVyyzF+Mma3ImYv
yWkKzL5w7uIew7eOXSB+h/y5zWb5WrP2hNlVYstVZjvpV8f9XMTzV8gfYn5z
yH2fuPczry3kNd+5nyf/NvYr5rUEjlFYhWEDs84mHf8s97/Em8gfJ/4obNad
Aj9nCbuE7yCxLPkF7PtgvsY+X6mZiDiGHFjawbgO1hv4+slfYMZA1OwzvlZi
J1PeW5wcIj5awSMMwjKQ9FnaQbtMUjMYcvz7mTWcdH668J3Bnoi7Ld9H7p30
nIo4hjZqO7iXuD9h5lviLfjWiM2SX489XqlXzU/6vyfnuXn8A3Zz4N9KGITl
R+C9hP8wvfMJ5077HUg7J+Imy84PtTv77qhyDpfp95ozH3afYkfIf4edxTeN
nRMHYedM3PWmnAvV9GFXZ5wL4anCHqNmKOqam8NuSLtWhOF4zDkXthkwHgPr
auDa+f/NuF9HY330akSvM9gPMo5dPXZRm4u5dsXnY2KLSdfrafZ/in0RXzjq
PUpx51y54lzcr1Tm1dWwM/c3Sf/+2lm7T9f6bOFvILee80z70TNPPJvwbyFO
fhFrTDv3vcTnxU/MbfVUb705vT312B34DtqlCIa99Dqacq6l1y7scty5lAa/
Uf87cK6kxyvE9gXOt95QmHkdFT6lkRFmX9jmu4kTcbOYcezSo7R6k3hrjX+j
pYzvqF3lKxP7E/hbkQalZWlEWpFGT8X8P0D/BeK4mPE3Jux6oy/I7a7wo5oR
9lkLfFdpZpTcf8VTni8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.770322279302745, 0.849562836706071, 0.9105853137647766], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVD1oU1EUPljz0tfoS95LHmZTQawBwUIFwYJSq4gORltrhJpGtFrj0NhW
FHVSMYNQ0M3JydlJcNFKqQWb0MFB/F06OIjQVu0QdLDf53fB4XLOO/fc737n
O+e+redq/WPrzKyG1YbVnTObSZrdzptNRmZvEVsKzc4HZr88syNZs2V8P0Ly
2YzZINYU/D7ER5E/nTD7iP3XsD3In8N53zdrpMySsJUO+WnsLyJvBraWBj5w
epF/LZLdnFDOAfhT7WaP28SLfn292Ul3b4XccGYX8oqIvUrIP4qiWp44BIgN
Iq8f9hTsA9RSht8VmxXA+yb5Z4Tdm9Jd5Eiu5NyDvQnEvuXEK+UL8wRwFoHf
DYwXse4rwm9sMJvHakfeGXDrA5dR1DgEv4Ccw8AbSMjnHnOJS8yJWP4O8JzD
egq/jLMe4g/BLwk7i/wOX/pQv5IvLYjDuxn/p7PjsA+8n2C/yjrS6s0fV8u8
y2ce/cD1g7iXI93D+9hD9v9NQr2nrp7TYcjFOCvUkD1jjzzMUJN9z+s8tWS8
ktfZMdRyIy3M76j1q5sbctzmqV/szUHw3o7vEvgcgt8J/3QkbN9hsn6e5byR
b8PtNYH5DPEF2P1Z8axk1HvOQDVUz8mb8/UT303E6+BQCKURezIeiSf5EnvW
6caa9mzU2QHg7ga3KnJHQulyAba+Sft8W8tY47hrCXZnLM34zp7H6mMZM7Xq
6Sz3WCtnhXPSGWr2riJ3ONSMX4xUx29PPV5w9ZYRfxepF9dhJ2O9K74z9q7l
3uaxrOxIoLp5N+/94XQ4ntWdLfeO7uZV7528ZoOY1IFz+snTOxkO/mNfCoTH
Wu+7OPdvpTVzV2LNKeeVOPVA9ZZCzT1xV6BVLdbMcHbeR+r5itObb55asBfU
mXt8K9SFmlCPLe6tfQmV/xn2b046s1f8Z/Hf9QH2Zax/wD30bTWnOeT/gzM4
7e4qRsLcCw5rSRipdA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1IVGEUhg9WM/7QzNzrTLmzIDRXLRSihMIsIosmRk3JzMhyxkDNiohq
U+EEQVC7FtGqdSuhTRQDCoFtWkRhBRm1qCCtZhG1qOftfIsL53zv+X/PuRtP
TBUma8xsP99qvoOxWXPCbHaN2UJktj1jtiHoz9Enc2aJOrNO3o6AjaXNumvc
Jo/vFfQk+Ei92b11ZoP49OL7EXxro9l5/BvAm3lrAytjv4DcDX4R/20Zz/+Q
t3nwMd56iP8EvYjcTowl8Eur8EdejBxr4W03vocaPd4LeimliIt+C9sBcj4i
9ynsh8Cr2PeAfUV/ht6OXsB/ha/MIHahvyTfl4D/RB8l3rUm+ljrParX4ZTH
rmDzHtur4JWk21xH3tfovnepYSfyNDXUYb/QwBybPKdyP8X/Hf6l2HXlVO5v
kfci/2XkC+Bd4PXEaEHPE/NXwmfaGjkn4mYO/0/omyOftXzO5TyHcnWg92J7
OvbaNaM+9AP0sxjmP4ftSfR58xyPc86huJTPEvjMerP7+HbRzw3kw7wVwD5g
04FtIeWy3maQ+1Lur50oi5+Mcym8mjUbx3847EMRbJD6WhO+Y9o1vQkTx98j
3xnp8ilF/km+U8t8c16D8mtHtCvqSb1px7Trqlm1i7My8njss9HOHcN2Jev2
Z6mxk9wDse+a8Im0cyAuxKm4PZ5xrsTfNLbJJudaO/UKPQ++JfD9NvIYiqW3
UfCRyLnQzG8ynzPErCV2CvsJ5L34t4X56bZ0Y7o12VxO+43Ohv50S5+zXvs0
81jO+o5Wwj2Ki2K4X8UcIv/rcE//OQP/k/VdUk39Gb+Zapj/D2wHwn2Loz3g
yZzP/gH2O8QnMX4Hfm6nfAfE9Sbe+tVvmJdu8i/2b8J+6gZ0C8Ox96Maj8Y+
A81C/6Ap5H8whp0m
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8132503498296935, 0.8638782043678622, 0.8913535766379483], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVDtoU2EY/TQ2ptSb3PuH0EyCCLUWXCKlOKgIgoOikvqItmopmhhbq9Uq
KCgoShLTwaV1ERUEF1erCA6CddHBxddS0FmorYvUyXM43/Bzf87/Pc75HnfD
6IXyxGozG8NJ4VQSsxu47InN7nSbzabNvgazbKfZOpz1HfpGOA9h9wR27zNm
Wwtmb3CGgJ/Omm1KZHsgb9bOyIf2lwvy7cX7Mnyba8yOAPuCHDPItQTsX5fZ
DpwI/r3AXnaI00/nNoCYmxNxmoJvMzKbzij+37Q4MHcj0hvxt3jfibcM8r3D
fR7nB/T+cQ4DiLeAMw3bsmPU3sD3WpDf67y00v8p7PoLilPCdw5vq2DzCt97
0F9B/lOIN5cRJ/Ipuf1jxG/B5iiwM4jdA7sY96tB3weetwybF+D4He8fgG8H
PohmNVCbZpfy0XbG7amX/rw/D9I76lqIfUaslbRqQT3kxjjkNxsrHnXc6lb9
q0W9Md8SvlNB+avgs6WgGI/gt+T8ruD9ZCJdddzTRfGZhO0l972eU6/a3q8J
4HuBX8wJIyfWajJI70gsjsTJj7EYkzUbjNWvBa9z223Yc9aC88NZ4cxUnFcJ
MdveY/r+At6KpJe8Ip8b1qsWZF8NmoXIa1uL1f96olwtn7/7Wc1UPat5b7uW
/fB/Bnw+0QyxbqwfdTW8/t+CerkWNRvGvQ/3E/hO5FQf1mk5UV7mZyzG3Idc
h4Pm5K7P1GJa2nbldR8Gfixol44HaW15fXbn1dse8PntfVxM1A/mHQ/af+rP
FOXXdN/+tOacdpwVxr3dLd2pTvXibFYzdxB5hoJ2uYbY4wXteV9R+88Z5S6O
FeS7MdGccWY4Oyu+u9Tf5/+EmylppnbuyqFYnM75HjV89z96rdiHbXn5fgJ2
Poj/SKK+co+4I/8BcBijEA==
         "],
         VertexColors->None], 
        PolygonBox[{{4723, 1599, 2240, 5420}, {6186, 3066, 1293, 6019}, {4587,
          908, 595, 3961}, {4336, 1685, 1687, 4823}, {4568, 180, 907, 4569}, {
         5425, 2243, 2245, 4256}, {6152, 1686, 1160, 4337}, {4726, 1296, 924, 
         4195}, {4574, 893, 587, 3950}, {4407, 1160, 212, 3685}, {4590, 1482, 
         1599, 4723}, {4701, 1578, 894, 4557}, {5414, 1776, 2951, 6100}, {
         4447, 1368, 1589, 4180}, {4725, 1482, 595, 4724}, {4713, 1367, 908, 
         4179}, {3943, 1462, 1578, 4700}, {4559, 1462, 1576, 4697}, {4167, 
         893, 1462, 4699}, {6151, 1687, 1296, 6150}, {4698, 1576, 893, 
         4574}, {4944, 1785, 931, 4593}, {3676, 1774, 1367, 3721}, {3961, 595,
          1597, 4721}, {4200, 931, 1032, 4729}, {5428, 224, 2244, 5429}, {
         4392, 2317, 2316, 5490}, {6019, 1293, 1686, 6020}, {3962, 595, 908, 
         4589}, {6018, 2878, 3066, 5484}, {4195, 924, 2317, 5491}, {4710, 
         1586, 1367, 4446}, {4569, 907, 1586, 4711}, {4709, 1367, 907, 
         4177}, {5427, 2245, 931, 4200}, {5490, 2316, 2318, 4393}, {4448, 
         1368, 1776, 4932}, {3684, 2395, 1783, 4942}, {6100, 2951, 1025, 
         4246}, {4716, 587, 1368, 4717}, {4387, 2307, 2187, 5378}, {5378, 
         2187, 2188, 5379}, {5047, 1025, 2307, 5483}, {5424, 2243, 224, 
         3728}, {4254, 1032, 1599, 4779}, {5379, 2188, 2878, 6017}, {4942, 
         1783, 1776, 3678}, {4714, 1589, 587, 3951}, {4192, 1597, 1482, 
         4591}, {4194, 1599, 1482, 4592}, {4727, 212, 1685, 4821}, {3951, 587,
          893, 4577}, {4920, 894, 1462, 4921}, {4255, 2244, 2243, 5425}, {
         5420, 2240, 1785, 3688}, {5492, 2318, 1310, 4391}, {3678, 1776, 1368,
          3722}, {4589, 908, 1774, 4929}, {4557, 894, 166, 4555}, {4457, 931, 
         2243, 5424}, {4943, 1310, 2395, 5564}},
         VertexColors->None]}]}, 
     {RGBColor[0.856178420356642, 0.8781935720296534, 0.87212183951112], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VDtMFFEUvbI4DLKss28chgpjjMZYqMQP2AgSWiWIFhpMDAnRLCs0Wmin
2FBgYaIWxl+lRLQCdnYrXRPFSCJGEzsLhQQLEy1MaEw8J+dZvNw7751377nn
3jfbRiZOjDeYWQkrh9WZmLU0mj2MzIaazE5iXdhg9q1oVt9oNubMLmJ1BWZl
2L3A10OzPbDjm81eAvMV2BrOjgMzBVtpNVvBamw224fYNeDvI9lowewQ8F3A
9wfKx1xroXDElNrNPuG7L1HsbuDmTdhX2N8E3OHYbBX73bBLLbrPu+T+pVkx
b3nsvZzqIP+b8KeBX8TZW7/Ig/g/sO+Ae41cV5zfhybfvQ7U42dRmKuouxQp
Rwie66FyMx9jlwNpWoWfQYcM9kle/lnkel+QzcB/DmsAdxdgxxBrEH4lFp7+
X8T5EUq3Cvg/zUtbxqRfbRU2lwjbkChP1WPIse614L2K3/9VlDYjqGMafIYR
/3xR3E8hbx74qYL0GIbtDYThHfIlN9YwiPudOBt1qod7SwXlYf/ZF+YlV36T
RylQnGdO/oNIPWSdrHFrm/rYAfsokpac04NYb4A5AHsH+wvwP6fiMxeqv+wb
+8o7nCHO0moqy332elei3txFjEtOtV2G3ZEozm3sz2N9hN/7X89QtXEmmGN/
opqoPXVnfM4Wc9xAvh74k7CPI51xrqktdSW3lVRcZp3mmjpQG2rEu9Ttd6T5
DnH3CPItA9eT6D1RX2KOxeoLe8iekA958pw49vporLnl/FZ9LzI/F+t+Nk47
vbMPwFxLVRNn6rkT7xdOb3TN94hvnd/0t7RJH+paTlTD9VSzyDjbEXMmr7z8
Zt/YM/aLNdX8+++PtXfO88z8bPPejJ8f/mv4XzjjpPWi7zV7tezjTHr9d7fr
XQ75t8lZYe6d4PUPFy+0qA==
         "],
         VertexColors->None], 
        PolygonBox[{{5422, 2242, 2194, 4202}, {4715, 1474, 910, 4182}, {5426, 
         1036, 2246, 5429}, {4247, 2233, 2232, 5415}, {4276, 1072, 1614, 
         4794}, {4182, 910, 2228, 5413}, {4255, 1035, 1036, 5426}, {4407, 
         1334, 2281, 4338}, {4245, 2228, 1871, 5044}, {4248, 2234, 2256, 
         5438}, {4368, 2296, 2242, 5423}, {4338, 2281, 2280, 5462}, {5421, 
         2241, 1875, 5049}, {3788, 349, 2233, 5652}, {6018, 2308, 3241, 
         6246}, {6186, 2879, 2308, 5484}, {5415, 2232, 2234, 4248}, {5440, 
         2257, 1072, 4276}, {4254, 1642, 2241, 5421}, {6117, 2259, 360, 
         6116}, {4588, 1481, 1781, 4939}, {4194, 923, 1642, 4779}, {4725, 
         1600, 923, 4592}, {5462, 2280, 3020, 4337}, {4940, 923, 1372, 
         4941}, {4722, 1598, 1372, 4454}, {5414, 2230, 910, 4932}, {6246, 
         3241, 1277, 6017}, {4822, 925, 2879, 6020}, {6101, 2957, 2259, 
         4257}, {3676, 195, 1481, 4929}, {5427, 1604, 1035, 4256}, {5046, 
         1871, 349, 3787}, {6152, 3020, 925, 4822}, {5384, 2194, 923, 4940}, {
         4698, 1472, 181, 4697}, {5662, 2519, 1876, 5050}, {3962, 1481, 1598, 
         4722}, {3952, 1474, 1593, 4718}, {3793, 1877, 1644, 4781}, {4780, 
         360, 2519, 5663}, {5047, 1873, 1871, 5045}, {5439, 2256, 2257, 
         4277}, {4559, 181, 1765, 4921}, {4387, 1277, 1873, 5483}, {4782, 
         1644, 2248, 4258}, {5045, 1871, 2230, 4246}, {5049, 1875, 1604, 
         4729}, {4448, 910, 1591, 4717}, {4183, 1592, 1472, 4575}, {5050, 
         1876, 2296, 4368}, {4575, 1472, 1593, 4184}, {4455, 1372, 1598, 
         4193}, {4709, 1585, 195, 3721}, {4718, 1593, 1472, 3950}, {4193, 
         1598, 1481, 4588}, {4184, 1593, 1474, 4579}, {4454, 1372, 1600, 
         4724}, {4716, 1591, 1474, 3952}, {4258, 2248, 2957, 6101}},
         VertexColors->None]}]}, 
     {RGBColor[0.8991064908835904, 0.8925089396914445, 0.8528901023842917], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVE1IlFEUvU0yzjA/fPON34yrRESCgsRNIEK1EtSCcFGtAlukM0Jl0KJc
tGnjVLjSQg0rECSq1WQ0mgm1y4UKrStSJiMrKNy06RzOXbR4vPe97757zzn3
vNd64fLApZiZjWPsx3gbmt2Km/UXzO4H2GswOxiZHcXeUsLsHWJup8xeYh3D
v1XE9GH+kzPrxNzRoDPltNky5nmMhzhbiuubg2e5P4e96xivsJ7MKE8vxjjy
xzEbxizWI4jpwvpQpP3ZQGdY6+4+s2HUGkrru5Y3W8B8oKDvTo9hzYFG1d1N
KWYehD8C9wTms8i5nBBH1q2kxJMcx1C/G3MSI8jpLOus4EwP1tcixdz0OOa4
k5JWK9BzDvW/ZXWOtZOuKXW6hxwfimYZrB9j3REpjnUeBOJL3vWUdIm5PhVf
n27UNzEzdtnxky/xkzMH4xnbhLw1/G9tlq4LzmsU+l1JS2fiZ7+Zp897Qw6M
mcoojnrPe6+Zizkj5G7Bege1sjmdm/Kz7P9Xx0wuO95jYq/7uq/gHsDcnpO2
1Jhc6JuYa839jbxw0C/Ujj7qcU9sQ+sZ1HwdKoY4GEcd1pLCPe39PhwpjvFb
WWGsO072ssv1ybg3S4h7EchXx3H2UaB/7OFfYKgn5Cv6vy2jvFfT0o75LkaK
2Q3kW8ZQy17nzvtU8V6zX8fcJ7yLvJfrjuOL+/Yc9psK4rWWVe6ae7scaD4S
yVvE+RxcS2nVpl7VvPo86feYNZi/5l7l+b24uHH9KdR9/ox5q6j7uV2U1yru
N3IlZ/b9B/Z+uuepyYi/C/TFpHuJ61GP73YvUveqe5K4mYd4ao5xqFFanE8K
2yZonMwLayKSruX/3gXO1JGch32PMVzP+BtS8nU/8kyD63dofMpzMvdqqDv+
BvOvlDART7u/j2cCYdlzPKxZ9nvSUtB9expK33X30ojHsG4N/24gpoo8g4Ew
DAHDYqD3ZSkUJu4P+htI35PL+6z8spiXN5mH796u46T+1LLq2tI3E/7+sR+8
n/Q8a/PsCXB6Emp/Bnu/c+oP37NiTvzbmpWLvJif/KnDCGKeheK3kVX/xzxm
M+9vPv7/A7TW2Ng=
         "],
         VertexColors->None], 
        PolygonBox[{{4333, 2279, 1787, 4945}, {4793, 1657, 1695, 4831}, {4745,
          397, 1658, 4794}, {4780, 1643, 2972, 6116}, {3725, 210, 1782, 
         4941}, {3788, 2508, 1874, 5048}, {5416, 1189, 2508, 5652}, {4799, 
         1663, 1659, 4278}, {5442, 1081, 3252, 6250}, {3832, 1895, 1668, 
         4803}, {5048, 1874, 1872, 3787}, {4377, 1083, 1663, 4800}, {4249, 
         2956, 2235, 5417}, {6179, 3056, 1210, 4372}, {4251, 1641, 1696, 
         4832}, {4715, 1590, 196, 4578}, {3818, 415, 3186, 6232}, {4366, 3049,
          3047, 6174}, {4252, 1030, 3049, 6175}, {4365, 3048, 1641, 4778}, {
         6117, 2972, 1081, 5442}, {4374, 3055, 3054, 6178}, {5384, 1782, 933, 
         4202}, {5662, 1192, 1643, 5663}, {6174, 3047, 3048, 4365}, {5422, 
         933, 1192, 5423}, {6250, 3252, 1037, 4257}, {4245, 1024, 1590, 
         5413}, {4795, 1659, 3055, 4374}, {5419, 2236, 1030, 4253}, {4455, 
         922, 210, 3725}, {4578, 196, 911, 4579}, {4945, 1787, 2398, 5567}, {
         3812, 411, 3177, 6228}, {6229, 3179, 411, 3813}, {4596, 1098, 415, 
         4595}, {6178, 3054, 3056, 4375}, {4376, 1212, 3179, 6229}, {5073, 
         1094, 1657, 5074}, {4833, 1696, 1212, 4376}, {6228, 3177, 1094, 
         4389}, {5046, 1872, 1024, 5044}, {5417, 2235, 2236, 4250}, {4247, 
         1027, 1189, 5416}, {5707, 1668, 1098, 5706}, {5439, 1073, 1027, 
         5438}, {6232, 3186, 1083, 4377}, {5440, 1658, 1073, 4277}, {4782, 
         1037, 361, 4781}, {4373, 1210, 2279, 5478}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFU7tuE1EUPA5eewPy4t34sTSAQUiJ6NJEyidABQIJpaCgCB18ATT8AR2v
Ego+IAJZtpGQ8CNOIuADIBI0CAoEBQ2Emcwgiqt7fTz3nJm5s70bty/fWoiI
m1hHsKbViDdYLyoRQ+zfsdZdqycR91HfwXkPq18RnphVrF3X14xNE9W5T42Z
YU3c81qpGV+yiJV2RBXnB01hZ8Z0E/X9BJKNPOIZzidL1bbN4V4t4nQiTDvR
eQv1FvZF10dpxCDVjKk5UVPfXFfNm9oSrE6u//pFxAHufT0W8Rt71/Uz4DA3
nhz2rJ9nzu957t2aNFJL9Sh0NuAz9mEqLdcrms+e9PYq+g5wLjHneSEMdXNe
37zY5yn4bCxIE3uxz8Om9NFL/j9PhPmR6/wT+6lS+MdNafqTStcY95YbwvM9
h36vOzV5uOa33bFPxK4Y/6oQ/oTfJ7GugbH8zfn0Yt3e1+3/8cWIzbo8oy/s
ux+6y9m8v9UUlxHmdOwt33ninDCrY+eKZ3rH+/vAX1pCH5y/oceTpnJwHv58
zoSh35tt+dDOlS1qyHL5wjrvM2PkSp7UOXR+6cGy35RZJT/m8mMh3Y8w80Oh
PL7E/m5Jet9iv9ABBvcudpTVXfvFGcTwDn2jZ/T5XK63uOIsMJfMzKgtjtTK
bBzmy9/p/F+e7dn7UL+Je3J+1fht44jhnJbffeZvht6yTi+YbfJtOefkdPit
ZXqfjuuJOTAPrVycz5bK2LT6n8vYfA6cR+p6XYjXr0z9uu7Z8zdOPfSed5kZ
vgW1bJhb12/xF04Ln0Y=
         "],
         VertexColors->None], 
        PolygonBox[{{3818, 1214, 1662, 4798}, {5419, 2239, 1028, 4250}, {4252,
          2238, 2237, 5418}, {4286, 1667, 1289, 4389}, {4596, 1484, 2981, 
         4288}, {4799, 1074, 1214, 4800}, {4798, 1662, 1484, 4595}, {5705, 
         2564, 2565, 5706}, {4797, 1661, 1213, 3813}, {4373, 2302, 3052, 
         6177}, {4333, 1149, 2302, 5478}, {4793, 438, 1894, 5074}, {4251, 
         1029, 1190, 4778}, {5073, 1894, 2319, 5493}, {4833, 1213, 1029, 
         4832}, {5418, 2237, 2239, 4253}, {4288, 2981, 2564, 5705}, {5707, 
         2565, 446, 4803}, {4795, 1211, 1074, 4278}, {5493, 2319, 1667, 
         4286}, {4366, 1190, 2238, 6175}, {6177, 3052, 2303, 4372}, {6179, 
         2303, 1211, 4375}, {3812, 1289, 1661, 4797}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3832, 4803, 5707, 5706, 5705, 4288, 4596, 4595, 4798, 3818, 
         6232, 4377, 4800, 4799, 4278, 4795, 4374, 6178, 4375, 6179, 4372, 
         6177, 4373, 5478, 4333, 4945, 5567}],
        "2.4`"],
       Annotation[#, 2.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4249, 5417, 4250, 5419, 4253, 5418, 4252, 6175, 4366, 6174, 
         4365, 4778, 4251, 4832, 4833, 4376, 6229, 3813, 4797, 3812, 6228, 
         4389, 4286, 5493, 5073, 5074, 4793, 4831}],
        "2.4`"],
       Annotation[#, 2.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3793, 4781, 4782, 4258, 6101, 4257, 6250, 5442, 6117, 6116, 
         4780, 5663, 5662, 5050, 4368, 5423, 5422, 4202, 5384, 4940, 4941, 
         3725, 4455, 4193, 4588, 4939}],
        "2.2`"],
       Annotation[#, 2.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4183, 4575, 4184, 4579, 4578, 4715, 4182, 5413, 4245, 5044, 
         5046, 3787, 5048, 3788, 5652, 5416, 4247, 5415, 4248, 5438, 5439, 
         4277, 5440, 4276, 4794, 4745}],
        "2.2`"],
       Annotation[#, 2.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3685, 4407, 4338, 5462, 4337, 6152, 4822, 6020, 6019, 6186, 
         5484, 6018, 6246, 6017, 5379, 5378, 4387, 5483, 5047, 5045, 4246, 
         6100, 5414, 4932, 4448, 4717, 4716, 3952, 4718, 3950, 4574, 4698, 
         4697, 4559, 4921, 4920}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4177, 4709, 3721, 3676, 4929, 4589, 3962, 4722, 4454, 4724, 
         4725, 4592, 4194, 4779, 4254, 5421, 5049, 4729, 4200, 5427, 4256, 
         5425, 4255, 5426, 5429, 5428}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3660, 4548, 4686, 4555, 4557, 4701, 4700, 3943, 4699, 4167, 
         4440, 4919, 4577, 3951, 4714, 4180, 4447, 3722, 3678, 4942, 3684, 
         5564, 4943, 4391, 5492, 4393, 5490, 4392, 5491, 4195, 4726, 4390, 
         5489, 6150, 6151, 4823, 4336, 4821, 4727}],
        "1.8`"],
       Annotation[#, 1.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3689, 3728, 5424, 4457, 4199, 4593, 4944, 3688, 5420, 4723, 
         4590, 4591, 4192, 4721, 3961, 4587, 4178, 4573, 4179, 4713, 4446, 
         4710, 4711, 4569, 4568, 3666, 3717, 4693}],
        "1.8`"],
       Annotation[#, 1.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3665, 4915, 4905, 4163, 5364, 4437, 4438, 4916, 4570, 4164, 
         4695, 3949, 4707, 4175, 4572, 4571, 4712, 4586, 3683, 4937, 4927, 
         4191, 5375, 4452, 4453, 4938, 4594, 3974, 4728, 4456, 5382, 5383, 
         5182, 4201}],
        "1.6`"],
       Annotation[#, 1.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5358, 5359, 5353, 4155, 5360, 3933, 4549, 4153, 4556, 4154, 
         4687, 3942, 4696, 4165, 4439, 3718, 3668, 4576, 3677, 5559, 4931, 
         4181, 5371, 3954, 4581, 4186, 5486, 6239, 5487, 5485, 5488, 3963, 
         5788, 3964, 6274, 6275, 6273, 5171, 6022, 6023, 6021, 5565}],
        "1.6`"],
       Annotation[#, 1.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3686, 3726, 4982, 4980, 5170, 5169, 3679, 5562, 4450, 4449, 
         4719, 3953, 5366, 4170, 4930, 4169, 4561, 3945, 5365, 4166, 4918, 
         5555, 3667, 4558, 3659, 3713, 4431, 4685, 4684, 3932, 5354, 4134, 
         5352, 4133, 5996, 4538, 4539, 4136, 5335, 4135}],
        "1.4`"],
       Annotation[#, 1.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4904, 4893, 4150, 4430, 3712, 5548, 5547, 4906, 4151, 5356, 
         3941, 4691, 4692, 4554, 4553, 4694, 4567, 3675, 4926, 4913, 4174, 
         5369, 4444, 4445, 5558, 4928, 4176, 5370, 3959, 4720, 3960, 4585, 
         5377, 5376, 5178, 5179, 4984, 5181, 5180, 5381}],
        "1.4`"],
       Annotation[#, 1.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3598, 4501, 3597, 5113, 5114, 5110, 5112, 5111, 3596, 5108, 
         5109, 5105, 5107, 5106, 3595, 5103, 5104, 5100, 5102, 5101, 3594, 
         5098, 5099, 5095, 5097, 5096, 3593, 4500, 4626}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3646, 4667, 5974, 5975, 5334, 5337, 5336, 3925, 4812, 4422, 
         4423, 4895, 3654, 4547, 3658, 5549, 4908, 4152, 5357, 3935, 4550, 
         4156, 4917, 4157, 5361, 3944, 4817, 4818, 4441, 3719, 3670, 4580, 
         5561, 5560, 4934, 4185, 4583, 4582, 5372, 5373, 5172, 3965, 4981, 
         3967, 5173, 4196}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4672, 3709, 3652, 5533, 4894, 5351, 5350, 3930, 4681, 3931, 
         4546, 4683, 4682, 4552, 3664, 4912, 4902, 4161, 5362, 4435, 4436, 
         5554, 4914, 4162, 5363, 3948, 4705, 4706, 4566, 4565, 4708, 4584, 
         4936, 4935, 4924, 4189, 4451, 3724, 3682, 5563, 5175, 5794, 3973, 
         4983, 4985, 4986, 5566}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3592, 6188, 4297, 4625, 4624, 4849, 4848, 4499, 3865, 4627, 
         3866, 5939, 4068, 5938, 4067, 5733, 3867, 5568, 5940, 5941, 4069, 
         5734, 3868, 5569, 5942, 5943, 4070, 5735, 3869, 5570, 5944, 5945, 
         4071, 5736, 3870, 5571, 5946, 5947, 4072, 5948, 4073, 5949, 3871, 
         4628, 3872, 4502, 4850, 4851, 4503, 4504, 4074, 5950, 5952, 5951}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3651, 6198, 4131, 4421, 5994, 5995, 5991, 5993, 5992, 4545, 
         3657, 6201, 4148, 4428, 4429, 5546, 4903, 4149, 6006, 3940, 5774, 
         5776, 5775, 6009, 4564, 3674, 6203, 4173, 4442, 4443, 5557, 4925, 
         5368, 5367, 3957, 5787, 3958, 5168, 4190, 5374, 5793, 3972, 5795, 
         5174, 5177, 5176, 5380}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3687, 3727, 5591, 5590, 3966, 5789, 3680, 5587, 5586, 5585, 
         3955, 6010, 6011, 4933, 4171, 4702, 4168, 4328, 6202, 3669, 4560, 
         3661, 3714, 5582, 5581, 3934, 5997, 4138, 4907, 4137, 4673, 4132, 
         4317, 6199, 3653, 4537, 3645, 6197, 4122, 4121, 4124, 6245, 4123}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3600, 5496, 3599, 5495, 5494, 5712, 5711, 5737, 4344, 6258, 
         4345, 4343, 6160, 6161, 6157, 6159, 6158, 4597, 3602, 5837, 5838, 
         5836, 3996, 4042, 6243, 4041, 3745, 6267, 5253, 5080, 3842, 5714, 
         3841, 3877, 6237, 3876, 4260, 3794, 6047, 4214, 6046, 4213, 4635, 
         3692, 5501, 5500, 5499, 4082, 4220, 6247, 4219, 3609, 5756, 5757, 
         5753, 5755, 5754, 3608, 5752, 3884, 5750, 3883, 5751, 3607, 5749, 
         3882, 5747, 3881, 5748, 3606, 5745, 5746, 5742, 5744, 5743, 3605, 
         4633, 4634, 4299, 6130, 4298, 4632, 5447, 3691, 6263, 5446, 4946, 
         3875, 5115, 4080, 5953, 4081, 5954, 3874, 5738, 5740, 5739, 3601, 
         4622, 3591, 6187, 4296, 4064, 4748, 4749, 4385, 4394, 3590, 4750, 
         4783, 4259}],
        FractionBox["1", "2"]],
       Annotation[#, 
        Rational[1, 2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3638, 3993, 6241, 3994, 4018, 6242, 4017, 3744, 3856, 6235, 
         3855, 3703, 3637, 6196, 4111, 3917, 5972, 5973, 5971, 4120, 3706, 
         3644, 5770, 5771, 5579, 5580, 5989, 5990, 5987, 4130, 5988, 4544, 
         5545, 5544, 5543, 4146, 4427, 3711, 3656, 6200, 4147, 3938, 4845, 
         3939, 4551, 4160, 4690, 4562, 4563, 4172, 6014, 6015, 5584, 5583, 
         3720, 3673, 5470, 5471, 5469, 4364, 5472, 4334, 6149, 4335, 5588, 
         5589, 4406, 4405, 6176, 4367, 5657, 5658, 5659, 4824, 4339, 6153, 
         4340, 6154, 4408}],
        FractionBox["1", "2"]],
       Annotation[#, 
        Rational[1, 2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4197, 5792, 3969, 5790, 3968, 5791, 4187, 6016, 5783, 5784, 
         5780, 5782, 5781, 6012, 4703, 6145, 6146, 6144, 4329, 4689, 4688, 
         5551, 5550, 4975, 4974, 4973, 3936, 5999, 6000, 5998, 4139, 4674, 
         4675, 4318, 5534, 5535, 5536, 4668, 5529, 5528, 5527, 6138, 6137, 
         3918, 5767, 5769, 5768, 5970, 4650, 5966, 5967, 5965, 5969, 5968, 
         4104, 4311, 6254, 4310, 4648, 4308, 6253, 4309, 3905, 5152, 5154, 
         5153, 5311}],
        FractionBox["1", "2"]],
       Annotation[#, 
        Rational[1, 2], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3792, 5660, 5661, 5655, 5656, 3791, 5931, 5932, 5654, 5653, 
         5897, 4040, 6277, 5695, 3811, 5694, 6276, 4038, 5896, 5650, 5651, 
         3786, 5920, 3785, 5043, 5042, 6236, 3863, 5732, 5167, 5778, 5779, 
         5777, 3947, 5912, 4047, 5911, 5914, 5913, 4037, 5890, 4036, 5891, 
         3663, 3716, 4976, 4467, 3805, 4830, 3806, 5681, 5250, 4035, 5249, 
         4034, 5092, 3860, 5091, 5094, 5093, 5389, 4740, 5644, 5643, 5038, 
         4242, 4404, 3650, 3708, 5984, 5985, 5983, 4129, 5986, 3924, 4536, 
         4118, 4775, 4119, 4666, 4206, 5088, 3859, 4886, 4887, 3643, 5242, 
         5903, 5904, 5902, 5906, 5905, 3992, 5597, 5598, 3743, 5889, 3742, 
         6081, 6082, 6080, 6084, 6083, 4102, 4307, 6194, 3631, 3699, 4353, 
         6259, 4354, 4237, 6078, 6079, 6075, 6077, 6076, 3741, 5881, 5882, 
         5596, 5595, 5594, 3991, 4103, 6195, 3632, 4604, 4232, 6249, 4233, 
         4763, 4762, 3773, 3901, 6208, 3697, 4058, 5702, 3826}],
        FractionBox["1", "4"]],
       Annotation[#, 
        Rational[1, 4], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3827, 4802, 3828, 5703, 5272, 4053, 5271, 4052, 4997, 4996, 
         4994, 3995, 5835, 5216, 4993, 5076, 5710, 3838, 5075, 4846, 4847, 
         4211, 6044, 4212, 6045, 4076, 4854, 4075, 5282, 4623, 4630, 4078, 
         4639, 4079, 4631, 4989, 4261, 6225, 3796, 4784, 3795, 4004, 6217, 
         3753, 4381, 6233, 3835, 4805, 4806, 4303, 5504, 5505, 3604, 6183, 
         3612, 6185, 4382, 6184, 4383, 4836, 4835, 3837, 4384, 3836, 6234, 
         4295, 5709, 5708, 4289, 6123, 5445, 5121, 3888, 5120, 3889, 5122, 
         5508, 5124, 3890, 5123, 3891, 5125, 5510, 5509, 4086, 5957, 3892, 
         4952, 5288, 5289, 4087, 4508, 3893, 4758, 4411, 5958, 4088, 5511, 
         5512, 6061, 6062, 5615, 5616, 3755, 4756, 3756, 5618, 5617, 6064, 
         6063, 4395, 5844, 5845, 5604, 5605, 3754, 5900, 5901, 5608, 5607, 
         5606, 4005, 5846, 4396, 5847, 4006, 5609, 5610, 4045, 6226, 3797, 
         5851, 4007, 5848, 5850, 5849, 3613, 4602, 6163, 6164, 6162, 4346, 
         4826, 4825, 5613, 5612, 5611, 6166, 6165, 3885, 5758, 5760, 5759, 
         3846, 5718, 3847, 5083, 5392, 4215, 6216, 3750, 4637, 4300, 6252, 
         4301, 4947, 4475, 3843, 4752, 3844, 5797, 3976, 5796, 3975, 6042, 
         6043, 5002, 5600, 3746, 4751, 3747, 5004, 5003, 4210, 5391, 3873, 
         5217, 3998, 4999, 5000, 5001, 4054, 5273, 4055, 5274, 5704, 3831, 
         4629, 4804}],
        FractionBox["1", "4"]],
       Annotation[#, 
        Rational[1, 4], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4089, 5959, 4090, 3988, 3989, 3849, 4863, 4864, 3615, 5215, 
         3627, 4400, 4208, 6212, 3736, 4747, 3737, 5722, 5723, 5719, 5721, 
         5720, 4209, 6038, 6039, 5962, 5964, 5963, 3906, 4959, 4961, 4962, 
         5522, 3633, 4649, 3639, 5525, 4875, 4112, 5326, 4106, 5455, 4314, 
         4877, 4878, 4661, 4115, 5979, 4125, 5976, 5978, 5977, 4531, 5980, 
         5981, 5339, 5772, 3926, 5773, 3927, 5456, 5457, 4898, 4899, 4900, 
         4676, 4677, 4159, 6007, 4158, 6008, 6095, 6094, 4496, 6173, 4362, 
         6172, 4363, 4777, 4776, 5646, 5645, 5041, 6099, 6098, 3861, 5730, 
         3862, 5731, 5915, 3784, 4048, 5916, 5917, 5785, 3956, 5786, 4188, 
         4039, 6224, 3789, 4051, 3970, 6240, 3971, 4198}],
        FractionBox["1", "4"]],
       Annotation[#, 
        Rational[1, 4], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3626, 6181, 4379, 6180, 4380, 6182, 4283, 6122, 4285, 6121, 
         4284, 3763, 5833, 5834, 5830, 5832, 5831, 3625, 5518, 5519, 5212, 
         5214, 6268, 5213, 6269, 3762, 5619, 4348, 6167, 4349, 5465, 4282, 
         6120, 5444, 5481, 5479, 5480, 4378, 5072, 5701, 3823, 4834, 3824, 
         5278, 5279, 5275, 5277, 5276, 3734, 6051, 4221, 6050, 4222, 4642, 
         4641, 6132, 4304, 6131, 6134, 6133, 4948, 5117, 5118, 5071, 5070, 
         3822, 4636, 5955, 5956, 5286, 4084, 5287, 3985, 5393, 4217, 5012, 
         5602, 4753, 4216, 5395, 4218, 5394, 6049, 6048, 4505, 5219, 3729, 
         6211, 5218, 4987, 3978, 5280, 5281, 4853, 5497, 5498, 3690, 4409, 
         3997, 4998, 5599}],
        FractionBox["1", "6"]],
       Annotation[#, 
        Rational[1, 6], "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1FtMFmQcx/GnhRyaghxEdItCEdCE0EoLIaLaavOseehwAa1uzElxqi5a
F7K1BFI0u2pr2ZblXCKQkpqI5aw8tA4rSxChQhM6p01v7PNcfN/f8z8/z/M+
75v3ZO2KDTeEEHb6yEkLYWt6CAO0dHII5+gceiU1hEsZIVymjeKnaSF/EQow
CzPxK/+gmot0TU4IZ6zfyAphOzaigq+Z1mWGcAJfYH52CPNwF76Wf4s+6daJ
NAkLrMswpOcheximFexy/CQ+jHXquiaGsFL/QfEeeZ3sVZNCGKNl5izAWrGb
xNqdIZkeUfct7aOT9MlGJk6zs+hx+R3q9mAI1WbWYNj6GazHu2YUO9Ojakpo
qXi/uof1LTW7QZ85tJH2yknk32R+Cz7gb6OteJm/EkfVJuuxW+8t4nPFyvju
p1V4wrwk+p74+9gV9xDPICdJ3Yv20GNOPd1PfzT3LArFijATb8mfTW/DrDjL
nHf03IEmdfvUNdIX8Dw62LV0D32WtttDiXl1uK42x70HtVNoC/tN/YO+1+W1
sg+Yv168h77Cvsp/DYfUF8hdZH2zvrloVrcxfr9m7cZiPQ/KWxvvGKvxqfgn
OIY17MfxGPbKe4SuwnKsxAoU8ffKPYLDOIo+dMQ3RT/GRziIAyjk/5dexj/4
D1fwPf9f9G/8jj/xBwr4f6Ej+BkXcQHf8Q/Hd4rB+IZxHjP4u9xFN6Y6e248
P5rdTTadjCy0xftDvvxi91CC4+zseF7feybNwHTxNJqO8UjFBEyLb4mmIBFJ
aNCjCY3IE99qD9vQju14HbX2sZluQSteQxtulf+q+ZuwRK9lWIpR/g+dax/2
ogud6MZC8cVYhG55C83d5XtdF9+neA9OOctJjIn3eQ+/0Sr++2LcXkbMfsDM
QTkT1Lbo0Yp+9jlsth6gqXI6430gH9V8D8Y3xH9GnwT2OCRitjnFyOAfz06n
X6rZ6Z3O45+PDuul6iusl9F+8QFMkT8VlfH9xN+N/m8jL/bVp5fvMB5SV8I+
S+udoQ6j6pPFUmJv+z6mxzY5J8RO4SRqzBqIM+UsxxI5Kew1tNucBHU3YlRd
ebwXNRX0aTyFBjVj8i+Jf0M3sM/LGcLd7vSe+A71qhZ7iS8B45DGPxG51l/Z
w1zrO3AnPnO2z/Ec6lFu/r3x965PDSqtq8zeb+Zq65H4m7O+QPP1m4E8TMc0
FOMHM5rs7aqcUXu5Rm/n74//pfF/K/7fiNfif3yf7dU=
         "]],
        FractionBox["1", "6"]],
       Annotation[#, 
        Rational[1, 6], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4065, 4995, 4066, 4606, 4605, 4471, 5254, 4472, 3999, 5005, 
         5006, 3748, 5258, 3749, 6214, 6215, 6213, 5007, 4855, 5077, 4856, 
         4857, 3981, 5451, 4302, 5448, 5450, 5449, 4640, 3752, 5190, 5191, 
         5188, 3984, 5189, 6270, 3845, 5716, 5717, 5082, 6264, 5081, 6265, 
         3733, 4009, 5852, 5854, 5853, 3887, 5572, 5573, 5574, 3611, 5507, 
         4951, 4860, 3848, 5807, 5808, 5804, 5806, 5805, 3614, 5800, 5801, 
         5799, 5803, 5802, 3825, 6128, 4293, 6127, 4294, 6129, 4290, 6126, 
         4292, 6124, 4291, 6125, 4621}],
        FractionBox["1", "6"]],
       Annotation[#, 
        Rational[1, 6], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3603, 4858, 4852, 4083, 5285, 3977, 4598, 5010, 5009, 4002, 
         5220, 3878, 4754, 4755, 4507, 4506, 4638, 4600, 5014, 5013, 5011, 
         4003, 4458, 3731, 4619, 4620, 4342, 6155, 4341, 6156, 4746, 5700, 
         5699, 5698, 4281, 6119, 4461, 4347, 6248, 4223, 6055, 6056, 6052, 
         6054, 6053, 3735, 4226, 6065, 4227, 6066, 4225, 4757, 5020}],
        FractionBox["1", "8"]],
       Annotation[#, 
        Rational[1, 8], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4305, 4643, 4085, 6060, 4224, 6057, 6059, 6058, 3732, 4990, 
         4991, 4859, 5715, 5116, 5741, 3880, 6238, 3879, 6271, 5221, 5843, 
         5842, 3730, 4988, 4474, 3840, 4599, 3839, 5078, 5713, 5079, 5840, 
         5841, 5839, 5257, 5259, 4044, 5051, 5053, 4607, 4000, 5256, 4043, 
         5255, 5899, 5898}],
        FractionBox["1", "8"]],
       Annotation[#, 
        Rational[1, 8], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3894, 4955, 5291, 6244, 6279, 6278, 4092, 5960, 4093, 5293, 
         3895, 5131, 3896, 5136, 5515, 5140, 3897, 4953, 3898, 5141, 5397, 
         5400, 5401, 5021, 5620, 3765, 4759, 3766, 5023, 5022, 5404, 5403, 
         4399, 5222, 5223, 5016, 5260, 6218, 3757, 5261, 3758, 5017, 4478, 
         3851, 4644, 3850, 5224, 5225, 5018, 5019, 3759, 5262, 5146, 5147, 
         5145, 3899, 5148, 3852, 4479, 3990, 4350, 6220, 3770, 4760, 4761, 
         4388, 4459, 3739, 5464, 3740, 6266, 5463, 4992, 5057, 5056, 5669, 
         5668, 5058, 5884, 5885, 4014, 5230, 5026, 5410, 5411, 5027, 5633, 
         5634, 4765, 4766, 4356, 5466, 4355, 6170, 3702, 3636, 5524, 5236, 
         4020, 5234, 4021, 5245, 5246, 5243, 4025, 5244, 4526, 4527, 4483, 
         3858, 4773, 3857, 4482, 4027, 5247, 4028, 5248, 5679, 3803, 4789, 
         5063, 5062, 5061, 4370, 5474, 4419, 4420, 3649, 4403, 4143, 4489, 
         4488, 3779, 5268, 3780, 6222, 5267, 5037, 4030, 4495, 4494, 4615, 
         4911, 4910, 5460, 4327, 6257, 5435, 6110, 4816, 4326, 4837, 4325, 
         4815, 4791, 4743, 4744, 4244, 6096, 6097, 5434, 5433, 6109, 3715, 
         4434, 4841, 4840, 4273, 4742, 4741, 3782, 5459, 4322, 5482, 4323, 
         6286, 4814, 5432, 6255, 6256, 6142, 6143, 4324, 6141, 5552, 5553, 
         4909, 3655, 4901, 4425, 4424, 4678, 3928, 5346, 5347, 4896, 5343, 
         5342, 4534, 5338, 4126, 4888, 4127, 4530, 4529, 4882, 4881, 4880, 
         4117, 5331, 3915, 4659, 4660, 4517, 4516, 4654, 4512, 5312, 5313, 
         4867, 4105, 5314, 3907, 4510, 4865, 5386, 5387, 5385, 6025, 6024, 
         4730, 3738, 5593, 5592, 6041, 6040, 4397, 4398, 5576, 5290, 4091, 
         5130, 3894}],
        FractionBox["1", "8"]],
       Annotation[#, 
        Rational[1, 8], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3751, 5601, 5008, 4001, 4410, 3693, 5503, 5502, 5193, 3986, 
         5192, 3987, 5194, 5614, 5015, 5761, 5762, 3886, 5119, 4949, 4950, 
         5506, 3610, 4603, 4862, 4861}],
        FractionBox["1", "12"]],
       Annotation[#, 
        Rational[1, 12], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4008, 4610, 4601, 4476, 5186, 3982, 5185, 3983, 5187, 5603, 
         5184, 3980, 5183, 3979, 5798, 4473, 4608, 4609, 4077, 5052, 5284, 
         5283}],
        FractionBox["1", "12"]],
       Annotation[#, 
        Rational[1, 12], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4095, 5292, 4094, 5295, 4509, 3628, 5520, 5299, 5301, 6191, 
         6192, 3902, 5300, 4413, 5303, 5304, 5302, 4098, 4511, 3909, 4651, 
         3910, 5316, 5317, 5315, 5523, 4518, 3914, 5330, 4116, 4879, 5329, 
         5328, 4520, 4664, 4665, 4532, 3921, 4670, 3922, 5344, 5345, 4891, 
         4892, 3648, 4541, 5541, 5540, 6001, 4141, 6281, 5539, 5641, 5642, 
         4736, 4737, 4271, 4838, 4839, 4426, 3710, 6108, 5430, 5431, 6090, 
         6089, 4241, 4739, 4738, 4790, 4272, 4813, 4319, 4828, 4465, 4466, 
         4371, 5475, 6282, 4320, 6140, 4321, 5458, 4029, 4613, 4484, 4485, 
         4386, 4487, 4486, 4535, 5265, 5266, 5264, 5263, 5035, 4026, 4401, 
         3641, 3705, 6171, 4357, 5467, 4358, 4772, 4771, 5638, 5637, 5636, 
         6086, 6085, 5028, 5233, 4019, 5888, 5887, 5059, 5670, 3802, 4786, 
         4787, 4267, 6104, 4266, 6105, 4513, 5886, 3774, 5630, 5629, 4013, 
         5883, 4306, 4785, 4263, 4265, 6251, 4264, 3769, 5024, 5025, 4866, 
         5227, 6193, 3629, 5228, 5229, 4097, 5961, 4096, 4645, 3801, 5868, 
         5869, 5865, 5867, 5866, 4477, 3696, 5578, 4958, 5055, 5054, 3800, 
         5664, 5408, 6285, 4230, 5407, 4229, 6069, 5297, 3695, 5577, 5296, 
         4956, 5144, 5143, 5294, 3694, 4412, 4095}],
        FractionBox["1", "12"]],
       Annotation[#, 
        Rational[1, 12], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4101, 5308, 4100, 5309, 6272, 3911, 5766, 5157, 5765, 3912, 
         5158, 4107, 5318, 5320, 5319, 3916, 4965, 4967, 4968, 5526, 3640, 
         4533, 5532, 5531, 5982, 4128, 6280, 5530, 3923, 4970, 5348, 6210, 
         3707, 5349, 6087, 6088, 5412, 4239, 4734, 4733, 4788, 4269, 5473, 
         4369, 5060, 5677, 5678, 4811, 4315, 6139, 4316, 4612, 4611, 4480, 
         4481, 4238, 5031, 5635, 3776, 4770, 3775, 5029, 5030, 4874, 5727, 
         5388, 6027, 4205, 6026, 4204, 4732, 4203, 4731, 5628, 5627, 4234, 
         6073, 6136, 6135, 4647, 5667, 5666, 5665, 6103, 6102, 5624, 5623, 
         4011, 5880, 3854, 5724, 5726, 5725, 3768, 4262, 3767, 5622, 5621, 
         6071, 6070, 5409, 5151, 3904, 4957, 3903, 5306, 5307, 5305, 4099, 
         4415, 4414, 5310, 4101}],
        FractionBox["1", "24"]],
       Annotation[#, 
        Rational[1, 24], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4109, 4969, 5332, 6209, 3704, 5333, 4524, 4525, 4810, 4809, 
         4416, 4768, 4769, 4523, 4522, 3635, 3701, 4964, 4963, 4108, 5321, 
         5323, 5322, 3634, 5161, 5162, 5159, 3913, 5160, 5164, 5163, 5454, 
         5324, 5325, 4966, 4109}],
        FractionBox["1", "100"]],
       Annotation[#, 
        Rational[1, 100], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4658, 4110, 4657, 4655, 4808, 4313, 4807, 3700, 4872, 4871, 
         4873, 4656, 4884, 4883, 4885, 4521, 4658}],
        FractionBox["1", "1000"]],
       Annotation[#, 
        Rational[1, 1000], "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Axes->True,
  PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.421025047259*^9, 3.42102506255*^9}, {3.42102512574*^9, 
   3.4210251901549997`*^9}, 3.4210887572706003`*^9, 3.4210904760338*^9, 
   3.421090514597*^9, 3.4210905853898*^9, 3.4210906173542*^9, {
   3.4210907310626*^9, 3.421090773947*^9}, {3.421090853117*^9, 
   3.4210908677654*^9}, 3.421090933847*^9, 3.4210911191594*^9, 
   3.4210911576914*^9, 3.4210912148654003`*^9, {3.4210913627222*^9, 
   3.4210913786654*^9}, 3.4210914669146*^9, {3.421091557925*^9, 
   3.4210915982978*^9}, 3.4210916323682003`*^9, 3.4210916771870003`*^9, 
   3.4210917132542*^9, {3.4210917454058*^9, 3.4210918505654*^9}, {
   3.4210918971782*^9, 3.4210919154302*^9}, 3.4210919471138*^9, 
   3.421092052679*^9, 3.4212889947432003`*^9, 3.4212898107412*^9}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1XHdczt8Xp2zZhIxCJRnZm2P2zc4qpUgUsjeRkBHfUDJDsrLTNFJuqifR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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmgn8V1Maxu+554qQrUK29hKpaE9S2kRRlCSURBgpFZX2yFZUTPbsTMY2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         "]], Polygon3DBox[CompressedData["
1:eJxFmQn4V9MWhvcZlFAyU6FUSsZICZWKzGUoypAxRAnXWEpkJklmZeYaEpnJ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         "]], Polygon3DBox[CompressedData["
1:eJw1lWlwTlcYx+8SimBGk9hmjPWD5UN9UDpGa+ebmRq8oYklpTK2qDVhpqVE
iKWWWGOnQjCWlqAoQYIhxL6OGVtRsdQutt9/zmPm/c3zv//n3Puee85znls3
KaXrsMDzvGQoA/u42As3oJDrtaHnNYEG6A++572FUphCfhXeJOJg8kOgLbSB
mnjNyVUjXmLsRYjDj8K7gC7Gz0efIGbjL4Xz+OcgFs3PO4ueS34ROhVjMXoJ
fItuhheH/hJioIixJ+F/3UuMIX6tcVCefEO9G/Eo14XwCH0arwI6W89Fj0Mv
R6+A5ehlsA39F7lTxGs89ypUDd06XUF35YWSid8TXzHmteYLi8mn6b3Qy+A8
7MRbg3cNfR126NlwAY6QW2m5q1Cqe/D24F3RWPQq9CX0ZdCGzccbTByA/xO8
RBfjPdFzud4BjaAe3hvm+BJewRDyWdpv4o/k+0NT9FdwB/2a3L/Ek1wfRB/V
O2n9oUBzhZa8b0T7g1cMtxh3hhhNriJ0IH8Yrw2xI3SC+poLlHBfTf0HsYSx
p9APiJvIbYa+6PF4iegkzRHqoGvDfe6pQe627+pzF3od/k30LXiKfgLx/N8g
xkSIY/Az9b744/Rs/Se6CE5DLXJPGVuI/w/6MHEefhZMhQyYg/cHuc3EhVwv
gA3o7bY+new920M2zxpPHAkjolyNnGFcldCtjdboG3RZ7Qnxg3z0+9DVcJHt
k/arIV4Vra3vaqIAvV+HA3xbD61lucDVe3M44bt7YmwttCajYRSkMG4BuVnE
Xlz3hA7oVLx4YgrXw2CQ1UgGcaDV1w/oDLyhxGc6A/zPc+J/xIewBf9P8rnE
KbZuP8Pw0NWc6jWT+CvXv4Suf6xWf/l85rT+sBvvd/LpMBlm4q2156rHqNcM
1B7hpdv5Vx9ohV/fepQaTSWiT/wicOtTar2rMeNiGHJZ/QLKy7d6UF1UhhvW
G47BcXjPmHe+64Ox5K6jszQH1YCd7czQ9Sf1qd2QhzcDrwt8RJdof/BbQDw6
Au3QY8n1IG60esohTrJ3j2b+VfmvisTq+DUgAumM6xa4Z+hZs22Npgdun7Xf
fdBpeAnoRHTvwPXgWHt39Vr1XJ0HnQv1wQ3Wt1I1L+tl663/5sFOOId3CO8F
8TeuJ8I09Bqb+12eGY2+57tzWxdmWF71NNzqIl/9BW7DMd2L90Dv6rl6Ur9o
oDW13rPJ6kvfjM46c5AA0+wd1RfVH9uxVom+6z15XK/TuoSu16rnJqH7QXdb
x2TrMeo1aYH7FqhXqM/H2V7r+6Xv2Hry26xmJ9i7b4Tc0PWPA9bLplptqz6H
2pkaiR4RuG9aDrmxeL10Vmz/dRZ1JnUGcvFmh2598q3Gcqye9qD/1jzQW1W3
gfuWPg5cL1dPj9hz9X1ozTokMPfvolzvLrD61L7OCt33fr/6gnqbzUt1rfqe
yD0ruHeC9TL1tE9NTx/9
         "]]}]}, {}, {}, {}}, {
     {GrayLevel[0], 
      Line3DBox[{459, 1, 432, 260, 463, 16, 364, 31, 276, 46, 286, 61, 1161, 
       427, 76, 559, 560, 91, 571, 106, 584, 585, 121, 607, 136, 628, 629, 
       151, 662, 663, 166, 695, 696, 181, 730, 196, 1092, 350, 443, 211, 1170,
        438, 1134, 397, 762, 761, 212, 766, 765, 764, 213, 769, 768, 767, 214,
        771, 770, 215, 772, 216, 1097, 353, 217, 1099, 355, 445, 218, 453, 
       357, 773, 219, 359, 774, 220, 775, 221, 776, 777, 222, 779, 780, 781, 
       223, 782, 783, 784, 224, 1109, 1110, 361, 1175, 446, 786, 225, 440, 
       402, 785, 210, 757, 195, 720, 719, 180, 686, 685, 165, 655, 654, 150, 
       621, 135, 601, 600, 120, 579, 105, 567, 566, 90, 430, 556, 75, 295, 60,
        283, 45, 273, 30, 1019, 266, 442, 15, 1165, 433, 265, 498, 14, 496, 
       13, 494, 12, 490, 11, 486, 10, 9, 8, 7, 6, 474, 5, 470, 4, 467, 3, 464,
        2, 1111, 362, 441, 459}]}, {
      Line3DBox[{459, 1172, 1144, 1112, 1008, 787, 462, 1022, 500, 808, 502, 
       505, 1034, 528, 1180, 1181, 827, 529, 828, 530, 533, 543, 838, 544, 
       839, 545, 1039, 538, 832, 536, 1036, 1117, 834, 539, 1026, 1118, 835, 
       540, 983, 1027, 525, 824, 523, 978, 1028, 825, 526, 979, 1020, 976, 
       974, 1018, 1145, 1166, 1165}], 
      Line3DBox[{463, 1010, 461, 1021, 1115, 1023, 501, 981, 1033, 1032, 982, 
       527, 985, 1038, 1037, 837, 542, 1160, 1178, 1177, 1161}], 
      Line3DBox[{464, 465, 788, 468, 473, 507, 811, 508, 812, 511, 814, 513, 
       816, 515, 818, 517, 821, 520, 1024, 493, 802, 491, 1012, 1113, 805, 
       495, 1015, 496}], 
      Line3DBox[{467, 469, 789, 471, 477, 509, 813, 512, 815, 514, 817, 516, 
       819, 518, 822, 489, 799, 487, 803, 492, 1011, 494}], 
      Line3DBox[{470, 472, 790, 475, 791, 478, 793, 480, 795, 482, 797, 484, 
       800, 488, 804, 490}], 
      Line3DBox[{474, 476, 792, 479, 794, 481, 796, 483, 798, 485, 801, 486}],
       Line3DBox[{498, 975, 497, 806, 1017, 1016, 977, 524, 1014, 1114, 1013, 
       522, 823, 1116, 1025, 519, 820, 521, 1035, 537, 833, 535, 831, 534, 
       830, 532, 829, 531, 510, 506, 810, 504, 809, 503, 466, 460, 1009, 
       1111}], Line3DBox[{556, 1163, 1164, 1049, 1048, 987, 1046, 1047, 986, 
       541, 836, 1157, 1159, 1158, 984, 1030, 1031, 826, 1029, 980, 499, 807, 
       1019}], Line3DBox[{560, 999, 558, 569, 573, 586, 589, 861, 610, 633, 
       637, 890, 670, 703, 706, 935, 741, 961, 772}], 
      Line3DBox[{566, 1005, 1056, 1004, 1061, 1060, 845, 565, 1062, 1006, 
       1067, 1066, 849, 576, 1123, 1068, 594, 853, 595, 864, 615, 875, 643, 
       874, 644, 1077, 893, 675, 1081, 1132, 1082, 709, 1086, 743, 1133, 936, 
       744, 1101, 1137, 962, 774}], 
      Line3DBox[{571, 570, 581, 587, 608, 611, 872, 634, 667, 671, 911, 704, 
       934, 738, 959, 770}], 
      Line3DBox[{579, 851, 580, 857, 598, 856, 599, 867, 616, 866, 618, 878, 
       648, 896, 676, 895, 678, 916, 711, 938, 747, 964, 776}], 
      Line3DBox[{585, 583, 860, 605, 624, 631, 664, 669, 910, 701, 932, 736, 
       957, 767}], 
      Line3DBox[{600, 858, 602, 869, 619, 868, 620, 880, 647, 879, 649, 897, 
       680, 917, 713, 940, 746, 939, 748, 965, 777}], 
      Line3DBox[{607, 606, 625, 632, 888, 665, 697, 702, 933, 737, 958, 768}],
       Line3DBox[{621, 871, 623, 884, 651, 882, 653, 900, 683, 920, 712, 919, 
       715, 942, 750, 967, 780}], 
      Line3DBox[{629, 627, 887, 659, 690, 699, 931, 732, 954, 764}], 
      Line3DBox[{654, 885, 656, 902, 682, 901, 684, 921, 717, 943, 753, 969, 
       778, 968, 781}], Line3DBox[{663, 661, 907, 692, 726, 734, 956, 766}], 
      Line3DBox[{685, 904, 688, 924, 721, 947, 751, 945, 755, 971, 783}], 
      Line3DBox[{696, 694, 929, 728, 1090, 953, 762}], 
      Line3DBox[{719, 926, 723, 949, 758, 1104, 1107, 1109}], 
      Line3DBox[{730, 729, 1088, 1093, 1091, 1148, 1134}], 
      Line3DBox[{757, 951, 760, 1106, 1138, 1152, 1154, 1175}], 
      Line3DBox[{761, 952, 1089, 727, 928, 693, 695}], 
      Line3DBox[{773, 1168, 1102, 1169, 1098, 1136, 1150, 1174, 1149, 1135, 
       1151, 1179, 1100, 1167, 1099}], 
      Line3DBox[{775, 963, 1103, 745, 937, 1087, 710, 914, 708, 915, 677, 894,
        646, 876, 645, 877, 617, 865, 597, 854, 596, 855, 578, 850, 577, 1007,
        1063, 568, 846, 567}], 
      Line3DBox[{784, 972, 756, 946, 752, 948, 722, 925, 689, 905, 686}], 
      Line3DBox[{785, 1139, 1153, 1171, 973, 786}], 
      Line3DBox[{1092, 1094, 1147, 1173, 1146, 1170}], 
      Line3DBox[{1097, 1096, 1095, 1143, 1083, 740, 705, 912, 672, 891, 639, 
       636, 612, 862, 591, 588, 574, 572, 561, 1000, 557, 998, 997, 559}], 
      Line3DBox[{1110, 1108, 1105, 759, 950, 724, 927, 720}], 
      Line3DBox[{584, 582, 604, 609, 630, 635, 889, 668, 909, 700, 735, 739, 
       960, 771}], 
      Line3DBox[{601, 859, 603, 870, 622, 883, 650, 881, 652, 899, 679, 898, 
       681, 918, 714, 941, 749, 966, 779}], 
      Line3DBox[{628, 626, 658, 666, 908, 698, 930, 731, 763, 769}], 
      Line3DBox[{655, 886, 657, 903, 687, 923, 716, 922, 718, 944, 754, 970, 
       782}], Line3DBox[{662, 660, 906, 691, 725, 733, 955, 765}], 
      Line3DBox[{1156, 990, 1050, 988, 1155, 989, 546, 991, 992, 548, 840, 
       549, 841, 550, 842, 551, 1051, 1052, 552, 1040, 1119, 1041, 553, 1042, 
       1120, 1043, 554, 993, 1044, 994, 555, 995, 1045, 996, 1053, 843, 1055, 
       1162, 1054, 1003, 1058, 1057, 844, 564, 1059, 1064, 848, 1122, 1121, 
       1065, 1070, 1069, 852, 593, 1071, 1124, 1072, 614, 1073, 641, 1125, 
       873, 642, 1076, 1129, 1128, 892, 674, 1080, 1131, 913, 1142, 1141, 
       1085, 742, 1084, 707, 1140, 1079, 1130, 1078, 673, 1075, 1126, 1127, 
       1074, 640, 638, 613, 863, 592, 590, 575, 847, 563, 1002, 562, 1001, 
       547, 1176, 1156}]}, {}, {}}},
   VertexColors->CompressedData["
1:eJztW3k0ll20R5QpkSEVmUUaVCoptvpUSEjKmKTSIFSUJklpMJQ0SCVJpZKk
5CtjpkjieV68g/l9HxJCQqQM97jr3n/uXeePd63X0vfd+5e19tprn9/5nX32
/u3zvFTcvG12CfDx8d0V5OObgP6Wzqo84WVFwtS8o/x9sQzIrpAuTzTigHl/
itkDHRq4ZzW2Xo6ogZyV/lZXo5jwI41JaysqByvz2FzTmHp4ZNehNsOOBvta
zU9+9mfBHvV7FdfkOXAr1nH6nQEC5PYGrpY7Ug8PT1oqH6uiQGGut69bIQH3
D0ZrZbM54HrJ0aLDvgmqLLr22Rwm4bhZbKGzXyPsuzm/dMToMyjbXu0c+UTC
tJUWv5uHGyHv9se45NDPQD1TfL+8De+Pi4/Dg8OP2y+OHxyfvWs1myp8CaiX
lH2b3E6HEfeYJlsVCjqVX33P9CSh/X0JlXmSCYZlq3/yrWfDuRif4BkUCRJn
ExxufaiGqJRSw5K1VRAb0eJxP5cGyyZIX6zLqoUnc0/rqKrRQWW3YnbgiXL4
nZi/XHBRPdBdFtxQmFYOjCN6TcxVlfDG82FPUUgDHPEQnndjiITLv8QlK17S
QT9Abvi8PhvI786rPeJJ+HQiYdbJuQywv3lm5IsLG27NOma2NRjvj4uPw4PD
j9svjh8cn2v2+mbQ28sgv8dH/TWLDp+YiyZErKEgVVU5zXGEgE/vNtwX52dA
phrtm8cgB6oKzSrSt5Pgs2Xwx2MNJgzemBR96RkbVFnpa6bEkeCVqSYw5ycL
ohq2VsRb1IHRlSBJ+UoSrL5pfOPbUQ2/ZO/skdaqhgsefUG6IjQ4qHv/SKRF
DXSGKzaraLPgwl9y+ROABg9ZCqcd39ZAxuupTavWMeFiaAmz15oGryXXnl1b
WwN8uWn6/b8ZWH9cfBweHH7cfnH84PiU2T9801aIgKbkq3kbaumw9oaXtihQ
4Pt4/T2Z6wRI8d++avqdDvMtSSX+6RSw9ouB90QSJDMMZ4pMYMB3RuK08p8c
2MWvO6NqGQnsen/ncCkGRCwQlPKv58BfIs/6NTaRkBI9Z7A1gwHiRtkJH5U5
UF9xMyhjFwmyYcsZSauZkLXsM8MllA0rZjiIUwdIaLOc4hB6jQmXSxdkv1nI
Bsfazsu3fElY+PlZUEASEwJG7rrSpfH+uPg4PDj8uP3i+MHxmRci+FE0gQCv
ZuvqM710mHU4W3G2NAVSpj3VQqkE5KSfG1Lqo8Pg7UZFA0kK6nOUfKyzCXjj
6Bfh308H4Qw5h5zJFGj9CL7a9p4Am0KNyDs/6QB0OyJNjIJvTQuXV5YQcHXo
itjxATo8aI0/rSlKgd6VabsnkwT48aV9l/9FB72fEzwnilDws89AIbKcAD7i
rulRZP/O533dQZgC/enR9l4VBMzfC5JRyF4zoaVPSRjvj4uPw4PDj9svjh8c
nydPX1x/fQsJMdc0fUoqGaDDl/VaT4gDffd0XHo1SRAK7dKOEmcAq8Ev2f8L
B0xHmia//kJAj6Ru8dUhOujc5F+QJoDiGx2IHD1fxwKLiNHz/XVoruro+ToO
/9wsuokA/Udrz6R9ocMan5/Bm+dQIGkUYHFDnYBLKYrRn9l0kIja5f73Ugqo
IYHjqcIozjda/SeUD5s4Pm/UjCioMAyq3zdSBjH2O8y9a+gga6Xmf9cY74+L
j8ODw4/bL44fHJ8CF/i1n7FIEP9gETAvqBoild0fnK2vAveEefvmnyWhuvX9
CUN5FnzcRn+qa9gA2ns2EdsNSOg5sU7UcioDxFZVb1Or48DvGZuujOaDul/5
jdF8OFTf+Z/54JaQuafdkIBYfieBe010ePRxWeePBRRcONU4u7i2DNxncqzs
GcgulJrONKOQbigqPR1XBkcKdp4qKkVxwt2XbHOgQPzHHkfp8DKgDX6+1P6R
DmJ7LFzCXPD+uPg4PDj8uP3i+MHxydouVdRnUg5uShEOZEEd7K9uujryG/Vf
DaPn+4dJyDqmUS+8rAZ8JQSeW25hwYyjYb1+50jI+7T67wotFmQ7OH/eI98A
t9yW77mmRkLDycivt8QYYNchds+8lYN0Ulau3lECBpKfVyzoQPjf03y8lCkY
Dgsy29FUBgsYlO0RJh0S5Lbp0tZR8H34w+5XoWUQ1L7E2xPxOcJOqTy0jYLV
x0MUVL3K4EdPvKpsIR0OqJOum3bj/XHxcXhw+HH7xfGD43NNkbVHQhMLHrxN
j8jQ50Ck042Arx8IKB8MvPTavBw+zHafbEXWQfQOdM0ay8G+34A9o4kEj+uL
MhWY1TBc/CkyWrMKfK9FL5jjQYKv2eFX0vuYcGuua8jLbWwofWzw8m4Hqlcb
ZxkdHKaD8/LFHA1+CsofxvHPmo309RmBHhMOHUpiyUsi6F7TvddFCSaXQZKQ
xkA+QYcnzz44vd9MAUNY+/DGi2WwtPacdWcxHbodZq53cMX74+Lj8ODw4/aL
4wfH5/c8HdYJsUaI1lZN/MH/Gb7yb+LLSiVh8HS72bmrTFj0ke3eWcaGnol6
By/rkeCyOtRsRTMNbiW8dNKYVAfubuz24OBKkCB2qUq/JSG92mwJeRPx/r07
8EFbDdjEb3YdXkWCqOcSvrPAgKs7HeTfJnBgJ/+p2JQrBJhmKR0q7qJD2rEj
t76geuincfbFwt9loJoktZOsRn3kvVRE1ip0f2uDXjsVl0HeJrdt/hWoT9Xf
bhS0wvvj4uPw4PDj9ovjB8fn3m0G1p6MVvj25UdLnlcLdGxRYGbYV8Bi5eGW
56fY4HXHPfDmlUZYtG+e4C8tEt4umdqZsbkSLvYl7je42QADiXMnNvwkoXX3
u1dDy2kwe4P93fVJNTBLN650izMTzGKWO87zJ6GzqHPkVTsTdgU/dsi62wCi
3jorRvVSl8aMGaN6Sd0va/qoXlrmlDnUY0+ARFBN/80WOkhOGDTI06IgakH9
nN8KBBT8nHmzqIEOohcyujL1Kaw/Lj4ODw4/br84fnB8lnvZz5bu+Api9a67
5aubYam09r2/SiuBbbauPW34M8qDiwmxF5tBgX+365p3NBBZ51HLOlYFv3SY
jXt2I325Y74mnCFgp++v9F0i5aBpv+DSpQ11IBDefKn/RwV0NXt+L35Dov7l
eCDrRhXsXLby8MpvNfBZIumTKsor1b0Dz8yXM2Df8IbQuy85cNhiccWoXorV
cBsc1Uu6K3qVRvXSeaPDWm1eBHjsvQrlX+nAN6dNv0WVwvrj4uPw4PDj9ovj
B8fnHi9+waiYVjAWTPfcEFEPXfst++dnoTocqnbH2qYNNvfppUxzaoE1gXsH
9B5WQN/7T+veOrKhsK+g1OhkI5gcZIsuVyGhatNM4Y1LKqDSwMopm6qH3nd6
lrqGNHB8duRsfxsJWkKXgxuEayBOUX7Smrcs+GUU+EFrB5ojtrvQhHSZ8FSi
VH9KLBuu6GmdVvlNgMDCc2mefEgX/bV7YtgQB2xMQoYopEub/noUG4d0aWX0
tTMdUymsPy4+Dg8OP26/OH5wfJJ3Qmzlnb7A3AHW1tiHZdDqVmGucqUUtvxV
nSbB+gqZ398tWnnhC9D6N9v2ZVXCqx7lkYfljTDYLNf16NBniHhHpCexSSg4
lexwEOn4NraKi5UlG754y7/suEGCyfkBs2NraCBblzbd7H0N/DA4+E1zLhM4
ss8VGo+Q0KERw5R9xwRz1792HORnw+HHngmnxUhwM1H3Oy/IgJSu3Nez+jjg
dHLrr3uZBDhp6gkYoXX0UtWvL5agsP64+Dg8OPy4/eL4wfH533ad/2E/7tak
JCH5FUzsehgfhZvA8GpmoNj8SiioEhN7CM1wvkh9duqTZvCPTLxnXk2DhY9F
L0MBE+b25of617PBvDBfqAjVKyOhVJnu/TTYfkTEyVqmFtp9nt8+c54BSdmp
mocPk6Dw8lPfm9dMCI4K+vRNnA0cRtj9bb0EdA3N8vceocOR6Qe/248gna+6
wLsmnIDhpFmJT1FfI01F9VRmUFh/XHwcHhx+3H5x/OD4FHC/szVjJwkG0k0m
niuY8FzVaOu+a0iPmbxxnbOfhOKaOZc2H2SCQkfiq0d2bOC7esfd+BMBgqEx
34PR3MoSoz8XQXPrxV32a2JsCJiu6Bv7FM1ZR6tmbT6E5qyZP2hqt0VIeFI0
53A/6keGx/p/qvRzwCpa+JCGNQlXlq0g1OMZENpQl9+BdBDOHxffeNnBjVu8
CQi0H1CnUN2Odlm7uwTV7XnKRkvM/yZg1tuOJ1aobgfyJb5snILmO2rPh33f
0Tz+6vIqPnQuHpO23Fblw9txcXDrrla55ik1iYQ9NZOL9BH+vgNvE06g/psc
7hvrW0OATBf8ev8bzZsyz+4MClGQeJxdoP+SAEt++HXlBx1sTQ/vNJRC93TC
PlNvlFdyU8SKbqG8EhCbJmQ0A2/HxcGti8MZ6ZTCP8mHhJ+T9c3lHyAd8LR5
8JgyG6am57cvXUbC35P5X26TYoBD2Hb/inoODF/QC6fXozlgiYv8mkE6qLav
15RD8dcOZ2/64YHwZD4R3IH4uSx0n/1SDW/HxcGti8NJxJVnDC0iYUFnSaOK
JAOCPqyNl+ZwQNst8nnuRRKatUrSnhmzIN/mSVRwYz2Y56RRxu0kLHlMyuhN
rYHkC7cjrj9gYe+F583t9+1Qn6p8MS3pMOpT11p0b/ujPjW5yV29zqgc+OZV
pd96WwcOw0qtUbIVwHdzoeGnAhJSvr5SkOmtAoOp4elis9A6JR3qJqI0cL/S
uCHbsgbSevWM76qzwH8Ns/BKAqqj6xVrWEuqwLXzyIWG/FqYUrx/xshzEkqO
T7FOt6wCG7+BeylhtVg8pz/euNCE5kHRnIb8l2gelF63aqcSmgdx9/dy0C0L
qRU0eP3ReY9Pcg1M0HBbVW7HBHW7pJLbJ0ho7OvPWM9hgryZ9eOJbxrggYFf
YBKa0ytf9G6rn8mCg6lHm9WXNEDByUUr9FaSYJ5sUHBelgE370s2mVRxIK9B
u/L0TALaT4cMhiMdq3PW8Z3KcgpSA2xSt50goMieJvAYzbNTRc65RipRYLkr
xL0d3TuTr4YBu9G9ExQ4fPwtundf2iY3mTWXgdbWUlYWmoujRnovWqG5GFdP
TB60lS2KJmH7+XMdT0pZcDt5ZLg5oQ4EBzyG5VVJcPRjJM9B/Kw38Vsr08aB
4uyjQs6SJISuq+3sEUL55mOicrGHAy+ZGuFnlUnIho9BKaIMWKutbduO/P8O
zN2kX0EAw5qldOUXHa7rhzvNF8bjbDFPdfWxIiCn5IzPIlTHsqcd2GmuQ0FE
l8dz8+sE/OzdGmT9nQ6dcclvu+UpMOjdoOK5joC31LsQwWY6hC72zPKcR4FM
4ZcWWzoBPfefXG1A627x07eJmYTmXyUJq/Z56LxW+V94KMGA1cc7RYoaOXCg
k75/8S4CrJVFi3a20cHRiFN6SoMC8TlSOvJHCNg//aEru50OE7Ze8R9WpiB6
SZ+vbDEBpz7k501FeaITezeHg/LkqlpHxKY8AiT7/z4n85MOdRfpiUniePyT
SlWWctIIWPvdPY2BzjHTY2ZlpwR+X78WXt+e/YIA1TcVWx1QHftg6r00DtWx
7amtB7N6CJi3dvJjO1SfJWhLtYJQP/WlFbqbvidAqepRzlmEJ3OlrNBnMQri
rN9OznUmIE/N8JdmKx0mvhDpy55NQcqLy78evisDkfPyX6aU0+HVM+WjdzZS
oDp1v8jW2jLY2yS035RBB7tdocG9ZhQMMTRnl8oSoHOffTitng6xLNfEeAMK
QjptiZUHCZgxJemhNuLtiuWpIjNU/3F4BL6ZP4vIQPwUqJrKId10li1w+4QE
fl8ly5QaDMVJ2PDEVyYb6bTuSC1O2g8OnAlc9toBzR25WyUqWQYMeLX/2PSm
FxxQaZ5VMOV5GTjPtc62JejQUuAwIXwLBSv1HFaJTUHzY6KHfkYdHcrDNt/y
WUlBpVyMd9l9dL9KPw9Z9NDhoYoZx16WAvenuv6CcQS4dlz/ZovsL/Wtjpsj
O0drlcM5KVRvf0jZrp/IAOFdT1+0dnPgQrxN3SjOuHUd0qM4PwvNokZxWrX6
rIy3JYGvsDn2UyEDamudJdJk0FyfHnPPZSsJ+yOWHheZyITNOY9Uo9G87nbL
smNdIgmSg37+ZqurQP7G4mKzJ7XQZXZw9h7U98VvuCTeR/fFJP5QzmnU9+f4
txSHbUBzYbV6VxvKHzOrGtFP6B7F2txczR4iIDdVQoCO6qGCyddCcpADM2ID
Qp5JkHDU+AXhi+61/PHLUV69aL5o2TLRAOF5lPtTik+ICWXzGnblEWzw5STt
FkZ1T5I5W02zDtW9uEkv9HMaoOzR/A6h/DKwi/wgFI7yJ2dRGn+qNQUTe991
xI6UgUKv9Uq/GjqsVHorG26M8nzVk8DiRALmm5motKF5pyVPleOB5p2Vtdl/
H0gug4SVfHUV6Lz61neHPdmM8iqspnJAhICgHMuQwVp0L4Lk1pcaUqDZISMl
nkWA/oevTRtQ/qT+cCmSQ/lT4Bo8xEDruu/YND8ArSs3b3bSaWO8PYW+q+SR
JwHSZnnX4lD/HQyvf2SE+m/RtvCU++okeMjEurSieli4ecON9BYOJGROVimo
ImBBmcC+80g/5Mw5xfKeSIHC2YMPXtgRkHzex2JPCx3C7i5+LK+Nt+PilK4j
px10IWEpp5hNTGZCgH3/5qH3bNidLXJtkiIJkzq/2T4XYUDIHLenRe0ciD31
5ufrBwS8NjEOuI7yU9AnyIgpQ2HtuDg6grbb88JQ3vq9evZqKwtWyOt/0XlQ
D1Fh161eo/5Fpjtcmz2dAYIGmdOBzoFXl+9suE8QcH/FLQkRVG8XnT1voCZC
Ye24OJUbvWyXJpOwvN4jo8QFzf3O0Y5T99aC19xnjpGyrVCtvdAtrK8aVOln
qp6U0rC6PaedJphqTEJrndKV+UsZ0JTepyeZinB2bu2eX0TAQxGX1SWo/hQ8
iN++A9Wfk4PGBwSWkxDtui2vGeko05iFMfV1eP/l4YUnBp8QkJHnouyE8nZg
cIeatzSFXRfnX+X0wLIrlwRPCVFT+4YqSCvOCxayqMHiwfFQHrDT+O7sFmDL
Kra/T6mEbtGqMzGoz+F0UU1hdVehNQ3MP+tGt9XUQPRT8ao3gwysDtl8T0a5
LpOEVSeDa0PSq+BQQvZw7N0aUDlu05u+mIS1rwzOOCA9qQ7xZBKbA/INhTGj
daxv+XTf0Tq2fZ2n9mgd22ZjEi61DtXt155e1jsZ8G4my7EtkAOaYbnkBRoB
68qkw61Rnlhk2d26j3SC6gTDBs0yAq7sunSAhvps/EufKRdR/jA7dpzL4idg
w/CpF4Xo/j70eSM2AhT0em7PtJFB9VzHmRWI+pFKlP1psRUULPRynuO/HOX/
ebk5PxvpMINze6/6QgrcqKG7xellMNFogo4DDfU743V5zTYU1Hoc9QgQJuC2
83B7AaozFvUvZi0yokDOIFlJ0p+AY6L94c1Ij736aKGthvTYhWW07i+aBBw4
p85vyEFz/ymlH9OWoj67yfRvMxYBH+xPfbJE93pV2+HESnSvN3qsuPVtMwk2
9lozVEgG9K+4/sVVlAP2MSKqguWoTiYNKeZX0mE+B2z/tqCgLF6P2GhPQKNP
j8ppVDcklh452KFFwezyUjXF7jJUTx7lHq+iQ7qx7jctEwpixDNDBLUJuDDg
7BuG8MztFvt6YQkFgpnn36WXEiBqczYsF/EZNPFe/UPEZ7J8mI3fRQJOrwq+
ee0bHQKuvnCYrkBB2+8s6VEdknM39+KoDmlaL5o7qkNw/meXnZhUooF04Fx2
vrE4A6zc76kpoDrZPZRWLFdLwGJ1N6IO8cC4edOdhuaX6mGxlNYrBIRYheyk
oXlNJlNrYdV0CutfWLnzcOAmEuRKpI4EZqP+zgqV+KrIAfbv1bFlaF5DSnnH
ATSvUUxdlhya1xzkfm7ckE6AoUFDdDPSV/3uP4XKUV/A+VPlKQsNvUmwTODs
vHeBCQMyFme+GbGx9ytbOeqsG4pzelFUtDWKY6PV4muN4hT45xnbIJ0mOHjv
mBnSaaDaLPQO6TScv+MlxR9Gx0hQ2xRJ6pJMOPOx+nFvbQO2vm3PWRjTnY10
F9S530D9bt/5i2o3JlNYu3ecX8qoLoroiSkb1UX3FU8rjeqi4a5B61F9Xjfv
wH/qc2lBC+dRfY6z4+KY5Pd/SHMiIfzycJziLwZM3h5fWFHDxtpx+6r/vHRL
E+rj7m8Yzz0RfuOWM7PrEH6cnfG3opE6qquFw2H2K1BddVu/OvcJqqu4+Dh9
viU0N33NPQJi94g97uhG/XdZSZqQHF6X4uavN7Mi7l/1I8CAwRmZhurDh6ij
8beU8fNIo7/Aoww+ErJ6/aWd+Rkw90n0l5rfHNiZzm5dI0TC09Z7qS8FGJCb
LBhyYIADW0NzNJ3qCLDq1z0xeZAOfJcfDRxH98JX/JDWasTPIXMx1maEU0a3
eKuwBH5euDRT1stGloSiF6sc905iwOveBWqNXRwsD84nv2naPSQg+67C5kSk
H2z8lYQTZfBx+P1tFnSzCZilUxJ2HeG0kRKZcV6Qgr1z2lbqaJGQZ7ospAfV
h7k77Saxmjkwcf+57sgAEryEVyYtHGZCYvxE1e4jDTB03XpQBekiVeXQG16o
DkgGOovfmYg/d5y/5scDu86iOmC2fn94Jzqvs0r77+ZL/O88afuvPJnqZHd+
VOffMejoGtX5iYINfqM6H/cei8OP2y8uztzgBamyb9Fc5jtt4TWEU69T6K+9
KK+sh2xfqUUS0JkyXyQSzY/VqewXvvJ4/Lg5ndu8wp077nxxPOPw494N6lia
A5nSJMQQoXO70Tz1Iuzz4ozvHOx7C05XMLvepo7q9qklq7eN6vYyO83ro7pd
9w5ffvduEuwCgrbn2DBBwYmQvHyMDcH+AlprGSTwx4srkIeqwTsrfpKQUDUk
ZPeETn1NwO7tVisG0T1KfSTRfVySwsbB+c/bmruUKqaBcGHuox1ltbBfW7kj
gI+OtePwcJJc1qx9XAGiO8RWScxpAOLCbpFFqjRsHJz/5ZK3TwPjWWAxlPnU
VIMD4pFtAi7NBNf+uHX9Fj9Qmvy4Acy/eovkLGgETTbTdKogiY2D8+cWD6/W
HWt/Xu2XV+fFq7ziVZ6P9X3ktg7g7NzG4ZYfHM/cxh/r8+WVP7f7Guvzwvnz
Kt+4tY/1fseLN275HGueuV3332rn1blz6z/W+Hl1L3hV58eaN17tl9t9jZcu
5Rb/eM0F45W3f9p58Urn4+xjrUPG+ty51T/c7hdnH6/5aPp//b9n/v/4f8+4
PqcVG/O+QMTrmf6fdn8B7zPet41OlHPtz6t84xX/f1r9Ga+6NNbvG/+U/OTW
3/mwYoJ2cBucTH2gv86wBSI1H8XWlFTAjtutLrPpX2Gq1PAa8uIXUA/Q7arN
qOTan1f88Ooc/631mVf9Ecc/t+fFbZ7wKj95Fcd2ICZCePJX2HPV3qYT7e8V
MwPqdSqBsThoR+TzVnj21XqDWV89vFbc5LeLWc61P6/qw3j1I171nbF+Hxvr
92Fe1WFu82es83ms4z+PA70ewRbI8buzzPJjBUgs1osRpgisfaz7Gq/y4U/T
b9zGHy8dxe15jXU+4PKQV3nObZyx3u946TRe5Tmv5incvsZa53N7Xrjv+Dg7
t/qT23v9p30nHa/vxbzik9u54E97v/23fjfkNs54fQfk1feI8fruySse/inf
v8Y6Pi6f/yl1g9u+M17fv3i137HuR3/a96Ox5mGs9RvOzq3e+KfnLa/0IY7/
P+19G4eHV3qP23Mf6/vIq++qvLpff9q7Lrf74lU9H+t31LGuz3/avR6vd57x
es8Z63lnvOrPePURbt9h/inz13j9fuD/mp1XOvxP+13HWOc/Die370W80lG8
em8Z6/9f4Pb/j/6032//ab9b/v/6+e+w/9Pr5///H8S/+9zHur6N9XdwnE7m
1v9Py1tevduM1xzKrT+3/ZFX3zf/tDno/1p/55ZnXH7yal1u68afVs+5/V0H
r/jE2XlVt/+0vP3T7gWv1uXV74K4vS/jde7c8vwfS3Yr9A==
    "],
   VertexNormals->CompressedData["
1:eJx0m3k0VW/0/5UimiMaKKESEpEotRUiUyUVJZWKytSsNCtRIkmjSqRSZCgy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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 286.9624680486638},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}, {0., 2.5919990948572433`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{-2.760463491860404, -1.0602194233315643`, 1.6449243400522604`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.421025047259*^9, 3.42102506255*^9}, {3.42102512574*^9, 
   3.4210251901549997`*^9}, 3.4210887572706003`*^9, 3.4210904760338*^9, 
   3.421090514597*^9, 3.4210905853898*^9, 3.4210906173542*^9, {
   3.4210907310626*^9, 3.421090773947*^9}, {3.421090853117*^9, 
   3.4210908677654*^9}, 3.421090933847*^9, 3.4210911191594*^9, 
   3.4210911576914*^9, 3.4210912148654003`*^9, {3.4210913627222*^9, 
   3.4210913786654*^9}, 3.4210914669146*^9, {3.421091557925*^9, 
   3.4210915982978*^9}, 3.4210916323682003`*^9, 3.4210916771870003`*^9, 
   3.4210917132542*^9, {3.4210917454058*^9, 3.4210918505654*^9}, {
   3.4210918971782*^9, 3.4210919154302*^9}, 3.4210919471138*^9, 
   3.421092052679*^9, 3.4212889947432003`*^9, 3.4212898108302*^9}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1mwVUVN8X70FRxC7EQMIObEIwjgGigAGomFigoqiY6E/ERkUFRQEJRaRD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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmXXYVsUWR8/MMTGx43oRDAxMVEwUFTGwsFuxMBFQERVUwO5GFMXubsXA
7u4Wu66d17hruffzeP8YZr3zzfuemL1/O+jcf2C/fWvTNMvzT8v8G6MjYx8+
31ia5gT4SeYb+bw4vDK8ImMxeCPmW1hfEl4NPq+J/ScyLme9O/Oa7mGcBD/D
fAbrC8CLwEsyusKLMd/O+tK5fznGovD6uWcheB3mDbw2vBPzuk3wSoyr+O78
+ZvrMZaHt2e+p8bfN4bvhVeB+8H3w6vCm8MPwr3greD74J7wpnkPi8DdmS9h
fal8xgvhJf7vPXSDe+R1e8BrMz/Ano3hveCJ8EbwHnn/K8B9S9yT97Yh823s
WT3v4aa8t03znffMe74ZXi3v2fvfEN4dvhTuDM+f978BvBu8A2MteDvm41if
F+4E7w/PCk/hmcBd8rtzMf4Fz868I4YwDzwnPAtjTngG5v6MteEdmXdmrJNn
4XteD94l3/P68K7w18wfMT5kTMWYmjE964eyZ8pcO5lxGONwxik5H8F4nz17
MR+TtjMi951fgm9m/pY9I+EL4Gt9TvgR5h9YHw1fCH8Hj4LH5zvpA+/H/GeN
/TfAo0tc6yzmnZo4u36Mp/NZfJ+P1Xh238Gz+Z59/8/lWXi+L8CbwYN8P8yb
eI6M59MGtIf++dv+bZf8u995iz27++zs0SFngv9kXMnnY5kfYP6V9aPgy+CP
4f19f/BH8BD9Dv4EPgA+Fd6iief1vk9nfZY8d890Lnhp5hNr+LvX0gY89+WZ
L2K9U9rM5/BQ+Az4J/hI+GL4U/hA+LQS5zC4ifsYy+dDmK9REzxv+HrtoQaP
gz+E91UvSpzrQM+F8QHr+zAfX8IWXBvEmMT63szHlbCPQXm9s/l8MPMVni92
OyP8X8YB8Ke+c+ZtGM/Ba/EbM8LnwE+wf3r4bPgheAZ4DPwY/I2+B8/K2n/g
G+CZ4S/h6+GO8F/81vHwTdoD43xYAX1DnwSng79izzB4jHbCuAAu/maNez7X
91ziTD9j7Y8aZ30dax1rXHch9u/D5zW1bdbuUkPhH+Hb4dPh7+Fb4VPhb+D7
4LN8D/DvjGPgq1ibwDgT/oW1S+Gj4S/haRl3w8swP6/G+Shc9yX4YnhKeIsS
Onkre7YsoVfq1tqpe9dq+yU0Sq3apISOqWfev/b+MHxSCft8HX6FsS08jLWB
Jfzg0RqaqDbeAL+q/sId2tBN9fN61reG14DvqKFH2vgEbaqET/mu1oKXha+u
oYPq4d1eE+4N36VNlfDHh+Bt8j3fCQ8o4bPq954lNEFdX7dEfLkOfryGBqqF
K3B/98IzGXPg++BZ4KnaOK972FPb0Ljb4Mng07x/eIo2zvFueJo2zuh++Jom
Yuo4xuN8Hsv8IfPTJdY/Y36KcS78iRqYe7XFB0vY89vM1+Wa9vcpn6/yTLm3
2bjWRfDLanwbZ/2acaCNd/6mWtGGPbwIzwSPh1+A32Fcro0xf5H3Og2/+RF8
JTwZPAm+QpuHP4evhqeGe/A798Azwo+W8Mf3mRdsw7++hn9n3AbPy55F2vDH
71nrCd8Pz8Z61QfgruYgrN8M/8qeqfh8J7wEcwd9Rq1jnpxxB7wo82Lsvwn+
SbuAH4DnMY9o43195ZnDT8EraPPws/DqXovxGLy5v+MzwJvU8FV99lu+uzCf
H4E3Yl6W8QS8DfPO7HkYXl9/gZ+Bexr/4YnwnHB3bQveSj9i/Wl4JfiUEnr7
Jvwko28TcXZwav2IjDtDUhtfz1hgjPC7xpe30gd3g9+AX8s4Yuw4IvccxvwS
63vAo0pcSz89UE3O747IWOZ11OKdclavd8xZTVeTJzWRT56Y9qnt9qhhA9rC
e6mHavmrNb5nXDAGGAuOZX458wFj9SsZC8wNjAfy0fqCfg4fBD+hRsAHlPDT
reD94Wfg7eFDSmipseyn1FJzBnMH81Xv1RzDPGFs+p+ar6/pc2q1dqv9Dm9i
v7mvejsm/W9Cartx2xhnrmMus2INfVAnDm9CE/zbpIyP56WGmR94nps38c53
bSKX8P0eWiLfcG146qt7PZON8zzc93Tqgzm8OZVxeWxqXv/cZ8wwdqhL1gHq
mHq2cg1f0+eWTZvUj9rUBHXAeKGOqWdqjL6jDr2asWaajCNqoFpozFU33knd
UBPUsc9Tl9SxcfkbakrH1AT98dPUFjXQWDy+CU3qkP6upn2XMUs9+zFjh3rW
qQ09UVeM7+rebBnffRZ1bt429ERdmb7Gs6gHU6VuqGmd2+DJM26qLWqauY3n
b81kLqHuqX8z1Lh/tW21Gj6ur69ZQ3PUnt0ZH3u+zIvU0IfOzIunhizEvEzq
Rhd4qdScbsxz1NA99a976pK6t1MNbVFjzHl8b2rzDjX0RF3ZA34e3gPeVi1o
QnNmraGNauTMNbRXDd7aeNyE7m3QBm8Brw+/Am8K71Yj1zLn2r6GfqqjfRkv
y2pgDS1VU82/zcPNFfV7/WRE6sfh+XkQ+z53zVxIvYD31nfaqDEObqNu5Web
gfzzRxO17CB4ZmMqfKTvCp5O3TD2wdOqG3BHuAM8Ch7JF7/1Hpj/XSI3Nkce
pa3AQ5n753l5bsMYM2hjJe7l5yZqnqNY/9XrMn/QxHcn5fl5jsaB9fQNeIMa
NZd10rE1zsNzWddz9D5yfWDmtMOZRzO+gQ/RbkvkvccbE+HJ4QPrP7rcv/lH
l/2sxu6QGmIMUFvUdWPBLqkng/N7f8cTPm/ZRFx4sQarpUPy737npdRY9dYa
z1rviBq6vU0TsUPNVXvV82lK1H8jPDTzIa9jjDYfgofBU5eoE60XH8vrDsl4
pyZax1lD+Js+zzvsGdBEzLIGM580rzQeGBeOzrhg78Baddc8x/3bOC/PfXu1
rkQtfEGNWsiaaDy8SomayNpopRI19cVwzxI1uLX4GiV6EfYkloHnhs+He8Hz
wVfAq5aouy+rkaMuqP3DXUvU5meqY2kz2o41nXHKetb6yHgzLs9oZBP1kPWU
fmN9PCjX9B9rw1FN1MjWHfqatbL1o/HOutg6xbrDWtN6xFrPmu+g9Dv9b3ja
nnXVgiVqSWtKa0hryXE16gJ7Pubk5skLN5Gr28exn2M+bx1hn8d+j/WCfRVr
CusF+0j2kw5r/zaJv32tc4la+GTW54Nnhk+tkf8v00SuvjA8G3x2jRzenN/c
3hy+VxM9nm7w7PA56io8BzwWXqJEf+NcuHeJ3pT1Qp8SvSnrGntP9qDM+a0X
rDusZawLVm+idrDfZF1gDWJ9sVwTtYa5zZ7qQInaxLrDGufjEjHCvHdY6ph6
dijjE3hAG70Y7fAoY03e83D4Xc9GOymRC5oTWu//1cT72a+GLqgPR7Rh09q2
2mYcuRX+k/1v1zhr6/e94a/0U/4+U57pSNaG8PmH/J1Z055Hp/4bg4xFg+Ev
mtDhOdNf1NgB+Sy7Mf/exDna29iO8Qa8YfraoukjyzGehJdto6fWLX1QX7Pn
dmH62pLpd6unvdlr7JGxZrk24pFx0/i5Qolepf7bOf30BLhNX7Mf1iFt4+Aa
MetNeKM2ciFj5fJwr4xrvbTNtP/BNWLBQ/D88DypCfbbPG/P/agSvTNt7LAa
79f3bHyxL2B/4Bzmg0v0kewn2RcwH7YfZd5yGfxuiXzGWD83a0NL9KDsRb2Y
ujeyRH6iXWlfq2ScXaWNnoI+bp/EfoH15p3aF/wg3D3zH3OzD0r0F8zZrEnt
I9hPmFgidzWvWLGNnoP6Yx/OnoL53r2s/cK4Bf53G30Nc+BLWJsOngB3aaOe
Nzd73feU2mJMn7uELWlTB2XMNfZuyHe/bEKrl2gjd5qrRgxVw3dJ39HmR2e+
YZw1n7LHYa/j8hL5mPntAvx9HfgFeN028ih/0982/5kId4N714jFvdvoodhL
ubpEf8YcvmsbuaK1zHyZL90PL9yG5qt16vyUqVFDa/SG7BG9le/k2vzuqqmH
9pvNY83B5mijrr4m31vvzA361Ohb2b96uESvyjzN2tNn8xmtr30Gn2X2Gjaq
rS5Yw4615zX0hRq5sbX8FDVyYGt2n81ntKfh8/hc9jQ2hd+G+9ewG+2nU43c
7114a9b6Md6Cd1Tz4XfgXWvYufHaOsxem7WSvU3PwLPoq22W0Dd1zj6ddZZ9
3X418iVrZ/8vwVrKRG+zGrmltfaWNXJR63HzTK/r9e1hXQy/UkJ/nkwfH5q5
gbWjPTprMfs01upPpEZtlznnXjV6fdZq9vEmb6OOsDeiz+g79lt8ft/DgBrn
5zn+UKJXaM/QXmifjBHGffVFnbHPsFTGzXNTDyekpulv+p19gAUylzglY5Zx
8Moamq62mwj3Tdu2/7lo5hhnsdYlcw97/+b/PpfPZ+5h3nIaawtlHPT/ahbL
ODimhj/r17+V0CC16OcSMdT4aDz1/0v8f5PzatQa2oC2YP/U3oi9HfuM9hvV
eXVNfXuvRM2iXWlfapbatWqNvPczeF/m/wH/WzuJ
         "]], Polygon3DBox[CompressedData["
1:eJw1mHv8l+Mdxu/7eaQDIaZ0MkXSSah+jiEplEg6J0Klgw6IKBWFkUNrmI1S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         "]], Polygon3DBox[CompressedData["
1:eJwtlnt4j2UYx3/v+0NnFmMzNGTUZG3jambYsDKNYZqtdBztYMv+YQ7pJHMs
lVHouopFRqEkuipnWgcppylnHVwq57Nh+nyv5/7je93f53u/p+e5T2+r3JLM
EX4gEJgB6oJLXiCwEnsO2zQYCESAu8CdYCPau/j2YZ9i/STozc070Aqxt7Cu
B77BPwttN7YR64ZgJ3wB2insj+AH8BdYghaC/zz8c/gZbBPWYeAxMAgk8ezt
+J7DXsO/GN4S3WcdBLfDbwPr8M3GtxebiL4NnoBNwNcZrNQ7wE/gfXw38fUE
v8C7YZO5JsXe9zNaZ2wi6y6gu31DF2wS665gBHgBFIPj+Eq0V/zr4A2wbVm3
A0+Ax0EvtF/x5WGL7J7h2HTWfX33TD07FL4BX1dsY63BLr65ws5H/vXwu7H3
4bsflKFPVHzAOHxH8D1qsXkY25tr0kA+/BDaUGyOfVce92SgjcZu095BCjwO
LQv7BetV4Dv4NLRa38VPcRwOP2x7GmI5MRZ9DJgMivFV4zsKn2ux/ht+DBzW
t4DX4YX4yrH9WG+F9+W6gfBMMEDvRuunnIBngUGgCi0DLVt7AfvBPvAqz8nH
9zb2N/CR5eKtlicH4XMUI/gf8D89d77Kzx3YOuh1QR94GljGM9vhi4VHwb+E
d8LfGn4v8EAlWivdB68HsuGDQbLll867BdgED8fG4osDIfC1aPWxbVhHKSa8
p6dyA7sJfTPYAt/suW9X/tfnuiPw94wf0nlq36A/2jjsdr0bDAMHrX6y7Lue
1XmhPY0dyDoT7OeehVY/d1jN5+I/gPaM72pRNfmI5XEPbC/WqeA096xAO+G5
elfdp8I7ouVgV3PtGt+9R+9LtBrTc7finwK/7rs9aq/1QGO0dtiZ6OW+y3Pl
+1nrFY18V5uJVnfrrT6n6KzhEVwXBsLBg1wTAy4rny0GD7BuDy5Yz2uMNh1M
A5Fokeoz2AngNfAKyEHb5bt+kmDxW2e94i0wQ3HkulbKB+zHYBK8Avsvvv/A
KDDSd3sMxeepb7GeBaLhbWzf81TflncdQIzn+klbO+/PrAc0sX6h84i2PX2C
fyzaSbQl8KWeyy3l2EmLlXpULfyGvtfqTnndx3pFpOKBloZtZrPgd8uRi9h7
WLcAB+CL0K5YDioX1adXo0Xij7dcr0FbhdaM55UADZ5a7QHUBFyuKmdf1Hyx
frQCjIef9l3vXmk9rgjtKNo89XKwwXr/t9ir6DW+q2vVt+pzjc2MtTabvsZe
Qr/su3lVjrYGe4H1RTABRKCFojUAIZ7Lc+V7hNVxKna5cgGebr1CPaPSevAp
fMvgyz2X+6oB1XYPfNmeq2vVdxF8AFqB5/qs+u1geDLaIOuV6pl10L+yPqOZ
c8TmbmHQzZF3uGaUZrnn+qD64cuqF7SXsKNAKbipvLTYXLf4K99boiWpD3Jf
BfgHHAcz0UZbDl+1+lH8m1v8O8MTwIdc29zq7oqd7ULLf8VFs1UzNgx9I1qK
5XuUZhR2Ceulvoun4vqp5+aNznGOep2d7VTL67NWA/qn0IzUrNRZ68w1qzRv
bvgu91UDmzzX99VnTlgtzkYbg7YIGw/ilE/oTS32ys+GVstvoL+p+ra+P4z3
HcOXG3Q13xqerPrAt0jPsH2qr3Sw/nPNcnMx103Gtx4brd7muzm3x2ZfqcVL
/wk70YotDqU21w6op2vu6Fm+67Xx6snYkfZd6dgMfP1BHnyLfWs+KAi6b9S3
atbH4uvuuT0NDbo5vNue8QG8Pfwh/B1BJ/A9qPLcXK+0WTpf+1QPtnxQXhTY
+54HZ/CND7r6Up0twF9mtRije30316tt1s9FH27/Moq9cuA8/ByYD59oNRvH
OlY1A/baP4HyV3ncVc9G64YND7r/ymrP/RPoH3cSGALf47v/pzLLk6mWO1W2
1/8BHY1dqw==
         "]]}]}, {}, {}, {}}, {
     {GrayLevel[0], 
      Line3DBox[{246, 1, 895, 242, 227, 251, 16, 288, 31, 317, 46, 61, 76, 91,
        390, 106, 409, 121, 427, 136, 453, 151, 480, 166, 511, 512, 181, 549, 
       550, 196, 870, 231, 248, 211, 244, 883, 236, 591, 590, 212, 594, 593, 
       213, 597, 596, 214, 600, 599, 215, 602, 216, 604, 217, 218, 219, 608, 
       220, 610, 221, 612, 613, 222, 615, 616, 223, 618, 619, 224, 877, 878, 
       233, 901, 249, 225, 245, 237, 620, 210, 585, 584, 195, 540, 539, 180, 
       504, 165, 474, 150, 447, 135, 421, 120, 403, 105, 90, 75, 60, 336, 45, 
       313, 30, 865, 229, 247, 284, 15, 243, 235, 283, 14, 13, 12, 11, 10, 9, 
       8, 7, 6, 5, 4, 3, 2, 880, 234, 246}]}, {
      Line3DBox[{251, 863, 621, 250, 623, 253, 625, 256, 627, 258, 630, 261, 
       633, 265, 636, 8, 270, 641, 273, 643, 275, 645, 278, 647, 280, 648, 
       281, 864, 649, 865}], Line3DBox[{283, 882, 890, 896, 889, 284}], 
      Line3DBox[{288, 651, 286, 653, 254, 622, 252, 624, 255, 626, 257, 629, 
       260, 632, 264, 635, 267, 638, 269, 640, 272, 642, 274, 644, 277, 646, 
       279, 282, 312, 672, 313}], 
      Line3DBox[{317, 674, 287, 650, 285, 652, 289, 655, 291, 657, 294, 659, 
       262, 628, 259, 631, 263, 634, 266, 637, 268, 639, 271, 276, 306, 669, 
       308, 670, 309, 671, 311, 314, 336}], 
      Line3DBox[{390, 389, 736, 407, 424, 430, 765, 455, 481, 486, 801, 517, 
       555, 560, 598, 602}], 
      Line3DBox[{403, 735, 405, 747, 422, 761, 444, 760, 446, 777, 472, 793, 
       498, 792, 500, 811, 534, 830, 572, 828, 574, 853, 609, 852, 610}], 
      Line3DBox[{409, 408, 749, 425, 450, 456, 783, 482, 513, 518, 556, 561, 
       846, 599}], 
      Line3DBox[{421, 748, 423, 762, 448, 779, 471, 778, 473, 794, 502, 813, 
       533, 812, 535, 831, 573, 829, 575, 854, 612}], 
      Line3DBox[{427, 426, 764, 451, 477, 483, 800, 514, 551, 557, 595, 600}],
       Line3DBox[{447, 763, 449, 780, 475, 796, 501, 795, 503, 814, 537, 834, 
       576, 832, 578, 856, 611, 855, 613}], 
      Line3DBox[{453, 452, 782, 478, 507, 515, 552, 558, 845, 596}], 
      Line3DBox[{474, 781, 476, 797, 505, 816, 536, 815, 538, 835, 577, 833, 
       579, 857, 615}], Line3DBox[{480, 479, 799, 508, 544, 553, 592, 597}], 
      Line3DBox[{504, 798, 506, 817, 541, 838, 580, 836, 582, 859, 614, 858, 
       616}], Line3DBox[{512, 510, 820, 546, 867, 589, 594}], 
      Line3DBox[{539, 818, 542, 839, 581, 837, 583, 860, 618}], 
      Line3DBox[{550, 548, 866, 871, 869, 884, 591}], 
      Line3DBox[{584, 841, 587, 874, 876, 877}], 
      Line3DBox[{590, 843, 868, 547, 549}], 
      Line3DBox[{593, 844, 554, 545, 509, 511}], 
      Line3DBox[{604, 601, 563, 559, 520, 516, 485, 784, 458, 454, 429, 750, 
       411, 406, 388, 725, 374, 715, 357, 702, 338, 689, 316, 673, 315, 675, 
       318, 677, 292, 654, 290, 656, 293, 658, 295, 661, 297, 663, 300, 665, 
       302, 666, 303, 667, 305, 668, 307, 310, 333, 688, 335, 337, 701, 356, 
       714, 373, 724, 387, 734, 404, 746, 418, 745, 420, 759, 445, 776, 468, 
       775, 470, 791, 499, 810, 531, 809, 532, 827, 570, 826, 571, 851, 607, 
       850, 608}], Line3DBox[{619, 861, 617, 873, 586, 840, 543, 819, 540}], 
      Line3DBox[{620, 886, 894, 898, 862, 902, 901}], 
      Line3DBox[{870, 872, 892, 900, 891, 897, 883}], 
      Line3DBox[{878, 879, 893, 885, 875, 588, 842, 585}], 
      Line3DBox[{880, 881, 888, 899, 887, 895}], 
      Line3DBox[{660, 298, 682, 323, 680, 321, 678, 319, 676, 320, 692, 339, 
       690, 340, 703, 358, 717, 377, 726, 392, 737, 410, 428, 432, 766, 457, 
       484, 488, 519, 522, 562, 565, 603, 847, 605, 848, 606, 849, 569, 824, 
       568, 825, 530, 807, 529, 808, 497, 789, 496, 790, 469, 774, 443, 757, 
       442, 758, 419, 744, 402, 733, 386, 723, 372, 713, 355, 353, 334, 332, 
       687, 330, 686, 329, 304, 301, 664, 299, 662, 296, 660}], 
      Line3DBox[{679, 324, 695, 343, 693, 341, 691, 342, 704, 359, 719, 375, 
       716, 376, 391, 394, 738, 412, 431, 434, 767, 460, 487, 490, 521, 524, 
       564, 821, 566, 822, 567, 823, 528, 805, 527, 806, 495, 787, 494, 788, 
       467, 773, 441, 755, 439, 756, 417, 743, 401, 731, 400, 732, 385, 383, 
       371, 712, 354, 352, 700, 350, 331, 328, 685, 327, 684, 326, 683, 325, 
       681, 322, 679}], 
      Line3DBox[{694, 345, 707, 360, 705, 361, 720, 378, 718, 379, 393, 395, 
       739, 413, 751, 433, 459, 461, 489, 491, 523, 802, 525, 803, 526, 804, 
       493, 785, 492, 786, 466, 771, 465, 772, 440, 754, 416, 742, 399, 729, 
       398, 730, 384, 382, 370, 368, 351, 349, 699, 348, 698, 347, 697, 346, 
       696, 344, 694}], 
      Line3DBox[{706, 363, 721, 380, 727, 396, 740, 414, 435, 436, 462, 768, 
       463, 769, 464, 770, 438, 752, 437, 753, 415, 741, 397, 728, 381, 722, 
       369, 367, 711, 366, 710, 365, 709, 364, 708, 362, 706}]}, {}, {}}},
   VertexColors->CompressedData["
1:eJztm3dQVMnaxlFRQQUVs4IBEQOCKAaU8JjIqCgiEsW0mBYEswRdF8nqihkU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    "],
   VertexNormals->CompressedData["
1:eJx1uwk0lW/3/y9DZhpIGkhpUmlQomhTKIo0IJEGKWOKDIlKhspUppJCg2So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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 286.9624680486638},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-0.4, 0.4}, {-0.4, 0.4}, {0., 0.20266660266667252`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{-2.5314768316890217`, -1.5135982088601059`, 
   1.6585070131769704`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.421025047259*^9, 3.42102506255*^9}, {3.42102512574*^9, 
   3.4210251901549997`*^9}, 3.4210887572706003`*^9, 3.4210904760338*^9, 
   3.421090514597*^9, 3.4210905853898*^9, 3.4210906173542*^9, {
   3.4210907310626*^9, 3.421090773947*^9}, {3.421090853117*^9, 
   3.4210908677654*^9}, 3.421090933847*^9, 3.4210911191594*^9, 
   3.4210911576914*^9, 3.4210912148654003`*^9, {3.4210913627222*^9, 
   3.4210913786654*^9}, 3.4210914669146*^9, {3.421091557925*^9, 
   3.4210915982978*^9}, 3.4210916323682003`*^9, 3.4210916771870003`*^9, 
   3.4210917132542*^9, {3.4210917454058*^9, 3.4210918505654*^9}, {
   3.4210918971782*^9, 3.4210919154302*^9}, 3.4210919471138*^9, 
   3.421092052679*^9, 3.4212889947432003`*^9, 3.4212898109292*^9}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1fXlcT8/3f0jWFCmJtC/atL1eJdTYQtklZUlRspQtIlubKJVSSXZaUJJU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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNnHW8V0XXxU+LCgYKSkiJKHaDAYKioIKKtEqHKCVioQgCgoAtNoggtmJ3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         "]], Polygon3DBox[CompressedData["
1:eJwtmnnAlmMWxp/3fZ7n1UiWkmj/kqgkS5ayVGixpTEzIUmMkSVb1rGOsZZl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         "]], Polygon3DBox[CompressedData["
1:eJwtlG1MjWEYx+/Tc5+mVszrypY55S1UG/PSOtiOvEx8KUybjBrjg06MOIYy
E7G8FtlkJJ98KDp6sbHU0kSiMzIq60xrZDYkbXzwu3Y/H37n+t//67rv5349
rmxvem6IUsoDTojnZw7ME2jXWEo9g1Z4r5UawDtBzKd9EPJA+m/D24/eB+Po
m+BQKgsvDdZBK7zFayAXHapUIp2mEuto1zvN2MsYp43+79Dd2viSb4Rucmvx
KsnfhpswAc+LlwPZcBYvCu808SV9XkA7dOAtIr8S7YEm8il4BXivIRFdj/cK
3QkBSMLz471Bd0kd/YLMv5O4nPYKKCRfAEeAptrBTwb5dOjCS8MrwiuBTHQP
Xj8EYRU1qdCMdpMrpOYjDKI/EBvxH8EgNb/47gPLzF3WEC5ngxdGHENtGPwm
PwwH8G6RyyfW4FdDNPgZd7Y2++ZC59pneAi+UDtMn1rLzEnm9oT8Y4iHFurd
xDvk49B52qxb1r9Y9gyvgRgLcRAB5XgnGecUFMEmvI3Qge7nW8+18SXv5B5E
cR808TxjlsA0/CXUxRDP0A5nvGLLnHOOvWZZewj5GdRVoC+TvwSxeMl4LuJx
2pPsszmKPgZlUAqzyKdQN5OYSX4LbLbX067NuU5Eb0cfRvvAgS7D+ydrhOsQ
ybyny31G32CsCiin9hrMRbv5xien2RvZIxfUMMY9beYwFn2V2t2090Af3pDd
R96ivEk/BPBayK+GNdq8vfHKvLNIGQcy0L3K7K/cf3kHfdT1wme8YXIDxCsw
hfFGiT/I/YRaatvIp+I1a/OtUvDhfbXvl9wzeY/yluVNr4cNcF/uPN5TtEfe
mjZnGEHfC/TZSXsXjKL/WGbcYnIj6G8wBHupP8cYXqeplT4X5X7i9eAtYJ+r
2eeFoeY/Rf5bRvAdeAHqtqKz4C5+lTbvpIpvTEZ/R/+V/bPM+5R3moy/VJs7
3ERdI7GO/EPL/C8E8XzEBGrnQxLE2Gf1H0Puqog=
         "]]}]}, {}, {}, {}}, {
     {GrayLevel[0], 
      Line3DBox[{808, 1, 729, 302, 16, 31, 951, 46, 967, 61, 981, 982, 76, 
       989, 990, 91, 996, 106, 1003, 1004, 121, 1015, 1016, 136, 1027, 151, 
       1037, 166, 1051, 181, 1068, 196, 475, 831, 211, 786, 1471, 474, 1089, 
       1088, 212, 1091, 1090, 213, 1095, 1094, 1093, 214, 1097, 215, 1101, 
       1100, 216, 217, 1477, 478, 832, 218, 858, 480, 1105, 219, 220, 1108, 
       1109, 221, 1111, 222, 1112, 1113, 1114, 223, 1115, 1116, 224, 1491, 
       1492, 483, 1639, 833, 225, 807, 566, 210, 1084, 195, 1063, 180, 1048, 
       165, 1034, 150, 1024, 1023, 135, 1010, 1009, 120, 1000, 105, 994, 993, 
       90, 987, 986, 75, 978, 60, 962, 45, 30, 318, 810, 15, 788, 1504, 492, 
       921, 922, 14, 916, 917, 13, 913, 914, 12, 909, 910, 11, 907, 10, 904, 
       9, 308, 809, 8, 843, 306, 7, 899, 6, 897, 5, 893, 892, 4, 889, 888, 3, 
       884, 883, 2, 1494, 1493, 484, 1634, 808}]}, {
      Line3DBox[{883, 1118, 886, 1134, 928, 1234, 1235, 952, 1241, 964, 1153, 
       966, 1248, 982}], 
      Line3DBox[{888, 1120, 891, 1135, 930, 1147, 954, 1243, 1155, 970, 1250, 
       1378, 1377, 1160, 983, 1254, 1383, 1382, 1162, 1253, 990}], 
      Line3DBox[{892, 1121, 896, 931, 1333, 934, 1351, 1515, 1514, 1352, 1569,
        1570, 1366, 1578, 972, 1519, 1367, 1611, 1631, 1632, 1520, 1633, 1368,
        1612, 1156, 1369, 973, 1245, 1355, 958, 1149, 957, 1341, 1508, 942, 
       1140, 941, 1311, 1499, 1500, 1126, 1310, 909}], 
      Line3DBox[{897, 1297, 1496, 1495, 1300, 901, 1334, 935, 1336, 1337, 936,
        1339, 1340, 938, 1583, 906, 1122, 905, 1307, 907}], 
      Line3DBox[{899, 1299, 900, 1301, 1303, 1302, 1607, 902, 1581, 1304, 
       1306, 1305, 903, 1123, 904}], 
      Line3DBox[{910, 1309, 908, 1124, 1498, 1497, 1308, 940, 1139, 1584, 
       1635, 1138, 939, 1354, 956, 1353, 937, 1338, 1507, 1137, 1335, 1506, 
       933, 1332, 898, 1298, 894, 893}], 
      Line3DBox[{914, 1313, 911, 1125, 912, 1312, 1141, 943, 1342, 1236, 1237,
        1356, 1246, 974, 1157, 975, 1600, 1601, 1599, 1598, 1602, 1527, 1379, 
       1603, 1380, 1386, 1164, 1613, 1642, 1614, 1615, 1261, 998, 1262, 1616, 
       1263, 999, 1388, 1264, 1167, 1000}], 
      Line3DBox[{917, 1317, 1319, 1502, 1321, 944, 1142, 945, 1344, 1150, 959,
        1358, 976, 1361, 1523, 1524, 1371, 985, 1374, 988, 993}], 
      Line3DBox[{922, 1325, 918, 1128, 919, 1322, 1143, 946, 1346, 960, 1350, 
       1517, 1518, 1363, 1158, 979, 1372, 986}], 
      Line3DBox[{951, 1230, 924, 1131, 881, 1295, 1296, 1292, 1580, 1634}], 
      Line3DBox[{962, 1348, 947, 1144, 1330, 923, 1130, 1328, 1326, 1582, 
       1504}], Line3DBox[{967, 1238, 949, 1232, 1231, 925, 1132, 882, 1117, 
       1293, 1493}], 
      Line3DBox[{978, 1362, 963, 1152, 1349, 1513, 1512, 1331, 1329, 1505, 
       1327, 1324, 921}], 
      Line3DBox[{996, 1257, 1166, 1387, 995, 1258, 1259, 997, 1260, 1594, 991,
        1163, 1384, 1256, 1595, 1640, 1385, 1255, 984, 1161, 1592, 1593, 1251,
        1571, 1365, 971, 1244, 955, 1148, 932, 1136, 895, 890, 889}], 
      Line3DBox[{1004, 1391, 1002, 1012, 1396, 1397, 1624, 1623, 1625, 1533, 
       1534, 1401, 1627, 1626, 1628, 1416, 1284, 1285, 1543, 1429, 1430, 1552,
        1444, 1070, 1204, 1071, 1459, 1219, 1094}], 
      Line3DBox[{1009, 1272, 1271, 1008, 1270, 1269, 1007, 1395, 1170, 1268, 
       1394, 1169, 1641, 1597, 1596, 1604, 1018, 1403, 1173, 1019, 1279, 1179,
        1029, 1435, 1185, 1041, 1449, 1057, 1058, 1208, 1079, 1110, 1112}], 
      Line3DBox[{1016, 1014, 1407, 1026, 1400, 1537, 1411, 1413, 1541, 1039, 
       1425, 1192, 1052, 1440, 1203, 1069, 1456, 1217, 1090}], 
      Line3DBox[{1023, 1176, 1276, 1406, 1175, 1022, 1281, 1419, 1282, 1032, 
       1289, 1043, 1187, 1044, 1196, 1060, 1209, 1081, 1227, 1114}], 
      Line3DBox[{1027, 1408, 1535, 1536, 1409, 1036, 1414, 1540, 1424, 1426, 
       1550, 1439, 1441, 1557, 1455, 1457, 1091}], 
      Line3DBox[{1034, 1182, 1035, 1291, 1045, 1189, 1047, 1198, 1062, 1211, 
       1083, 1229, 1116}], 
      Line3DBox[{1037, 1410, 1538, 1539, 1422, 1191, 1050, 1436, 1201, 1066, 
       1452, 1215, 1088}], 
      Line3DBox[{1048, 1190, 1049, 1199, 1064, 1212, 1085, 1486, 1489, 1491}],
       Line3DBox[{1051, 1423, 1548, 1549, 1437, 1202, 1067, 1453, 1216, 
       1089}], Line3DBox[{1063, 1200, 1065, 1213, 1086, 1487, 1490, 1492}], 
      Line3DBox[{1068, 1438, 1556, 1451, 1472, 1454, 1585, 1471}], 
      Line3DBox[{1084, 1214, 1087, 1488, 1568, 1590, 1591, 1639}], 
      Line3DBox[{1093, 1218, 1092, 1461, 1559, 1560, 1205, 1445, 1054, 1193, 
       1053, 1431, 1544, 1287, 1286, 1417, 1606, 1278, 1605, 1277, 1402, 1619,
        1620, 1617, 1017, 1618, 1006, 1530, 1577, 1576, 1393, 1168, 1622, 
       1267, 1392, 1005, 1266, 1265, 1001, 1390, 1389, 1003}], 
      Line3DBox[{1097, 1220, 1096, 1463, 1561, 1447, 1446, 1553, 1056, 1194, 
       1055, 1433, 1545, 1040, 1183, 1432, 1418, 1636, 1644, 1645, 1546, 1646,
        1434, 1637, 1184, 1547, 1579, 1572, 1573, 1448, 1555, 1554, 1450, 
       1574, 1575, 1470, 1207, 1077, 1484, 1107, 1111}], 
      Line3DBox[{1100, 1221, 1098, 1587, 1222, 1588, 1102, 1473, 1474, 1103, 
       1475, 1476, 1104, 1566, 1480, 1224, 1567, 1485, 1108}], 
      Line3DBox[{1105, 1481, 1630, 1643, 1629, 1565, 1223, 1638, 1589, 1478, 
       1477}], Line3DBox[{1109, 1225, 1483, 1482, 1106, 1479, 1076, 1469, 
       1564, 1075, 1468, 1650, 1467, 1074, 1648, 1651, 1649, 1647, 1466, 1072,
        1563, 1206, 1073, 1586, 1099, 1464, 1562, 1462, 1465, 1101}], 
      Line3DBox[{884, 1119, 887, 926, 929, 1146, 953, 1242, 968, 1154, 969, 
       1249, 1376, 1375, 1159, 980, 1252, 989}], 
      Line3DBox[{913, 1314, 1127, 915, 1501, 1315, 1316, 1509, 1343, 1345, 
       1516, 1357, 1359, 1521, 1522, 1370, 1609, 1608, 1610, 1528, 1529, 1381,
        992, 1165, 994}], 
      Line3DBox[{916, 1318, 1129, 920, 1503, 1320, 1323, 1510, 1511, 1347, 
       1151, 961, 1360, 977, 1364, 1525, 1526, 1373, 987}], 
      Line3DBox[{981, 1247, 965, 1240, 1239, 950, 1145, 948, 1233, 927, 1133, 
       885, 880, 1294, 1494}], 
      Line3DBox[{1010, 1171, 1011, 1275, 1021, 1274, 1273, 1405, 1404, 1174, 
       1020, 1280, 1030, 1180, 1031, 1288, 1186, 1042, 1195, 1059, 1078, 1080,
        1226, 1113}], 
      Line3DBox[{1015, 1172, 1013, 1398, 1531, 1532, 1399, 1621, 1178, 1028, 
       1412, 1038, 1415, 1542, 1427, 1428, 1551, 1442, 1443, 1558, 1458, 1460,
        1095}], 
      Line3DBox[{1024, 1177, 1025, 1283, 1421, 1420, 1181, 1033, 1290, 1188, 
       1046, 1197, 1061, 1210, 1082, 1228, 1115}]}, {}, {}}},
   VertexColors->CompressedData["
1:eJzdvHk0le33P64UylApEpKkgag0U9oSJRmSohBJiUwlQ4YMmUkp0qQSIjSI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    "],
   VertexNormals->CompressedData["
1:eJx0fHk01d/3PhqQQho0SRKpUCKlaBcNKmTIPM/zPI9pQEkyi9IgTSIyhMJR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    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 286.9624680486638},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-25, 25}, {-25, 25}, {-9793.8926279055, 11041.662023810175`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{-2.975384921837691, -1.0289809395006406`, 1.2402752892182078`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.421025047259*^9, 3.42102506255*^9}, {3.42102512574*^9, 
   3.4210251901549997`*^9}, 3.4210887572706003`*^9, 3.4210904760338*^9, 
   3.421090514597*^9, 3.4210905853898*^9, 3.4210906173542*^9, {
   3.4210907310626*^9, 3.421090773947*^9}, {3.421090853117*^9, 
   3.4210908677654*^9}, 3.421090933847*^9, 3.4210911191594*^9, 
   3.4210911576914*^9, 3.4210912148654003`*^9, {3.4210913627222*^9, 
   3.4210913786654*^9}, 3.4210914669146*^9, {3.421091557925*^9, 
   3.4210915982978*^9}, 3.4210916323682003`*^9, 3.4210916771870003`*^9, 
   3.4210917132542*^9, {3.4210917454058*^9, 3.4210918505654*^9}, {
   3.4210918971782*^9, 3.4210919154302*^9}, 3.4210919471138*^9, 
   3.421092052679*^9, 3.4212889947432003`*^9, 3.4212898109922*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"y_", ",", "ee_"}], "]"}], ":=", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "ee"}], "-", 
     SuperscriptBox["y", "2"], "+", 
     RowBox[{
      FractionBox["2", "3"], 
      SuperscriptBox["y", "3"]}]}], 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "y"}]}]]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4210273525889997`*^9, 3.421027395756*^9}, {
   3.4210274673*^9, 3.4210275085299997`*^9}, {3.421027550197*^9, 
   3.4210275754700003`*^9}, 3.421029744651*^9}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox[
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "i"}], "]"}], "TI"], ",", 
        RowBox[{"-", 
         RowBox[{"v", "[", 
          RowBox[{"x", ",", "i"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "6"}], ",", 
          RowBox[{"1", "/", "8"}], ",", 
          RowBox[{"1", "/", "12"}], ",", 
          RowBox[{"1", "/", "24"}], ",", 
          RowBox[{"1", "/", "100"}]}], "}"}]}], "}"}]}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", "1.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<y\>\"", ",", "\"\<x\>\""}], "}"}]}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4210272689440002`*^9, 3.421027307921*^9}, {
   3.421027588373*^9, 3.42102761676*^9}, {3.421027791468*^9, 
   3.421027806604*^9}, {3.421028061131*^9, 3.421028105703*^9}, {
   3.421028866112*^9, 3.421028892859*^9}, {3.4210291685299997`*^9, 
   3.421029211027*^9}, 3.421029282635*^9, {3.421029316984*^9, 
   3.421029381877*^9}, {3.421029415196*^9, 3.421029415811*^9}, {
   3.421029446531*^9, 3.4210294896029997`*^9}, {3.421029541283*^9, 
   3.421029603638*^9}, 3.421029744651*^9, {3.421030535196*^9, 
   3.421030587822*^9}, {3.421030973376*^9, 3.4210310080030003`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Hk8lIsCxnFMdEKKRCknFV17xI1Ez1S3kvUSyT3WCqFCRRunSXNEqWNJ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     "]], LineBox[CompressedData["
1:eJwVx3k8lPsewHFMdDJSJEo5qehikIkbiX5T3UrWSyT3WCuEaqho4zRNc0Sp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     "]], LineBox[CompressedData["
1:eJwllnk41VsXx4+6uF1Co25RKcNNilRIaiG3MpSxDIUMcQuphAyRuBkiKoSi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     "]], LineBox[CompressedData["
1:eJwVlnk01VsbxxUyRYlEpjIWIhKSPJV6M6XpIkPI7UYp4kbeSFIZQqhIqHRI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     "]], LineBox[CompressedData["
1:eJwVx3881HcAx/HjXFke6JLshkcl1EoPxmqSen/FYlYsv+XSFhX5NUch81h6
nFKJZEnziOFCOiQ/q+tGHFoxKmo5lh9tdKi177fjOuyzP16P1+O5+kCM10FN
FovlSvr/gXHJtionGv11Mkt+QiSElfcMB51piPsmdzYdF8I3sbCV+oqGvDzA
empTDiydU2NFHjRWHTh1mWdzBUrdkJXaPjR0KP1+R60CdD536YoIpLF5WePB
10ZFyCuxTP49mMb0NZR6M8UIj9b+1C6URl262EF0XYRimW2kQziNoTyxWM+8
FHKTfdVO0TT8S+yV5ull8HhYs+mbRBqZKy+7HjKuwGkzeaJ/Cg2Wo5tdlucN
NCctkgSfpLHmyOSugQQxbNcF7YjKoJFWr9xuXVGFiB/T0uKzaWisPzbs2VAN
UX91Z3IuDWH3429j9t3EijQtz7O/0Hgbe4b/3r8GquHKoLI6GjytC1mTG2ph
t+V5QdVtGjNre0Yt82sReUFzpF5Kw2jAYtV32nUY2u4f1tZJwyDeNNprsA6t
+ayjw3Ia3CkO70NcAzJ8vTONOQzCbDIODYTehkyc0mu2hIHXoO0kX3ob8+zy
5ev1GcRXTvHVK+7g+1vqn+15DGqsBBpNsjvw0S8t893IoHCd7pUPPAlMH8w0
Z/kymH/tcsm+RIoqx4J/2aUMQqXz50U3WmBgO3Yk4QaDTGXGP0WPW5C4dv3I
65sMnEs+9o2abYHTsoae3rsMPHl3DeN23sfTv7sqC3sZ5KhGO/cO3Yfq4tzh
rXMMUlPOTP2wqA2uE3y5wOc9nPQ3Redsa8fLS8ayYU0lyiM5Joahv8HiI8m4
yG0GsX1HpwPbe2AiifiSkz4L76a+l2UGT7Ewq3ldMKJC709dz6nTz/B+z71g
mYUa0+onQj/xC7z4fL+xhXAOC0frzuctGkKM/1KumXwexlfdll8seQkdd4HV
ST0WJdXRtso3H0H/xp4nSRIWxfVrfBXWOoqKApiPBWtQ6U3p6nqXV/Cv3sw1
ndeg3oVovFBL/sLxtKJUeYUmlSjc4jbpPY6ycdN8vV1syqMlKO1a9wS+5urZ
d6jYVGSI3MQpTAEhR9NYTlwrSVgsIJbOMnNviS1dl74rJrYZGWz95AObuvvG
vkMrXIHltZWe0cTC7LDYTuIhn92HDdVsKtvCSeYZoUBsXkZuyByberTw7Ehw
tAIVGSeSEolXXOX5ZhGPnYjnnyc+FxWAZmK/cL5ZI/GG8i4DsxgFHBysqpbM
synuqVzJK2It+UNZDXHSuyLdqFgFtvX8Wt5O/OhBg/Iq8bG22nMDxDv7Ooe7
iSfE+Xs4C2xKmT5WbyNQoDslYjCAWBWq2kcTLxbsb44i3v3njKtFnALUIe+S
k8TumfRnfsS3PLaGi4mTz45ymogVO6x3tRD3POt/M05s/sUa635i3b0df/Di
FQjeYLRMQezMrW91J768UodZIE6dK6xMJv4Pc3w3Qw==
     "]], LineBox[CompressedData["
1:eJwllnk0ldsbxw9d3C6hQbpFRYablKFCqJBbkTJmKrO4hTSZReJmyFRJKEpX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     "]], LineBox[CompressedData["
1:eJwV1nk01VsbB3BCpiiRKENlqFAiIckvqTdTmi4iRW43ShE38kaSBglJRUKl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     "]], LineBox[CompressedData["
1:eJwVx3881HccwPHjXFke6PJrNzxqQq30YFpN+vH5XhrWyi0/K+faoiKcOQqZ
x9LjrlQXqVWaR0wnpENyflSXN3FcK3YqV8ux/NrkqNa+X8c5Z5/98Xq8Hs9P
9ycFHzCl0WgBuP+/JyXTW88mkVqmcOemJYCw6oFdvx+JpL0T/k3HhBCWXtxG
fE0iTcVuz8l1F8HdLzu5NIhEy/afvMLyugo6y+il5qEksiCs1ZvMikD5cltX
/B4SrV/SeGDcoQQKJO6Zv/NI9PYGKguhrkMc3/yztTEkkuVIfUtvlsJ1hXeC
bxyJBgqkUivXMtA4RdWw+SSKkPjoXHPKIehx7bpv00mUu/RKwEHHSjjlokmP
yCIRbVPg2jzOLWjJWCDnnSDR8sMTO/rSpOC9MnJrophEonrdFs/Kaoj/SSRK
zSeRyaqjg5yGGihV1ygzL5NI2P30u6So22AvMuOc+ZVE75NPc6ciakE/WBVZ
LiMRy+x83sTqOli74WVR9V0STa9QDbsX1kHCedOh+mYSOfS5LfveXAYDWyJi
25Ukskl15gf3y6CtkHZkUEMi5iSDNZvSAOKwkFxHBoVivcQH+2LugkKa1eOy
iELB/d4T3Oa7YKRX2K6yplBq1STXYH8Pfrhj+MWHRaFaD4FJk+IehFqXlYet
oVDxSsursyw5OD+abskLo5BxfNslH0kzVG8q+pdeRqGYZuO50lutYOM9cjjt
FoVydeJ/Sp62QvqKVUPjtynkJ/k4LHGmFdhLGlQ99ynEYd23S/F/CM//7qoq
7qHQRf2wcu/AQ9BfmDu0cY5C2VmnJ39c0A4Bb7gaQegUYluv41/c3AGvLzkq
Bk11qCKB4WQX8xu4fSQfKw2cRsm9R97u6VCBkzz+K0bODApp6n1dbvMc5mdM
bwqG9Kjn566XxKkXMLXrAU/hZkBvDc+E4dJX8OqLfY5uwjk0f0R2rmDBACRF
LGa6aIzI8Vqg7QXJa7DYLvA4YUUjmi3MPQpdh0C9RvUsQ04jmOGNo7Ftw1BZ
hFxHeCZETlOOoX7bKETUrGc6G02ID9Emrwzyv+CYqCRbU2lKpAs3BE6EjEH5
mHOh1Q46EdQaKbrR/Qa+YVr5dOrpREK0xokdqwUhw9RRg10nT1sowG6eoebe
Y7sHLP5wHdtrqL/tk1k6cf+dT6dZnBZs66o4fGxhfmyyEnsgdOchOwOdyHdj
KzjxWkguEF+OnqMTT+ZfHObxtVApPp6Rjm1/jRWWhz1yPJV7Dvts4m7Ugh0e
x3VpxF5d0WXjkqQFX1+P6kVGOsE8eVk+im2meayoxc74UGKZmKyFzSqo6MB+
8qhBdw37aHvd2T5s/17lYDf2G2nhLsY8ndDljNR7CbTQnRXfvxtbH6OPIrEX
Cva1JGLv/HM6wC1FC8TBEMkJ7O255Ofh2HeCNsZJsTPPDDOasLVbPXe0Yqte
qN+NYbt+udxTjW25t/MPVqoWeKsdlmix/Zj1bduxryy1oOaxs+eKqzKx/wND
jlrD
     "]], LineBox[CompressedData["
1:eJwl1Qk0Vun/AHBpykiDlJoMpUKKyVKDkeZBRQzDqyQha0oS2Sta0NhlVLYQ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     "]], LineBox[CompressedData["
1:eJwVlnk4lVsbxokklbFIRZQhQ0WKQj1JSaKizCXE4aPJeGSIOkIlKunIVIZQ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     "]], LineBox[CompressedData["
1:eJwVz39QzHkcBvBtt6RQanVR10Wscltt6ef06/nOEVFxkVakZhy6VFadMzKc
dBt1oThLfsVK6lZhi0vdKpWEFiFFVipK+You7Xe3svY+98d7nnnNM88f71nr
RSs2slksVii5/3PAeI9Y9FINW31InHt4MgqeRJ/ep1KjrThnafC9DLDvnuWO
davhmIQ7ErEE8Td7/0h+p4b9scxRvuY0lOV8dvcHNZRxxXNbRVK4laSkRQ6r
scSnfRU0hZCcqRxq0qgRxAv1muVzEWNHdPH+OjWE8zxL4xeUIC5rwevLbAZX
vXTXPZ1kuL07O8phIoONRZO9Dg9ewsGfrYJNuAySu/PLpgiuYHjdWsWu6QxO
FrqWB0RfRdRKqceQHYP3H7hFg5ZyzAxycWh3YjBRwc7Rp5Qj0+OXE0tdGbzK
6Rp/Nr0C752qptZ4MCgI3DRcVF2Ba9xg/YUgBs6fOntZ/17D4oEYVWokA3dO
dTZvfiVKO8+v7Itm0PxONPy6uhJTW/vvR8cxaN8bnfSFuoGOmm1V1GbS+37c
arCoCluOHjhmls5gTe53Roz3PzgKxY+ySwyOL3spdLxfg1FP9l07OYNx/ryn
ud61iP0+BIf/ZnAn63e7J9JaOFq1uuyoI/+Yeiiz/G6h+j1tuqidQZgoeEKz
cR26JLaN3WwN/Jw/Jg4erEeZteyx1liDdUd68wer6rHzhG+n+RQNMlb/driw
tx7TzqzSBFprsHqOrNk3oAEhF3LnneRrMJRpv8S/rwHycs6hFZEaLNRxHVmC
RmQ8oqMaijRY+zo3cfRUE3gmiv4LIVqI68yjWsyUGGpy3Xw+XAvdznBYuCmh
2Celz67QIjZAEhYYoUSk4f6PJ2O0GKqtYIR/KiHWR4zkbdWiz2KP4Ow3D9Cj
fqffla/FjgmbDC7PeIhzPVzrVf1ayMvy2i6ZtOBbRWKwUdYobmVvSXL/9Bj6
UfZfqT1jSJhbrHJ98AxMxM3YRt4XuBuaLCv2eYEOzzhbnliHvsxa76Z7KoiE
Uy0cVF9hPuXQdW+bLkxamuqcYcaipGvoiGFZN9pcWp6mKVjUDMmi/ovCN5AV
YM7bWAMqfv7Drhtv3kJ4xdvC7qsB9UiSZDOyoQ87M6V7VTI25TOJP0Fg2I/i
frtTZmEcytJs+PORzAGEWpj5No1xqPULnnv/yqMhNmLbqojvuwW3XiSuGVXr
hojPRZemPCd263nVYDPOoVixCaX+c2lMqyhbvoU4watgFtuRRmdkeLzVFw4V
EfDZNNeJRkr+gWM/6ThUnyT0RQmfhuxAetoO4t3urO0dxG/Tt8UcJJZPvmI5
2ZlGVEKMQyVxSsZ4qIjYz8/5sulXDmUiWl7j5ULDUNXcKCf+nPBGWu9KI7Cl
tuQO8UTzgKAR4u23K3JeEreoD3XwBDQGSk9FGOnJPns2N5v44e7EV6uJr98z
Fi93o2GcGncrmdgmff7MvcTUppWFGcRUmlBRTly+zD+hlDjKM2/Eyp0G/YMg
rI54P1OYt5h4js9sQRuxflzunEYcy7e2pIl7FlbflREft5+k1hOHP1ZsUBH/
B2YFSyM=
     "]], LineBox[CompressedData["
1:eJwl1Qk0Vvn/B3DVVCMNUmoylAppmSw1ZaQJFTEZS0mFSKUkEVkqWtDYIqON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     "]], LineBox[CompressedData["
1:eJwVlnk01dsbxokklbFIRZQhQ0WKQr5JSdJAGSshLj+ajFch6gqVqKQrU4VQ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     "]], LineBox[CompressedData["
1:eJwVz21UjHkYBvBppqRQarRR26YYZaea0uvp7X7OUqJiI41InWPRpjJqrSOH
lXaiNhRryFuMpHYUptjUjm6VhAYhRUYqSnlEm+aZqYzZ/364z3V+5zrXh9th
vWjFRjaLxQon938OGu8Ri16qwVYfluARmYpFT2JP71Opob00b2nIvSxk3z3L
He9Rg1MK3JGIJZh4s++P1HdqsD+WPcbXnEZlJZ/d80ENyoTSeW0iKbqXpWVE
j6hhiW/HKtAUo+RM9XCzRg3BvHBvB9+LOH5ElxigU4Nwvld54sIyTMhZ+Poy
m4Gr3rrrXs4yvL07N8ZxMgMbS6Z6Hx66hAd/tgox4TKQ2lNYMU1wBUfWrVXs
msnAyWK3ysDYqxizUuo5bMfA+w/ckiFLOc4OdnXscGZgsoKdp0+rxGzPX04s
dWPgVV73xLOZVfjeuWZ6nScDRUGbRkpqq/AaN0R/IZgBl09dfax/r+HiwThV
ejQDHpzaXN6CaizvOr+yP5aBlneikde11Ti9beB+bAIDHXtjU75QN7CzblsN
tZn0fh+3GoTW4JajB46ZZTKwJv87I8bnHzwKih9llxg4vuyl0Ol+HY55se/a
yRmY4M9/mu+DGP99GBz+m4E7Ob/bPZEiOlm1ue6oJ/+Yeipz/G9h7XvaNLSD
gQhRyKQW43rsltg29bA14O/yMXnoYANWWMsea401sO5IX+FQTQPuPOHXZT5N
A1mrfztc3NeAM86s0gRZa2D1XFmLX2Ajhl3In3+Sr4HhbPslAf2NKK/kHFoR
rYFFOq4TS9CEWY/omMYSDax9nZ88dqoZeSaKgQthWhDXm8e0milxuNlt8/lI
Leh2RoKFuxIV+6T02RVaiA+URARFKTHacP/Hk3FaGMYqRvinEsX6qNGCrVro
t9gjOPvNA+xVv9PvKtTCjkmbDC7PeojnernWqwa0IK8oaL9k0orfKpJDjHLG
4FbulhSPT49RP8b+K713HJLmlarcHjxDJupmfBPvC3gYmiwr9X2BnV4Jtjyx
Dvqz0af5ngpFwukWjqqvYD7t0HUfm26csjTdJcuMRUnX0FEjsh5sd219mqFg
UbMkoQMXhW9QVgRz38YbUIkLHnbfePMWhVd8LOy+GlCPJCk2oxv6cWe2dK9K
xqZ8p/AnCQwHsHTA7pRZBIeyNBv5fCR7EMMtzPyaxznU+oXPfX7l0Sg2Ytuq
iO+7h7RdJK4bU+uGic/Flqc9J3bvfdVoM8GhWPFJ5QHzaJxRVbF8C3GSd5ED
24nGrujIRKsvHCoq8LNpvjONaYUHjv2k41D9kvAXZXwaZQcyM3YQ7/Zgbe8k
fpu5Le4gsXzqFcupLjTGJMU5VhOnZU2Ei4j9/V0um37lUCai5XXerjQaqlqa
5MSfk95IG9xoDGrFsjvEk80Dg0eJt9+uyntJ3Ko+1MkT0DhYfirKSE/2uXO4
ucQPdye/Wk18/Z6xeLk7jcbpCbdSiW0yF8zeS0xtWlmcRUxlCBWVxJXLApLK
iWO8CkatPGikfxBE1BPvZ4oLFhPP9Z0jaCfWT8hdMojj+daWNHHvotq7MuLj
9lPUeuLIx4oNKuL/AEiecKM=
     "]], LineBox[CompressedData["
1:eJwl1gk0VP/7B/BJqW8lS6QSiVZLslSk8mgvJVIptNC3khaKr4pCu0hZvpEl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     "]], LineBox[CompressedData["
1:eJwVlmk4lWsXx2XcUirKGEckOiFDprhaIkOSEDJkrOQ0IakjpWR2otMgsySZ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     "]], LineBox[CompressedData["
1:eJwVy30wFHgAxvFlSXIUqXV5TUs15WguvdDOs5lpSuq8JLnLMacjVi+Ors5L
taRySXdnhsQlxZ5tbdZLyXWIsrYidGbkZak2yb5UFH67W9r73R/PfOfzx7M0
+nBIjDGDwdhK93/NC9sPzs4l2FgW5bO5IQCplzaMzLckWOYl3RaQkoet9jKV
uw2BT5B/w/CtYthe3k04LIKEV3fOSvyv4oXTKHO3A8HH9066Q+7lqCpNWnBg
KUHNG98OqfAvpLkaOZ5yJ3hEDPnWGiG2lf+2smgVwVbTFTIvRiUWuTutq/Ei
KF2Z8zTwnRiKCrHfA2+Cd1H1HbyWKqRXPtw7AwJG2HKnJssa+HuEx1luIbCO
H+At6KvBYsnYEfZ2ggzlTNz+glrU1DIvhIQSdGQ47q02vokTa/OK4r8lOHb4
Gd+8+iZ21LtU8CMJjitt5FvCb2Hsb05LVRxB0JWhWI/ieixpPfZ+3nGCEpbt
HJepBmR2q8PuCwgGRrKOJS9rQmBw6r5BEYEmYk2H/koTHHrnJk5KCBxmBiba
ljSjvs/tV+c7BOm3NSTZ4i7Uw1H/pHURhFUKbC4ebEGoptd5LSEwtqqutHO5
BzfzxvHybVr4LVd/YHhJMSH7indtpxabHhPi+b0UjWeuqq+EaMGaOtnMOidF
qMnZt0URWiT+GHDA7qUUWYbgqd8TtTjKE7TOy2uHYvq1Ib1QC+eBH86rRmUo
VSxk7R7XIts2Ubgu9hEcGhO2mGbr0FZgJoehC7Zf6vWHcnUwc0qrhFs3LI5m
V/fn6RCrZfHZAd3QewrsxZd1uL88pbmkoBv9ZSOTIXU6XEppVHgu7kF+TnBJ
6YgOQcVFMsn1HljtXU98vfWQfyg1qn7wBAad8fUkhR4zRezSSU0vZoKbIqVu
n8Br8JGxxE8xuDbK3i1rFgP5LlP1J4ZweM8Ca1f5Z9g96Wdx7J7BYnvS6kwr
BvdVtSVH4/ECfR49vSmNDK5NtHDRSaUCohKwRyONuCUbH8+f5I9ij2SdteNn
I+6mEwH9ORZjSD19NUMuMuZ6sANPxdS9RsW4Y7HVDib3eej1h2JfJQKsrTbI
9Ewuhx30HVOhQpapsb2cOrePI/GmbtZNz05Qd5S7msRReymG7y/5yOR25j+5
0UltW3cj8BC1vLuNUfBShZHQnfsXfaL/fxmCFa9U+KnwfMG+WSbX8XTP2M5x
FUTn+Sm/UPvZX/PhU4/yj0TkUk/28i7UUofFR7jepr5944U3S6mCj8/qqnmf
mdyWuTFZz6lN5B3SGmrduXvOyWoVOD13he3UCdFzkgXUR9vqcoaoJVGb259S
K8XFwaYGJvePzj8PbNKo0HU8YTicev/PygbTNyqYJUW1HKT2zxiz2EDNjd1V
lkktvDkYyaOu/cY3XkwtyhOadFOr/Tx3tFI3cDL3GL1Vgb1+mWcf9ULrXaKv
qSNXsWzU1NNf2M/GUF90tpg2UOeuGQwspP4PbAQ9QQ==
     "]], LineBox[CompressedData["
1:eJwl1gk0VP3/B/BJqaeSPW0kirIkS0UqtJcSqRRa6KmkTfGoKLRLm+WJrBUp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     "]], LineBox[CompressedData["
1:eJwVlnk41dsXxhVCSkWXKK5IdC9CZYinLRJJopAhYyW3CUldDUpmN3UbhAxJ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     "]], LineBox[CompressedData["
1:eJwVy30wFHgcx/FlydMRUus8p0VNOZqLhJ3fZqZBOA9J3eWY03lawtHpPNWS
Hi50d2ZIXCKcjWU9Jdfhq7K2oujMeFzKhuxDDwq/3S32fvfHZ97z+uOzPSo5
JFqdQqF4k/1fnbKBU+vaGB2oiXQ/2OUHmdfdZjfrY7TDme/jl1EM3uYCib0x
Ru5Bvl0zdyrA5MZRzKBhlLBw7xLPtxrmrOapRy0w+vTBSpFkXwvNVamGidsx
an3jMcjn/AVZtmqW5+0xeoJVJUYyDvjU/rarfDdG3po7Bc6URthqb+Xa6oxR
1a6C8cB3XBDVc70euWD0LrJzkNXXDNmNj0+sIYwoYQ5WPfqt4Ot4PE7/EEZG
8ZMsw7FW2MZbPE0/jFGueC0utrQNWtuoV0NCMRrMtTzRot4BZ/cVl8d/i9GZ
5BdsnZYO8O+0qWdHYJQjNhYeOn4HFv9m9DXHYRR0czrGsaITzO6f+aCbg1El
zWSTzUoX5A1Lwx7WYTQ5m38mbUcPBAZnnpxqwEgWvndQebMHLEa1U5Z5GFms
Tb7vN+uFzjG7X63vYZR9V4bT9ACkM5H/ZD3DKKyxzvjaqT4IlY1a78MYqRu0
NJraPAA7ne6lWh858nKQfqQ48+G94CvWrQA58nyKsdP3fOi+WC29GSJHtJVz
vbQrfAjVuPS2PFyOUn70SzR9xYd8VfDK7ylylM6qu69bPACi1deq7DI5sp78
oVAyL4Aq0Rba0SU5umySwnGNeQIW3QmHNC8rUH+plhCpnoHJl0plUpECaVll
NSK7YdBLv9wyUaxAMXIam+43DEqnOnPuDQV66JDRW1k6DBM1s8sh7Qp0PaNb
5LRtBEoKgiurZhUoqKJcwLs9AgYn9mMPFyUSfqxSa3n0HFQK9dupIiVaK6dX
LctGYS24J4Jv9xmxutwFNO44TO2LNLfLX0eTJTYrnWenIfmYoZGtcAOZPp+g
MUxfgN7h1D15BhTmQos+Q+Y4B2OOI6MZ3RSmcRRn6zmxCBoqEX0+Qo1ZeeDp
5mX2PBzjuRpZbqgxPc/6TRToLULmhepcYYM605EeeD66/TXUL1lWGPhTmS9D
bz/meojBz8jATaCkMhn0oO+oIgnka6qbC4mLxhg8F+Jexer6e+LBWluNOGJn
0cxDs09U5lDJ86YhYpP2psAkYuFwP6X0lQRmQwNit34m/38pdTsXJPBTWWHp
yXUq0/LCyGLAkgQaCtkZvxB7md9yZxPPs0+HFxEvj7KuthGHxYfb3iW+2zTn
QhNLwN19T7PuBpXZpx2d/5JYQzjIbyVWXHlgnSaVAGMEOAPECVGb0uqI0/vb
C6aJeZEHB8aJxdyKYE0VlfnH0J+JnjIJPMtJmDlOHPuzuEvzjQS0UiP7ThH7
5i7quREzY47U5BFzOqYiWMRt33jEc4kbijkaw8RSLyf/+8RdjLxjam8lQN+/
w2mMeIvRkYaviSN204ylxKtfmK9HE1+z1ltVERftnQosI/4PPBZgwQ==
     "]], LineBox[CompressedData["
1:eJwl1Xk4VfkfB/CbpZmaIqJFtqSyJUtilL5CSkWSpUglpZGyTVImV5pKJrKv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     "]], LineBox[CompressedData["
1:eJwVVXk41PsXdu202GqQilCUNqOFqJOxTZmUJYlmLEVukUKlYhAiheyqsY+Y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     "]], LineBox[CompressedData["
1:eJwVy3s0lHkAxnEz02hrdqdItd3WUnPaXOIU0vV562wNjbaMSTc7U9hiqdTY
chl7kGS3bLLtGqvksq5JLqEyCI2mdJlNRGFLbBqXtC3vO5PL/vrjOd/z+eOx
8D4s/o5tZGTkSvaxTz9UrkzX0NBKsvd8biHHF15/FfrepbHPo72u2/cE+jpk
leEPacgKzZNvPEvCddngncQmGj9HOL16sSQNsS8VT/JaaRTXxt6sj8qEhw/v
5a0OGo/dBvyjvLLxZU/ywNMuGn9zqzaJenIxsP8rw+BrGizxr/IZyy/jZm+5
sfEAjeDezU5qjyuQ9DeZO9A0lm1XVtBJRbA45G0jGqWRHLRwmyi8GINvh5y9
WQyc5Pbvp0lKEPf+M3ECj4GPgCdAXylUBmFMvzkDk82LlEvvluMnRUsCR8DA
w6pRcEpeAc9x34tzrRhkbis7Ej3nOoZY0eUuDgxOTD4xWrbrBgRTVL1/ujDg
my3QSksqMXRn6fcZWxjop0d4Xl2ngio2ve+SmIGrYc25ZI0KkkmnBv/wYqA8
OV5a01yFmAn3/xKCiIV+lbLWGnQNv55QKBmYnn01nKapReG13VFhFxks0eat
cWLVIUz+gB2SwaD53DnpipV1MH1XwpUXMChKGWMl5tRhfX8Ez/8Wg0DYf2L9
Yz3SumbM3t7LoL46zEQ4S43A9FileIDB21O2Cb8I1XDeq5+z7V8Gu7M9v1WE
qKHt6JwvGmXg6B8skrSpMdGaZ7l+uh5pMzFrWVIDpI+w1NZZj2kcKtiFq8F8
VcBGbpweuSORXm+v3YPZHIPhULwe6/ze1FS/vAfesbii1kRi4fG2XfxGGOyy
5hVc1MPniMKW3t+I1szOd+JSPeLV/iW9M+/jt9PuqWmdemjCtUW+AQ/A37OC
Xu1owHF56IcL+keY0LPzjnYZcN9F3SCUPcaIe5VULRjF8ykVDV8fbMEzB9k8
QcwYaOsDVm4hz3B4x3QTy/ZxaOaLDZtWdoK3+ahNNN+IagtdrAi9/wItttqm
UJURNdh0O8z0fBfyU7GoW8qiAvdc8E5x6MaOq04mC8ZZFMfK3iWzoQdhJ9Oj
2vPZ1AObJZEbf3iNnN4FKXw3DtWt5I8Msd9AZMJ3vmPgUCM79wq3FuoQw2XP
a//o1VOto4mr9cNjQ8TBVbn8MmL7ro76uR/I/0J989yrOpiVXtl6iHhLc5DP
P8Sdki0HZo5yqFS/PEVEsQ5HlGd+9xnjUOzR89mXr+mQfyYyNIRYvbwprpO4
OzLYK5443dQ4wKRMB09/L8sK4isNrnbHiVetsimcOs6hiqe5Vmwo12FSe6O6
mDhh32J1W4UOa7U1uQ3EXOui7E+v63Dsdunp58TPL9nGgfhNQYo7d4JDac4Y
i7KIH0YEdOwkNgu31wbd0GHyUdmtg8SCHGlxJjG13yMzmrg6Miqxhbjkm9X+
BcSpa7Mka27q0LfBzq2WONAi2/Ew8aIVC+1aiFtKU2ZlEEutZ5v2EVsMn6Sf
ECeZ84YniM/2+LZOrtThfx5FUUg=
     "]], LineBox[CompressedData["
1:eJwl1Xk4VfkfB/AbaaamSKVFtqSylCyJUSKkVEqyFKmkNFK2ScqENJVMZMuS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     "]], LineBox[CompressedData["
1:eJwVlHk01fkfxo2dFqK5aCMqog0tRH2y3yJlSYa51zKRqaTFNKYQSaQke4t9
iZt9vZZ773O/3xbraBMmSolS/YRGE0b87vzxPu/z+uN9nnOe57yfld4Bjj7i
YmJiSaL5b0vI/vrDb84UIiK8L/0v/RQYEXG7gw0oNF6Ifbb6eTKi6kteXJSn
ELsje79daSYmR9uOxg4IsVTh1gpWeC781nycSW4QIlN+xcOe6Dvo+Vn2WkaC
EI7627se6HDATFyjXnBEiML4K28nQ4tQ12JZXmYuRKWLpoZUegnWiv1iVrdE
iNHe+2zHa2Uw8BfPDx8CeOvIg0Ml5VB+sbMpIRn499uLY4yLFeis4s6r+SpA
sL+G2eJ5VajRmFj/MF8A8fNRO44KqpASu2l/9wEBEkrFOqP9qnHwMCdpqoaP
8cWePgl5NQge1/vNxoOPAXuunaJlLXLOlR5IluVDJ03ztHpfLUbiqhj67jzU
TdhftpjkQmnJ1m+hkjxEJqprOYTUwSivrru9pBGT4j6qwzN1iKjj3/ATa8RT
vX3fFUbqUWi+649aTgMMV4ykGrEb0NFO/yTp1ACNnoHUZW0NUHvTtCQrvx55
Z1W3TN9oRJnc07TuPXWY2qNVaCzPR2eic8jqCS4YBzJ7Utl8TC/vZp1O58Lg
jb74/HI+rAz6ViiM1YLr49PD2SPAER577uebtTA4WuUumyTAdes3/XfNa2Hq
9PfQuxcC9Lq9y7JOroEtK1hwzgsQG/ILT9pZA3nLmktu2cCagE9eA++rwZ5l
XZTvB05GjGmGbq/G8VanvYt0hZApns6r6a+Er0FVc0CiEOu2hkRKXK6EW/oj
5dAiUc7COR8Hg0rcVbiSWEoLkd4pqT0iyunh8PqzVz8LQbOjZEw2VIBuC2RZ
SlAYHpYbju4ux4ae+jOGKhQMvy/krNItR6dvY12LKYWKhVrKQ3fKEPaTXcof
9hRmNHU6w6ZKUWCbr3bKg0KCrYFLXUYJvFWY5+3OU3jpsU3FebwYDN5YxZZr
FHQCTXtGLYrR5p288UwaBUGatZv2h7vI3cxUledSkKuwXXrP5C7WSdlyf7lH
wfnB/j72NQ4yT1ycv/IRhY8jbuwUw0J472dMPxmksEXcU93gUgH054L6Wz9T
CGP4vP6z5w4EzhwVg0kKDBLgLRWaD2m1hQsOyNHwcgrUyn6cB7t/n7r+uIhG
8eE/Bk218rCq4zRjryqNb+dC83t+ywWlxf1pdgUN8+sRvoHNObja7KClt5pG
bF60tuLSHDR7FHs916XRUxc7XOSfDem16eOzG2lo/ZnAsRFm4QuPkcnZTOP4
m9Qjb5WyYB7avrrbiAb7CUNKbSAD33llk3tNabzp/775aEY6cppno90IjUOf
Bw/x3dJgrv9m6awZjXczbUkKKrfx8mPbJ2NLGn7zqu57PbsJx5weHQVrGp/U
bk1Uxd2Aq5/qVKiNSE8nfJW0XSpuTLwJimHSGNvq5+wqmwJzwdJGg900Tlnt
u3j3fhLEtC60BIn4q9PW6pmwREg8+ZDHEnGQ9/JB+x0JWJsfajUgup8+Ibk4
e+o60nXnbsmIeGq2K+rd0TisfzdxtUOkP7s0/33M4FWcTPowvc2KhoTxaZuN
rBionb/Js7SgIetiVvDseRSU52nlfN1FY8FpBZkg+0h0ZBgG2u6koXT9pe+y
pguI+K4/YW1CQ6Wk6KGQhOGwgW/f8DYaRkl/27WeOIfLq9Rf64v8NO+Im6/s
fQaWH58XaW6iYSe7rt3d6SR+H7cfatSjETYev76m+2c8iG1V+biSxv4qKddy
YzOEb+8zCVtGwzNYtUjO1IZo3xZfRTH+8+fAsX65IyRrz2JHK3mRf17X/rmj
fIosMU6LvywhykP7y1a25u/k5Whq9NkZCoV/9bm/ywwjzKFZ+0MjFHJ5C2fM
tCPIu/l/D7OGKGRk7kpLL40kbFbkI6mXFJJ88vqc+TFE8WZjj1cbBeFkTamX
fwJh513+1zGPws6PHaEKFYlkrs3RvOmmqNd739vzJ5II3a4z9kn0L7UCtVHV
4FTi8/yZlk0QheKLIRsfx6SRls5xTaYNBd0zKXMhHenE2JAnZrGdQsHhskd6
SpmELvP99nkdBYf8Me699izyGK/U3BZRsIvWdFV3ziVfUxcwz3UJYW5/6UaX
dyEpOivTe99BiN+vSktuVuKQNEZXuOlOIYpbLwXEUxzSfyzkppOobxg2UdZ2
GkWE8cFbyPpBiE8keoJ6WULoTQOh6QcAjVBZT/XYUqLtbqXK1gFceNFtwaZl
5HQY84rDtACeaZZPbu8tJ2Wjer3NtwVoVbUqdCmuICvbGY11nXwMbpNiS0lW
kitBiyIfZ/Ex5/JAudq9ktwxPmUsc4yPzclW5xfNqyLRtT+63Z/jIXORtUv7
r9XEMOWkosoyHgLlbSTNtbnEfmZQsHxVA66tlWkYC+USi6n4EI3X9eAwmwIy
u7hEqeDb89Fb9Xh1yaZ3JrKOTEhzbj+dXw+mBLOSO1hPRmr92bdec+GtKevn
a9pAojwtev+J5yLErHn5j0kNRMXK/1WrGReV55mXT1k0kvcG5p4ZabVYPsP0
XJ/DI0qr/aUX7KiB0VI5Rt8Uj0hPKq+xel0Nx+0tbTEOfGLHyGg6GF6N6KDd
24bFBMQjIOxVCq8KOalyIymuAlLA0kkLc6kCv7Ylx6pcQGw7fwkUjFTiy8Tu
hbkeIIdvpNMXlCuxYLH8fQcuSPmGQKns7AokqQ2ZhskIiYvaia5d6ypQapT/
ZYOHkEgEOOj0bimHCTNyr/QVIWkbKnlr5VeG5oM+hS9rheSkv7K7uHsp3p5Z
zb66kCLiTXMRWSuK4Xtc2zPVmCInJu3cA77cxUeftd45hygibdLRso/LgT9L
71BJnIj3ZQRIHi3EmPN637oGiujm1hwrki9AoN1Gv3tDFOnfHpd6OiEf3yz0
j3Qo0mRTsAlT/XsuzpoYHvvLhCZN33l5WhY5mDXYcnzQlyZOe/pZn12zcEF3
24nReJrsYBl5LHBJg5Sm8alpHk2kix/qja1JRbSaSaDUME0+KOUlxnheh5Le
2IUPivfIwETlJ8Unx/B/h+njhg==
     "]], LineBox[CompressedData["
1:eJwVy3s0lHkcx3Ez07A1u+MSWtFa1ZzW3SlJUb+nztZg2DIm3exMYStLpcbm
NvYgYTdt2HaNVSKbKPdrGL4ujaZ0mU2EsCU2jWvb8jwzueyvPz7nfV5/fCz8
T/G/o2tpabnjfezzDw2bcxUkUgryD31uIYYv/P4qCbxPoiM+/a3DgedgbEDU
EP2YRKIS88y6vgy4I5q8l95Jop9jnF6/tMyBxFeSZ4U9JCpvSaxvi8sDnwDW
q+YBEj31nAiK88uHL0cyJ54PkehvZuMu3kgBTBz9SjP5hkQ0/q/i5RtuQ/1o
jbb2BInCRj2c5D7FIBjvNHckSbR+r7SWzCgDi5P+Nrw5EmWGrtnDiy6Hyalp
Z38ahZzEDu91BRWQ/P4zfiqLQgEcFgeNVYJMw00YN6eQvsdaqd39GvhJ0p3K
4FDIx6qDkySuBd+FwKsrrSiUt6f6dLzJHZimxde4OVLonM65ueoDdcBZKhv9
041CbMNVSmFFA0zfs/v+uheF1HoxvqXbZCBLzB27xqeQu8Y1LVMhA8GSpMk/
/CgkPb9QCV2NkLDo/V9qKDb3eIOoB2Bo5s2iREohg0uvZ3IULVBSdTAu6iqF
LJWFrk60VogSP6JHXKdQV1qacNPmVjB4V8EUF1GoLGueln6zFbaPx7CCmikU
ghw+sf6xDXKGlq/YO0qhtqYofa6xHEJyE6X8CQpNJdmm/sKVg/Nhtcmefyl0
MN/3W0mEHJQDg2a8OQptDArjCXrlsNhTuHq7nhrlGCHj9RntIHyC7Gyd1UiX
QYS5MRVgJgveyUxWo4LZWL+pqgdgaKLRnLyoRtuOv4WmVw+AdTa5rCcdmxve
e4DdARr7G6ZFV9Uo4LTEljzaAT15g+/4lWp0UR5UMWr0EH674J2dM6hGimhl
WWDwI2Af2kS6bNSgcHHkhyvqJ7CopheeGdKgh27ydq7oKcx6NwrlnDn0Ymlt
+9cnuqHPUWTKSZhHpPUxK8+IPji1T09/df8CUpjxNbs2DwLL44xNPFuL6I1c
J4l8+BK6bZWdkTItYrLzbpTB5SG4lY3WDgtpRMihK/5ZjsOwr9RJf9UCjWBY
ObjltY9A1PncuP5bdOKRjWXszh/ewM3RVVlsTwYxLGXPTtPfAk+f7XxPwyBm
9x/m7i5RQQKTbtr/0S7LrOOxm9Qz89PYYY0F7Gpsh6GBtpUf8P9KW9fKUhUY
VhbvPont1RUa8A/2oMDrmNEcg8g+XiiJKVfBaWnK7wHzDII+dzn/dpUKbqXE
RkZgyzd0Jg9iD8eG+V3EzjXQDtavVoFvkN/qWuzidnf7cOwtW2xKli0wiHJd
99odNSpY0t8hL8dOPbJO3lurgq1KKGjHZlqX5X96RwVn71ZeeIH94pptMsJ+
W5TlzVxkEIoUbd4N7McxwQP7sQ2jHZShdSrQOSNqPoHNuSksz8MmjvrkxWM3
xcald2NXfOMSVISdvfWGwLVeBWM77D1bsEMs8jeewl67aY19N3Z3ZZbxdWyh
9QqDMWyLmfPkM+wMc9bMIvalkcAenQYV/A9nk3XI
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"x\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  ImageSize->{676., Automatic},
  PlotRange->{{-1.5, 2.5}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.421030593064*^9, 3.42103061442*^9}, {3.421030978141*^9, 
   3.42103099026*^9}, 3.421031309646*^9}]
}, {3}]],

Cell["The Jacobian", "Text",
 CellChangeTimes->{{3.4210297936289997`*^9, 3.421029805418*^9}},
 FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"j", "=", 
  RowBox[{"(", GridBox[{
     {"0", "0", "1", "0"},
     {"0", "0", "0", "1"},
     {
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"2", "y"}]}], 
      RowBox[{
       RowBox[{"-", "2"}], "x"}], "0", "0"},
     {
      RowBox[{
       RowBox[{"-", "2"}], "x"}], 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"2", "y"}]}], "0", "0"}
    }], ")"}]}]], "Input",
 CellChangeTimes->{{3.4210003809678*^9, 3.4210004244294*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"2", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "x"}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "x"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"2", " ", "y"}]}], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.4212851114214*^9, 3.4216005069877996`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "j", "]"}]], "Input",
 CellChangeTimes->{{3.4210009239035997`*^9, 3.4210009316099997`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"2", " ", "y"}]}]]}], ",", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"2", " ", "y"}]}]], ",", 
   RowBox[{"-", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"2", " ", "y"}]}]]}], ",", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"2", " ", "y"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.4210009355411997`*^9, 3.4210017872019997`*^9, 
  3.4216005098426*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", "j", "]"}]], "Input",
 CellChangeTimes->{{3.421000952748*^9, 3.4210009588008003`*^9}, {
  3.4212850956498003`*^9, 3.4212851039646*^9}, {3.421285137177*^9, 
  3.4212851583472*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", "x"}], "-", 
         RowBox[{"2", " ", "y"}]}]]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", "x"}], "-", 
         RowBox[{"2", " ", "y"}]}]]]}], ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "x"}], "-", 
        RowBox[{"2", " ", "y"}]}]]], ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "x"}], "-", 
        RowBox[{"2", " ", "y"}]}]]], ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}], "-", 
        RowBox[{"2", " ", "y"}]}]]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "x"}], "-", 
         RowBox[{"2", " ", "y"}]}]]]}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "x"}], "-", 
         RowBox[{"2", " ", "y"}]}]]]}], ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "x"}], "-", 
        RowBox[{"2", " ", "y"}]}]]], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.4210009596432*^9, 3.4210017912424*^9, {3.4212851054154*^9, 
   3.4212851453826*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"vv", ",", "ff"}], "]"}]], "Input",
 CellChangeTimes->{{3.4212859840084*^9, 3.4212859887976*^9}, {
  3.4212869608492002`*^9, 3.4212869616292*^9}}],

Cell[TextData[StyleBox["The Potential and it's derivative",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.4212861246736*^9, 3.4212861742192*^9}, {
  3.4212865103992*^9, 3.4212865237060003`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vv", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"], "y"}], "-", 
     RowBox[{
      FractionBox["2", "3"], 
      SuperscriptBox["y", "3"]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.4212854383984003`*^9, 3.4212854571028*^9}, {
  3.4212859979547997`*^9, 3.4212860004976*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"vv", "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"4", " ", "x", " ", "y"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"2", " ", "y"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["y", "2"]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.4212865076535997`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"vv", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "\[Equal]", "0"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4212851668648*^9, 3.4212851726368*^9}, {
  3.4212852294364*^9, 3.4212852400755997`*^9}, {3.4212853363431997`*^9, 
  3.4212853387144003`*^9}, {3.4212853855612*^9, 3.4212854157004004`*^9}, {
  3.4212854553712*^9, 3.4212855073972*^9}, {3.4212860064256*^9, 
  3.4212860083756*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["3"], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["3"], "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.4212852413548*^9, 3.4212853397128*^9, {3.42128538904*^9, 
   3.4212854160436*^9}, {3.421285467586*^9, 3.421285509784*^9}, 
   3.4212860105128*^9, 3.4212870654784*^9}]
}, Open  ]],

Cell["Extremum points", "Text",
 CellChangeTimes->{{3.4212862119868*^9, 3.4212862355896*^9}},
 FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", " ", "y"}], "}"}], " ", "/.", " ", "a"}]], "Input",
 CellChangeTimes->{{3.4212862448248*^9, 3.4212862453708*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox["3"], "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SqrtBox["3"], "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4212862462911997`*^9}]
}, Open  ]],

Cell["The value of the potential at those points", "Text",
 CellChangeTimes->{{3.4212862119868*^9, 3.4212862713292*^9}},
 FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"vv", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "/.", "a"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4212857499304*^9, 3.4212857899912*^9}, {
  3.4212858318772*^9, 3.4212858693171997`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "6"]}], "}"}]], "Output",
 CellChangeTimes->{3.4212858715168*^9, 3.4212860140383997`*^9}]
}, Open  ]],

Cell["2nd derivative", "Text",
 CellChangeTimes->{{3.4212862119868*^9, 3.4212862355896*^9}, {
  3.4212862826392*^9, 3.4212862884736*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"vv", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}], "[", 
  RowBox[{"0", ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.4212863203912*^9, 3.421286332606*^9}, {
  3.4212863653816*^9, 3.4212864284524*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"4", " ", "y"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "x"}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"4", " ", "y"}]}], ")"}]}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.4212864391228*^9, 3.421286440168*^9}}],

Cell["2nd derivative discriminant", "Text",
 CellChangeTimes->{{3.4212862119868*^9, 3.4212862355896*^9}, {
  3.4212862826392*^9, 3.4212862884736*^9}, {3.4212870487552*^9, 
  3.4212870530296*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"ff", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"4", " ", "y"}]}], ")"}], " ", 
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"4", " ", "y"}]}], ")"}]}], " ", "-", " ", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "2"]}]}]}]], "Input",
 CellChangeTimes->{{3.4212869703184*^9, 3.4212870273052*^9}}],

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"ff", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "/.", "a"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4212870202539997`*^9, 3.4212870215176*^9}, {
  3.4212870755559998`*^9, 3.4212870793936*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.4212872393403997`*^9, 3.4212872412124*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"4", " ", "0"}]}], ")"}], " "}]], "Input",
 CellChangeTimes->{{3.42128724388*^9, 3.4212872949856*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.4212873000556*^9}]
}, Open  ]],

Cell[TextData[{
 "2nd derivative discriminant\nthe points ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox["3"], "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SqrtBox["3"], "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}]],
  CellChangeTimes->{3.4212862462911997`*^9}],
 " are saddle points\nand ",
 "{0, 0}",
 " is a relative minimum"
}], "Text",
 CellChangeTimes->{{3.4212862119868*^9, 3.4212862355896*^9}, {
  3.4212862826392*^9, 3.4212862884736*^9}, {3.4212870487552*^9, 
  3.4212870530296*^9}, {3.4212873052192*^9, 3.4212873897088003`*^9}},
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"fe", "[", 
   RowBox[{"ee_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}], "3."], "+", 
   RowBox[{"2.", " ", "ee"}], "-", 
   SuperscriptBox["y", "2"]}]}]], "Input",
 CellChangeTimes->{{3.4216261799062*^9, 3.421626220513*^9}, {
  3.4216262777181997`*^9, 3.421626293053*^9}, {3.4216264592553997`*^9, 
  3.4216264602382*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fe", "[", 
    RowBox[{
     RowBox[{"1", "/", "12"}], ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.7"}], ",", "0.8"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4216262264254*^9, 3.4216262627265997`*^9}, 
   3.421626319027*^9, {3.4216263613966*^9, 3.4216264956345997`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1mk4Vl0XB3CkJFNSUiQkY0n0IMqSSuYojaRQnopMoVSGIiUi1G2ohJQx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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.7, 0.8}, {-0.5519999271428594, 0.16666663191192851`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.421626481501*^9, 3.4216264965550003`*^9}}]
}, {2}]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fe", "[", 
    RowBox[{
     RowBox[{"1", "/", "6"}], ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.7"}], ",", "1.4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4216265319826*^9, 3.4216265555542*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1nc81d8fB3CbJDRUFBmRvck3420nlFUqki1lZpSQnYRkRJLsmRGypWMl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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.7, 1.4}, {-0.3853332313333377, 0.3333332335520816}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.4216265336205997`*^9, 3.4216265566774*^9}}]
}, {2}]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fe", "[", 
    RowBox[{
     RowBox[{"1", "/", "4"}], ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "0.7"}], ",", "1.4"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{3.4216265681278*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4lU0UAHA7oVCUFjtFkaLwFR0pWVIiSRSSJGRLKEuUJFtkl+xbhZCd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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.7, 1.4}, {-0.218666564666671, 0.4999999002187483}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4216265691730003`*^9}]
}, {2}]]
},
WindowSize->{1003, 664},
WindowMargins->{{0, Automatic}, {Automatic, -15}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (64-bit) (February 7, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 240, 5, 33, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[833, 30, 4773, 140, 276, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[5643, 175, 177131, 2993, 374, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[182777, 3170, 74098, 1216, 302, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[256878, 4388, 56319, 927, 302, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[313200, 5317, 183223, 3005, 302, 112644, 1848, "CachedBoxData", \
"BoxData", "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[496460, 8327, 586, 17, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[497049, 8346, 1827, 48, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[498879, 8396, 84420, 1414, 449, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, {3}]],
Cell[583311, 9813, 108, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[583444, 9819, 490, 18, 72, "Input"],
Cell[583937, 9839, 682, 22, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[584656, 9866, 134, 2, 31, "Input"],
Cell[584793, 9870, 716, 26, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[585546, 9901, 223, 4, 31, "Input"],
Cell[585772, 9907, 1908, 67, 91, "Output"]
}, Open  ]],
Cell[587695, 9977, 194, 4, 31, "Input"],
Cell[587892, 9983, 195, 3, 34, "Text"],
Cell[588090, 9988, 541, 17, 45, "Input"],
Cell[CellGroupData[{
Cell[588656, 10009, 233, 8, 31, "Input"],
Cell[588892, 10019, 526, 18, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[589455, 10042, 731, 20, 31, "Input"],
Cell[590189, 10064, 940, 31, 50, "Output"]
}, Open  ]],
Cell[591144, 10098, 108, 2, 34, "Text"],
Cell[CellGroupData[{
Cell[591277, 10104, 174, 4, 31, "Input"],
Cell[591454, 10110, 528, 20, 50, "Output"]
}, Open  ]],
Cell[591997, 10133, 135, 2, 34, "Text"],
Cell[CellGroupData[{
Cell[592157, 10139, 267, 7, 31, "Input"],
Cell[592427, 10148, 223, 6, 45, "Output"]
}, Open  ]],
Cell[592665, 10157, 152, 3, 34, "Text"],
Cell[592820, 10162, 425, 13, 31, "Input"],
Cell[593248, 10177, 553, 19, 45, "Input"],
Cell[593804, 10198, 210, 4, 34, "Text"],
Cell[594017, 10204, 521, 17, 45, "Input"],
Cell[594541, 10223, 271, 7, 31, "Input"],
Cell[594815, 10232, 215, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[595055, 10242, 207, 6, 45, "Input"],
Cell[595265, 10250, 68, 1, 30, "Output"]
}, Open  ]],
Cell[595348, 10254, 792, 27, 93, "Text"],
Cell[596143, 10283, 423, 12, 48, "Input"],
Cell[CellGroupData[{
Cell[596591, 10299, 481, 13, 31, "Input"],
Cell[597075, 10314, 5872, 102, 238, "Output"]
}, {2}]],
Cell[CellGroupData[{
Cell[602981, 10421, 407, 12, 31, "Input"],
Cell[603391, 10435, 9445, 160, 244, "Output"]
}, {2}]],
Cell[CellGroupData[{
Cell[612870, 10600, 385, 12, 31, "Input"],
Cell[613258, 10614, 9569, 163, 239, "Output"]
}, {2}]]
}
]
*)

(* End of internal cache information *)
